/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.api.gui.EnumNavigationTab;
import sonar.fluxnetworks.api.text.FluxTranslate;
import sonar.fluxnetworks.client.FluxClientCache;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiTabCore;
import sonar.fluxnetworks.client.gui.button.FluxTextWidget;
import sonar.fluxnetworks.client.gui.button.InvisibleButton;
import sonar.fluxnetworks.client.gui.button.NormalButton;
import sonar.fluxnetworks.client.gui.button.SlidedSwitchButton;
import sonar.fluxnetworks.common.item.ItemFluxConfigurator;
import sonar.fluxnetworks.common.misc.FluxMenu;
import sonar.fluxnetworks.register.NetworkHandler;

public class GuiFluxConfiguratorHome
extends GuiTabCore {
    public InvisibleButton redirectButton;
    public NormalButton apply;
    public FluxTextWidget fluxName;
    public FluxTextWidget priority;
    public FluxTextWidget limit;
    public SlidedSwitchButton surge;
    public SlidedSwitchButton disableLimit;
    public SlidedSwitchButton chunkLoad;
    public ItemStack stack;
    public CompoundNBT configTag;
    public String stackCustomName;
    public int stackPriority;
    public long stackLimit;
    public boolean stackSurgeMode;
    public boolean stackDisableLimit;
    public boolean stackChunkLoading;
    private int timer;

    public GuiFluxConfiguratorHome(@Nonnull FluxMenu container, @Nonnull PlayerEntity player) {
        super(container, player);
        this.stack = ((ItemFluxConfigurator.MenuBridge)Objects.requireNonNull(container.bridge)).stack;
        this.updateSettingsFromTag();
    }

    @Override
    public EnumNavigationTab getNavigationTab() {
        return EnumNavigationTab.TAB_HOME;
    }

    @Override
    protected void drawForegroundLayer(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.drawForegroundLayer(matrixStack, mouseX, mouseY);
        this.screenUtils.renderNetwork(matrixStack, this.network.getNetworkName(), this.network.getNetworkColor(), 20, 8);
        this.drawCenterText(matrixStack, FluxClientCache.getFeedbackText(), 89.0f, 150.0f, FluxClientCache.getFeedbackColor());
        this.field_230712_o_.func_238421_b_(matrixStack, FluxTranslate.SURGE_MODE.t(), 20.0f, 90.0f, this.network.getNetworkColor());
        this.field_230712_o_.func_238421_b_(matrixStack, FluxTranslate.DISABLE_LIMIT.t(), 20.0f, 102.0f, this.network.getNetworkColor());
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.configureNavigationButtons(EnumNavigationTab.TAB_HOME, this.navigationTabs);
        this.redirectButton = new InvisibleButton(this.field_147003_i + 20, this.field_147009_r + 8, 135, 12, EnumNavigationTab.TAB_SELECTION.getTranslatedName(), b -> this.switchTab(EnumNavigationTab.TAB_SELECTION));
        this.func_230480_a_((Widget)this.redirectButton);
        int color = this.network.getNetworkColor() | 0xFF000000;
        this.fluxName = FluxTextWidget.create(FluxTranslate.NAME.t() + ": ", this.field_230712_o_, this.field_147003_i + 16, this.field_147009_r + 28, 144, 12).setOutlineColor(color);
        this.fluxName.func_146203_f(24);
        this.fluxName.func_146180_a(this.stackCustomName);
        this.fluxName.func_212954_a(string -> {
            this.stackCustomName = this.fluxName.func_146179_b();
            this.onSettingsChanged();
        });
        this.func_230480_a_((Widget)this.fluxName);
        this.priority = FluxTextWidget.create(FluxTranslate.PRIORITY.t() + ": ", this.field_230712_o_, this.field_147003_i + 16, this.field_147009_r + 45, 144, 12).setOutlineColor(color).setDigitsOnly().setAllowNegatives(true);
        this.priority.func_146203_f(5);
        this.priority.func_146180_a(String.valueOf(this.stackPriority));
        this.priority.func_212954_a(string -> {
            this.stackPriority = this.priority.getValidInt();
            this.onSettingsChanged();
        });
        this.func_230480_a_((Widget)this.priority);
        this.limit = FluxTextWidget.create(FluxTranslate.TRANSFER_LIMIT.t() + ": ", this.field_230712_o_, this.field_147003_i + 16, this.field_147009_r + 62, 144, 12).setOutlineColor(color).setDigitsOnly().setMaxValue(Long.MAX_VALUE);
        this.limit.func_146203_f(9);
        this.limit.func_146180_a(String.valueOf(this.stackLimit));
        this.limit.func_212954_a(string -> {
            this.stackLimit = this.limit.getValidLong();
            this.onSettingsChanged();
        });
        this.func_230480_a_((Widget)this.limit);
        this.surge = new SlidedSwitchButton(140, 90, 1, this.field_147003_i, this.field_147009_r, this.stackSurgeMode);
        this.switches.add(this.surge);
        this.disableLimit = new SlidedSwitchButton(140, 102, 2, this.field_147003_i, this.field_147009_r, this.stackDisableLimit);
        this.switches.add(this.disableLimit);
        this.apply = new NormalButton(FluxTranslate.APPLY.t(), this.field_146999_f / 2 - 18, 138, 36, 12, 3);
        this.field_230710_m_.add(this.apply);
        this.apply.clickable = this.configTag == null;
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, int mouseX, int mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            if (button instanceof SlidedSwitchButton) {
                SlidedSwitchButton switchButton = (SlidedSwitchButton)button;
                switchButton.switchButton();
                switch (switchButton.id) {
                    case 1: {
                        this.stackSurgeMode = switchButton.toggled;
                        this.onSettingsChanged();
                        break;
                    }
                    case 2: {
                        this.stackDisableLimit = switchButton.toggled;
                        this.onSettingsChanged();
                        break;
                    }
                    case 3: {
                        this.stackChunkLoading = switchButton.toggled;
                    }
                }
            }
            if (button == this.apply) {
                CompoundNBT tag = new CompoundNBT();
                tag.func_74768_a("networkID", this.network.getNetworkID());
                tag.func_74768_a("priority", this.stackPriority);
                tag.func_74772_a("limit", this.stackLimit);
                tag.func_74757_a("surgeMode", this.stackSurgeMode);
                tag.func_74757_a("disableLimit", this.stackDisableLimit);
                NetworkHandler.C2S_ConfiguratorEdit(this.stackCustomName, tag);
                this.stack.func_77983_a("FluxConfig", (INBT)tag);
                this.updateSettingsFromTag();
                this.apply.setUnclickable();
            }
        }
    }

    public void updateSettingsFromTag() {
        this.configTag = this.stack.func_179543_a("FluxConfig");
        if (this.configTag != null) {
            this.stackCustomName = this.stack.func_200301_q().getString();
            this.stackPriority = this.configTag.func_74762_e("priority");
            this.stackLimit = this.configTag.func_74763_f("limit");
            this.stackSurgeMode = this.configTag.func_74767_n("surgeMode");
            this.stackDisableLimit = this.configTag.func_74767_n("disableLimit");
            this.stackChunkLoading = false;
        } else {
            this.stackCustomName = this.stack.func_200301_q().getString();
            this.stackPriority = 0;
            this.stackSurgeMode = false;
            this.stackLimit = FluxConfig.defaultLimit;
            this.stackDisableLimit = false;
            this.stackChunkLoading = false;
        }
    }

    public void onSettingsChanged() {
        this.apply.clickable = this.configTag == null ? true : this.network.getNetworkID() != this.configTag.func_74762_e("networkID") || this.stackPriority != this.configTag.func_74762_e("priority") || this.stackLimit != this.configTag.func_74763_f("limit") || this.stackSurgeMode != this.configTag.func_74767_n("surgeMode") || this.stackDisableLimit != this.configTag.func_74767_n("disableLimit") || !this.stackCustomName.equals(this.stack.func_200301_q().getString());
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.timer == 0) {
            NetworkHandler.C2S_RequestNetworkUpdate(this.network, 21);
        }
        ++this.timer;
        this.timer %= 100;
    }
}

