/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.connection.transfer;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.util.Direction;
import sonar.fluxnetworks.common.connection.transfer.BasicPointHandler;
import sonar.fluxnetworks.common.connection.transfer.ConnectionTransfer;
import sonar.fluxnetworks.common.connection.transfer.FluxPlugHandler;
import sonar.fluxnetworks.common.tileentity.TileFluxPoint;

public class FluxPointHandler
extends BasicPointHandler<TileFluxPoint> {
    private final Map<Direction, ConnectionTransfer> transfers = new EnumMap<Direction, ConnectionTransfer>(Direction.class);

    public FluxPointHandler(TileFluxPoint fluxPoint) {
        super(fluxPoint);
    }

    @Override
    public void onCycleStart() {
        for (ConnectionTransfer transfer : this.transfers.values()) {
            if (transfer == null) continue;
            transfer.onCycleStart();
        }
        this.demand = this.sendToConsumers(((TileFluxPoint)this.device).getLogicLimit(), true);
    }

    @Override
    public long sendToConsumers(long energy, boolean simulate) {
        if (!((TileFluxPoint)this.device).isActive()) {
            return 0L;
        }
        long leftover = energy;
        for (ConnectionTransfer transfer : this.transfers.values()) {
            if (transfer == null || (leftover -= transfer.sendToTile(leftover, simulate)) > 0L) continue;
            return energy;
        }
        return energy - leftover;
    }

    @Override
    public void updateTransfers(Direction ... faces) {
        FluxPlugHandler.updateSidedTransfers(((TileFluxPoint)this.device).getFluxWorld(), ((TileFluxPoint)this.device).func_174877_v(), this.transfers, faces);
    }
}

