/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.trapper;

import growthcraft.trapper.client.proxy.ClientProxy;
import growthcraft.trapper.common.proxy.CommonProxy;
import growthcraft.trapper.init.GrowthcraftTrapperBlocks;
import growthcraft.trapper.init.GrowthcraftTrapperContainers;
import growthcraft.trapper.init.GrowthcraftTrapperSoundsEvents;
import growthcraft.trapper.init.GrowthcraftTrapperTileEntities;
import growthcraft.trapper.init.client.GrowthcraftTrapperBlockRenders;
import growthcraft.trapper.init.client.GrowthcraftTrapperScreenManager;
import growthcraft.trapper.init.config.GrowthcraftTrapperConfig;
import growthcraft.trapper.lib.proxy.IProxy;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="growthcraft_trapper")
@Mod.EventBusSubscriber(modid="growthcraft_trapper", bus=Mod.EventBusSubscriber.Bus.MOD)
public class GrowthcraftTrapper {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final ItemGroup itemGroup = new ItemGroup("growthcraft_trapper"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)GrowthcraftTrapperBlocks.FISHTRAP_OAK.get());
        }
    };
    public static final IProxy proxy = (IProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);

    public GrowthcraftTrapper() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        GrowthcraftTrapperSoundsEvents.SOUND_EVENTS.register(modEventBus);
        GrowthcraftTrapperBlocks.BLOCKS.register(modEventBus);
        GrowthcraftTrapperTileEntities.TILE_ENTITIES.register(modEventBus);
        GrowthcraftTrapperContainers.CONTAINERS.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public static void onItemsRegistry(RegistryEvent.Register<Item> event) {
        IForgeRegistry itemRegistry = event.getRegistry();
        Item.Properties properties = new Item.Properties().func_200916_a(itemGroup);
        GrowthcraftTrapperBlocks.registerBlockItems((IForgeRegistry<Item>)itemRegistry, properties);
    }

    private void setup(FMLCommonSetupEvent event) {
        proxy.init();
        GrowthcraftTrapperConfig.loadConfig();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        GrowthcraftTrapperBlockRenders.setRenderLayers();
        GrowthcraftTrapperScreenManager.registerFactories();
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"growthcraft_trapper", (String)"helloworld", () -> {
            LOGGER.info("Hello world from the MDK");
            return "Hello world";
        });
    }

    private void processIMC(InterModProcessEvent event) {
        LOGGER.info("Got IMC {}", event.getIMCStream().map(m -> m.getMessageSupplier().get()).collect(Collectors.toList()));
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }
}

