/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.trapper.lib.common.tileentity;

import growthcraft.trapper.init.GrowthcraftTrapperTileEntities;
import growthcraft.trapper.lib.common.block.FishtrapBlock;
import growthcraft.trapper.lib.common.inventory.ContainerFishtrap;
import growthcraft.trapper.lib.utils.BlockStateUtils;
import growthcraft.trapper.lib.utils.TickUtils;
import java.security.SecureRandom;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityFishtrap
extends LockableLootTileEntity
implements ISidedInventory,
ITickableTileEntity {
    private final IItemHandlerModifiable items = this.createHandler();
    private final int minTickFishing = TickUtils.toTicks(10, "seconds");
    private final int maxTickFishing = TickUtils.toTicks(1, "minutes");
    private final LazyOptional<IItemHandlerModifiable>[] itemHandlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    protected int numPlayersUsing;
    private LazyOptional<IItemHandlerModifiable> itemHandler = LazyOptional.of(() -> this.items);
    private NonNullList<ItemStack> inventoryItemStacks = NonNullList.func_191197_a((int)7, (Object)ItemStack.field_190927_a);
    private LootTable lootTable;
    private int tickCounter = 0;
    private int randomTickCooldown = this.getRandomTickCooldown();

    public TileEntityFishtrap(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public TileEntityFishtrap() {
        this((TileEntityType)GrowthcraftTrapperTileEntities.acaciaFishtrapTileEntity.get());
    }

    public static void swapContents(TileEntityFishtrap tileEntityFishtrapOne, TileEntityFishtrap tileEntityFishtrapTwo) {
        NonNullList<ItemStack> list = tileEntityFishtrapOne.func_190576_q();
        tileEntityFishtrapOne.func_199721_a(tileEntityFishtrapTwo.func_190576_q());
        tileEntityFishtrapTwo.func_199721_a(list);
    }

    private int getRandomTickCooldown() {
        return new SecureRandom().nextInt(this.maxTickFishing - this.minTickFishing) + this.minTickFishing;
    }

    public void func_145836_u() {
        super.func_145836_u();
        if (this.itemHandler != null) {
            this.itemHandler.invalidate();
            this.itemHandler = null;
        }
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nonnull Direction side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == Direction.UP) {
                return this.itemHandlers[0].cast();
            }
            if (side == Direction.DOWN) {
                return this.itemHandlers[1].cast();
            }
            return this.itemHandlers[2].cast();
        }
        return super.getCapability(capability, side);
    }

    private IItemHandlerModifiable createHandler() {
        return new InvWrapper((IInventory)this);
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.itemHandler != null) {
            this.itemHandler.invalidate();
        }
    }

    public int func_70302_i_() {
        return 7;
    }

    public NonNullList<ItemStack> func_190576_q() {
        return this.inventoryItemStacks;
    }

    protected void func_199721_a(NonNullList<ItemStack> itemsIn) {
        this.inventoryItemStacks = itemsIn;
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.growthcraft_trapper.fishtrap");
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new ContainerFishtrap(id, player, this);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (!this.func_184282_c(compound)) {
            ItemStackHelper.func_191282_a((CompoundNBT)compound, this.inventoryItemStacks);
        }
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.inventoryItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (!this.func_184283_b(compound)) {
            ItemStackHelper.func_191283_b((CompoundNBT)compound, this.inventoryItemStacks);
        }
    }

    public void playSound(@Nullable PlayerEntity player, SoundEvent sound) {
        double dx = (double)this.field_174879_c.func_177958_n() + 0.5;
        double dy = (double)this.field_174879_c.func_177956_o() + 0.5;
        double dz = (double)this.field_174879_c.func_177952_p() + 0.5;
        assert (this.field_145850_b != null);
        this.field_145850_b.func_184148_a(player, dx, dy, dz, sound, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public void func_174889_b(PlayerEntity player) {
        if (!player.func_175149_v()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            } else {
                ++this.numPlayersUsing;
                this.onOpenOrClose();
            }
        }
    }

    public void func_174886_c(PlayerEntity player) {
        if (!player.func_175149_v()) {
            --this.numPlayersUsing;
            this.onOpenOrClose();
        }
    }

    protected void onOpenOrClose() {
        Block block = this.func_195044_w().func_177230_c();
        if (block instanceof FishtrapBlock) {
            assert (this.field_145850_b != null);
            this.field_145850_b.func_175641_c(this.field_174879_c, block, 1, this.numPlayersUsing);
            this.field_145850_b.func_195593_d(this.field_174879_c, block);
        }
    }

    public void func_73660_a() {
        assert (this.field_145850_b != null);
        if (this.field_145850_b.func_201670_d()) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter >= this.randomTickCooldown && this.canDoFishing()) {
            this.doFishing();
            this.tickCounter = 0;
            this.randomTickCooldown = this.getRandomTickCooldown();
        }
    }

    private LootTable getLootTable(boolean fortune) {
        LootTableManager lootTableManager = ServerLifecycleHooks.getCurrentServer().func_200249_aQ();
        return fortune ? lootTableManager.func_186521_a(LootTables.field_186389_an) : lootTableManager.func_186521_a(LootTables.field_186387_al);
    }

    private boolean canDoFishing() {
        World world = this.func_145831_w();
        assert (world != null);
        Map<String, Block> blockMap = BlockStateUtils.getSurroundingBlocks(world, this.field_174879_c);
        if (blockMap.get("down") instanceof FlowingFluidBlock && blockMap.get("up") instanceof FlowingFluidBlock) {
            return true;
        }
        if (blockMap.get("north") instanceof FlowingFluidBlock && blockMap.get("east") instanceof FlowingFluidBlock && blockMap.get("south") instanceof FlowingFluidBlock && blockMap.get("west") instanceof FlowingFluidBlock) {
            return true;
        }
        boolean eastWest = blockMap.get("east") instanceof FlowingFluidBlock && blockMap.get("west") instanceof FlowingFluidBlock;
        boolean northSouth = blockMap.get("north") instanceof FlowingFluidBlock && blockMap.get("south") instanceof FlowingFluidBlock;
        return (eastWest || northSouth) && ((Boolean)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208198_y)).equals(Boolean.TRUE);
    }

    private void doFishing() {
        ItemStack bait = (ItemStack)this.inventoryItemStacks.get(0);
        boolean isBait = ItemTags.func_199903_a().func_199910_a(new ResourceLocation("growthcraft_trapper", "fishing_bait")).func_230235_a_((Object)bait.func_77973_b());
        this.lootTable = isBait ? this.getLootTable(true) : this.getLootTable(false);
        List<ItemStack> lootedItems = this.getLootItemStack();
        for (ItemStack itemStack : lootedItems) {
            if (this.isInventoryFull()) continue;
            this.addStackToInventory(itemStack, false);
        }
        ((ItemStack)this.inventoryItemStacks.get(0)).func_190918_g(1);
    }

    private ItemStack addStackToInventory(ItemStack stack, boolean simulate) {
        ItemStack remainder = stack;
        for (int slot = 1; slot < this.items.getSlots() && (remainder = this.items.insertItem(slot, stack, simulate)) != ItemStack.field_190927_a; ++slot) {
        }
        return remainder;
    }

    private boolean isInventoryFull() {
        int filledSlots = 0;
        for (int slotIndex = 1; slotIndex < this.items.getSlots(); ++slotIndex) {
            if (this.items.getStackInSlot(slotIndex).func_190916_E() != this.items.getSlotLimit(slotIndex)) continue;
            ++filledSlots;
        }
        return filledSlots == this.items.getSlots() - 1;
    }

    private List<ItemStack> getLootItemStack() {
        assert (this.field_145850_b != null);
        return this.lootTable.func_216113_a(new LootContext.Builder((ServerWorld)this.field_145850_b).func_216023_a((Random)new SecureRandom()).func_216022_a(LootParameterSets.field_216260_a));
    }

    public int[] func_180463_a(Direction side) {
        int[] nArray;
        if (side.equals((Object)Direction.UP)) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            int[] nArray3 = new int[6];
            nArray3[0] = 1;
            nArray3[1] = 2;
            nArray3[2] = 3;
            nArray3[3] = 4;
            nArray3[4] = 5;
            nArray = nArray3;
            nArray3[5] = 6;
        }
        return nArray;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        boolean isBait = ItemTags.func_199903_a().func_199910_a(new ResourceLocation("growthcraft_trapper", "fishing_bait")).func_230235_a_((Object)itemStackIn.func_77973_b());
        return index == 0 && isBait;
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return index != 0 || !direction.equals((Object)Direction.DOWN);
    }
}

