/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.recycler.config.ConfigRecycler;
import ovh.corail.recycler.gui.ButtonRecycler;
import ovh.corail.recycler.gui.RecyclerMenu;
import ovh.corail.recycler.gui.SlotRecycler;
import ovh.corail.recycler.helper.LangKey;
import ovh.corail.recycler.network.PacketHandler;
import ovh.corail.recycler.network.ServerRecyclerMessage;
import ovh.corail.recycler.registry.ModItems;

@OnlyIn(value=Dist.CLIENT)
public class GuiRecycler
extends ContainerScreen<RecyclerMenu> {
    private static final ResourceLocation TEXTURE_RECYCLER = new ResourceLocation("corail_recycler:textures/gui/vanilla_recycler.png");
    private static final ButtonRecycler[] BUTTONS = new ButtonRecycler[5];
    private final ResourceLocation TEXTURE_BAR = new ResourceLocation("textures/gui/bars.png");
    private boolean isInit = true;

    public GuiRecycler(RecyclerMenu container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
        this.field_146999_f = 232;
        this.field_147000_g = 203;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.getMinecraft().field_195559_v.func_197967_a(true);
        GuiRecycler.BUTTONS[0] = new ButtonRecycler(this.field_147003_i + 174, this.field_147009_r + 120, 53, 14, (ITextComponent)LangKey.BUTTON_RECYLE.getText(new Object[0]), pressable -> PacketHandler.sendToServer(new ServerRecyclerMessage(ServerRecyclerMessage.RecyclerAction.RECYCLE, ((RecyclerMenu)this.field_147002_h).getPosition())));
        this.func_230480_a_((Widget)GuiRecycler.BUTTONS[0]);
        GuiRecycler.BUTTONS[1] = new ButtonRecycler(this.field_147003_i + 174, this.field_147009_r + 139, 53, 14, (ITextComponent)LangKey.BUTTON_AUTO.getText(new Object[0]), pressable -> PacketHandler.sendToServer(new ServerRecyclerMessage(ServerRecyclerMessage.RecyclerAction.SWITCH_AUTO, ((RecyclerMenu)this.field_147002_h).getPosition())));
        this.func_230480_a_((Widget)GuiRecycler.BUTTONS[1]);
        GuiRecycler.BUTTONS[2] = new ButtonRecycler(this.field_147003_i + 174, this.field_147009_r + 157, 53, 14, (ITextComponent)LangKey.BUTTON_TAKE_ALL.getText(new Object[0]), pressable -> PacketHandler.sendToServer(new ServerRecyclerMessage(ServerRecyclerMessage.RecyclerAction.TAKE_ALL, ((RecyclerMenu)this.field_147002_h).getPosition())));
        this.func_230480_a_((Widget)GuiRecycler.BUTTONS[2]);
        GuiRecycler.BUTTONS[3] = new ButtonRecycler(this.field_147003_i + 174, this.field_147009_r + 175, 53, 14, (ITextComponent)LangKey.BUTTON_DISCOVER_RECIPE.getText(new Object[0]), pressable -> PacketHandler.sendToServer(new ServerRecyclerMessage(ServerRecyclerMessage.RecyclerAction.DISCOVER_RECIPE, ((RecyclerMenu)this.field_147002_h).getPosition())));
        this.func_230480_a_((Widget)GuiRecycler.BUTTONS[3]);
        GuiRecycler.BUTTONS[4] = new ButtonRecycler(this.field_147003_i + 174, this.field_147009_r + 175, 53, 14, (ITextComponent)LangKey.BUTTON_REMOVE_RECIPE.getText(new Object[0]), pressable -> PacketHandler.sendToServer(new ServerRecyclerMessage(ServerRecyclerMessage.RecyclerAction.REMOVE_RECIPE, ((RecyclerMenu)this.field_147002_h).getPosition())));
        this.func_230480_a_((Widget)GuiRecycler.BUTTONS[4]);
    }

    protected void func_230450_a_(MatrixStack poseStack, float partialTicks, int mouseX, int mouseY) {
        this.func_230446_a_(poseStack);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(TEXTURE_RECYCLER);
        this.func_238474_b_(poseStack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        for (Slot slot : ((RecyclerMenu)this.func_212873_a_()).field_75151_b) {
            this.func_238474_b_(poseStack, this.field_147003_i + slot.field_75223_e - 1, this.field_147009_r + slot.field_75221_f - 1, 110, 238, 18, 18);
            if (!(slot instanceof SlotRecycler)) continue;
            SlotRecycler slotRecycler = (SlotRecycler)slot;
            if (this.isInit) {
                slotRecycler.timeInUse = 0;
                continue;
            }
            if (slotRecycler.timeInUse <= 0) continue;
            this.func_238474_b_(poseStack, this.field_147003_i + slot.field_75223_e - 1, this.field_147009_r + slot.field_75221_f - 1, 110, 203, 18, 18);
            --slotRecycler.timeInUse;
        }
        this.isInit = false;
    }

    public void func_230451_b_(MatrixStack poseStack, int mouseX, int mouseY) {
        int colorRed = -65536;
        int colorGreen = -16711936;
        float scale = 0.6f;
        float revScale = 1.0f / scale;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().field_71446_o.func_110577_a(TEXTURE_RECYCLER);
        this.func_238474_b_(poseStack, 115, 71, 79, 210, 22, 15);
        if (((RecyclerMenu)this.field_147002_h).isWorking() && ((RecyclerMenu)this.field_147002_h).getInputMax() > 0) {
            this.func_238474_b_(poseStack, 115, 71, 79, 225, ((RecyclerMenu)this.field_147002_h).getProgress() * 22 / 100, 15);
        }
        int currentPower = ((RecyclerMenu)this.field_147002_h).getEnergy();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(this.TEXTURE_BAR);
        GuiRecycler.func_238463_a_((MatrixStack)poseStack, (int)70, (int)112, (float)0.0f, (float)20.0f, (int)136, (int)3, (int)136, (int)256);
        GuiRecycler.func_238463_a_((MatrixStack)poseStack, (int)70, (int)112, (float)0.0f, (float)25.0f, (int)((int)(96.56 * (double)currentPower) / ((RecyclerMenu)this.field_147002_h).getRecycler().getMaxEnergy()), (int)2, (int)136, (int)256);
        GuiRecycler.func_238463_a_((MatrixStack)poseStack, (int)70, (int)112, (float)0.0f, (float)81.0f, (int)136, (int)3, (int)136, (int)256);
        poseStack.func_227860_a_();
        poseStack.func_227862_a_(scale, scale, scale);
        this.field_230712_o_.func_238421_b_(poseStack, "ENERGY", 134.0f * revScale, 98.0f * revScale, -8355712);
        Slot diskSlot = (Slot)((RecyclerMenu)this.field_147002_h).field_75151_b.get(1);
        ItemStack diskStack = diskSlot.func_75211_c();
        int useLeft = diskStack.func_190926_b() ? 0 : diskStack.func_77958_k() - diskStack.func_77952_i();
        this.field_230712_o_.func_238421_b_(poseStack, String.valueOf(useLeft), (float)((int)((float)(diskSlot.field_75223_e + 20) * revScale)), (float)((int)((float)(diskSlot.field_75221_f + 4) * revScale)), useLeft > 0 ? colorGreen : colorRed);
        Slot bookSlot = (Slot)((RecyclerMenu)this.field_147002_h).field_75151_b.get(2);
        ItemStack bookStack = bookSlot.func_75211_c();
        int left = bookStack.func_190926_b() ? 0 : bookStack.func_190916_E();
        this.field_230712_o_.func_238421_b_(poseStack, String.valueOf(left), (float)((int)((float)(bookSlot.field_75223_e + 20) * revScale)), (float)((int)((float)(bookSlot.field_75221_f + 4) * revScale)), left > 0 ? colorGreen : colorRed);
        Slot recycledSlot = (Slot)((RecyclerMenu)this.field_147002_h).field_75151_b.get(0);
        this.field_230712_o_.func_238421_b_(poseStack, String.valueOf(((RecyclerMenu)this.field_147002_h).getInputMax()), (float)((int)((float)(recycledSlot.field_75223_e + 20) * revScale)), (float)((int)((float)(recycledSlot.field_75221_f + 4) * revScale)), ((RecyclerMenu)this.field_147002_h).getInputMax() > 0 ? colorGreen : colorRed);
        this.field_230712_o_.func_238421_b_(poseStack, String.format("%5s", currentPower) + " / " + ((RecyclerMenu)this.field_147002_h).getRecycler().getMaxEnergy(), (float)((int)(120.0f * revScale)), (float)((int)(104.0f * revScale)), currentPower >= 10 ? colorGreen : -8355712);
        poseStack.func_227865_b_();
        this.renderGhostIngredient(poseStack, bookSlot, () -> new ItemStack((IItemProvider)Items.field_151122_aG));
        this.renderGhostIngredient(poseStack, diskSlot, () -> new ItemStack((IItemProvider)ModItems.steel_disk), -2139062144);
        int start = ((RecyclerMenu)this.field_147002_h).getRecycler().getInventoryWorking().getSlots() + ((RecyclerMenu)this.field_147002_h).getRecycler().getInventoryInput().getSlots();
        this.renderGhostIngredient(poseStack, (Slot)((RecyclerMenu)this.field_147002_h).field_75151_b.get(start - 3), () -> new ItemStack((IItemProvider)Items.field_151122_aG));
        this.renderGhostIngredient(poseStack, (Slot)((RecyclerMenu)this.field_147002_h).field_75151_b.get(start - 2), () -> new ItemStack((IItemProvider)ModItems.steel_disk), -2139062144);
        this.renderGhostIngredient(poseStack, (Slot)((RecyclerMenu)this.field_147002_h).field_75151_b.get(start - 1), () -> new ItemStack((IItemProvider)ModItems.steel_disk), -2139062144);
        int entityX = 86;
        int entityY = 50;
        Optional.ofNullable(this.getMinecraft().field_71439_g).ifPresent(p -> InventoryScreen.func_228187_a_((int)entityX, (int)entityY, (int)20, (float)(2 * entityX - mouseX), (float)(entityY - mouseY), (LivingEntity)p));
    }

    private void renderGhostIngredient(MatrixStack poseStack, Slot slot, Supplier<ItemStack> supplierStack) {
        this.renderGhostIngredient(poseStack, slot, supplierStack, -796884864);
    }

    private void renderGhostIngredient(MatrixStack poseStack, Slot slot, Supplier<ItemStack> supplierStack, int colorMask) {
        if (slot.func_75211_c().func_190926_b()) {
            this.getMinecraft().func_175599_af().func_239390_c_(supplierStack.get(), slot.field_75223_e, slot.field_75221_f);
            RenderSystem.depthFunc((int)516);
            GuiRecycler.func_238467_a_((MatrixStack)poseStack, (int)slot.field_75223_e, (int)slot.field_75221_f, (int)(slot.field_75223_e + 16), (int)(slot.field_75221_f + 16), (int)colorMask);
            RenderSystem.depthFunc((int)515);
        }
    }

    public void func_231175_as__() {
        super.func_231175_as__();
        this.getMinecraft().field_195559_v.func_197967_a(false);
    }

    public void func_230430_a_(MatrixStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.updateButtons();
        super.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(poseStack, mouseX, mouseY);
    }

    public boolean func_231177_au__() {
        return false;
    }

    private void updateButtons() {
        boolean isEmptySlot = ((RecyclerMenu)this.field_147002_h).getRecycler().getInventoryWorking().getStackInSlot(0).func_190926_b();
        boolean hasPermission = Optional.ofNullable(this.getMinecraft().field_71439_g).map(p -> (Boolean)ConfigRecycler.shared_general.permanentDiscoverButton.get() != false || p.func_211513_k(2)).orElse(false);
        boolean hasRecipe = IntStream.range(0, ((RecyclerMenu)this.field_147002_h).getRecycler().getInventoryVisual().getSlots()).anyMatch(slot -> !((RecyclerMenu)this.field_147002_h).getRecycler().getInventoryVisual().getStackInSlot(slot).func_190926_b());
        GuiRecycler.BUTTONS[0].field_230693_o_ = hasRecipe && ((RecyclerMenu)this.field_147002_h).getInputMax() > 0 && !((RecyclerMenu)this.field_147002_h).isWorking();
        GuiRecycler.BUTTONS[1].field_230693_o_ = (Boolean)ConfigRecycler.shared_general.allowAutomation.get() != false && hasRecipe && !((RecyclerMenu)this.field_147002_h).getRecycler().getInventoryWorking().getStackInSlot(1).func_190926_b();
        GuiRecycler.BUTTONS[2].field_230693_o_ = !((RecyclerMenu)this.field_147002_h).getRecycler().isOutputEmpty();
        GuiRecycler.BUTTONS[3].field_230694_p_ = hasPermission && !hasRecipe && !isEmptySlot;
        GuiRecycler.BUTTONS[3].field_230693_o_ = GuiRecycler.BUTTONS[3].field_230694_p_;
        GuiRecycler.BUTTONS[4].field_230694_p_ = hasPermission && hasRecipe && !isEmptySlot;
        GuiRecycler.BUTTONS[4].field_230693_o_ = GuiRecycler.BUTTONS[4].field_230694_p_;
    }
}

