/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.helper;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.items.IItemHandlerModifiable;
import ovh.corail.recycler.ModRecycler;
import ovh.corail.recycler.compatibility.CompatibilityProjectE;
import ovh.corail.recycler.recipe.SimpleStack;

public class Helper {
    public static final Random RANDOM = new Random();
    private static final Predicate<Ingredient> VALID_INGREDIENT = ingredient -> {
        if (ingredient == Ingredient.field_193370_a) {
            return true;
        }
        if (ingredient.func_193365_a().length > 0) {
            return CompatibilityProjectE.philosophers_stone == null || Arrays.stream(ingredient.func_193365_a()).noneMatch(stack -> stack.func_77973_b() == CompatibilityProjectE.philosophers_stone);
        }
        return false;
    };
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();

    public static boolean isValidPlayer(@Nullable PlayerEntity player) {
        return player != null && !(player instanceof FakePlayer);
    }

    public static boolean atInterval(long ticksExisted, int tick) {
        return Helper.atInterval(ticksExisted, tick, true);
    }

    public static boolean atInterval(long ticksExisted, int tick, boolean ignoreZero) {
        return (!ignoreZero || ticksExisted > 0L) && ticksExisted % (long)tick == 0L;
    }

    public static boolean atInterval(World level, int tick) {
        return Helper.atInterval(level.func_82737_E(), tick, true);
    }

    public static boolean isValidRecipe(@Nullable IRecipe<?> recipe) {
        return recipe != null && recipe.func_192400_c().size() > 0 && !recipe.func_77571_b().func_190926_b() && recipe.func_192400_c().stream().allMatch(VALID_INGREDIENT);
    }

    public static NonNullList<SimpleStack> mergetoSimpleStack(List<ItemStack> list) {
        NonNullList simpleStacks = NonNullList.func_191196_a();
        for (ItemStack currentStack : list) {
            if (currentStack.func_190926_b()) continue;
            if (Helper.isStackable(currentStack) && currentStack.func_190916_E() < currentStack.func_77976_d()) {
                int toAdd = currentStack.func_190916_E();
                for (SimpleStack simpleStack : simpleStacks) {
                    int left;
                    int added;
                    if (!simpleStack.is(currentStack) || (added = Math.min(toAdd, left = currentStack.func_77976_d() - simpleStack.getCount())) <= 0) continue;
                    simpleStack.grow(added);
                    if ((toAdd -= added) != 0) continue;
                    break;
                }
                if (toAdd == 0) continue;
                simpleStacks.add((Object)new SimpleStack(currentStack.func_77973_b(), toAdd));
                continue;
            }
            simpleStacks.add((Object)new SimpleStack(currentStack));
        }
        return simpleStacks;
    }

    public static void mergeStackInList(NonNullList<ItemStack> list) {
        block0: for (int i = 0; i < list.size(); ++i) {
            ItemStack currentStack = (ItemStack)list.get(i);
            if (currentStack.func_190926_b() || !Helper.isStackable(currentStack) || currentStack.func_190916_E() >= currentStack.func_77976_d()) continue;
            for (int j = i + 1; j < list.size(); ++j) {
                int add;
                ItemStack lookStack = (ItemStack)list.get(j);
                if (lookStack.func_190926_b() || !lookStack.func_77969_a(currentStack) || (add = Math.min(lookStack.func_190916_E(), currentStack.func_77976_d() - currentStack.func_190916_E())) <= 0) continue;
                lookStack.func_190918_g(add);
                currentStack.func_190917_f(add);
                if (currentStack.func_190916_E() == currentStack.func_77976_d()) continue block0;
            }
        }
        list.removeIf(ItemStack::func_190926_b);
    }

    public static boolean isStackable(ItemStack stack) {
        return stack.func_77985_e() && stack.func_77973_b() != Items.field_151134_bR;
    }

    public static boolean canInsertInInventory(IItemHandlerModifiable inventory, NonNullList<ItemStack> items) {
        int[] slotSizes = IntStream.range(0, inventory.getSlots()).map(slotId -> Optional.of(inventory.getStackInSlot(slotId)).filter(s -> !s.func_190926_b()).map(ItemStack::func_190916_E).orElse(0)).toArray();
        int emptySlots = (int)Arrays.stream(slotSizes).filter(i -> i == 0).count();
        if (emptySlots >= items.size()) {
            return true;
        }
        int minCount = items.size() - emptySlots;
        block0: for (ItemStack stackIn : items) {
            if (minCount <= 0) {
                return true;
            }
            if (stackIn.func_190926_b()) {
                --minCount;
                continue;
            }
            if (!Helper.isStackable(stackIn)) continue;
            int left = stackIn.func_190916_E();
            for (int slotId2 = 0; slotId2 < inventory.getSlots(); ++slotId2) {
                int add;
                int stacksize;
                ItemStack currentStack = inventory.getStackInSlot(slotId2);
                if (!stackIn.func_77969_a(currentStack) || (stacksize = slotSizes[slotId2]) >= currentStack.func_77976_d() || (add = Math.min(left, currentStack.func_77976_d() - stacksize)) <= 0) continue;
                slotSizes[slotId2] = stacksize + add;
                if ((left -= add) > 0) continue;
                --minCount;
                continue block0;
            }
        }
        return minCount <= 0;
    }

    @Nullable
    public static MinecraftServer getServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    public static boolean isPacketToClient(NetworkEvent.Context ctx) {
        return ctx.getDirection().getOriginationSide() == LogicalSide.SERVER && ctx.getDirection().getReceptionSide() == LogicalSide.CLIENT;
    }

    public static boolean isPacketToServer(NetworkEvent.Context ctx) {
        return ctx.getDirection().getOriginationSide() == LogicalSide.CLIENT && ctx.getDirection().getReceptionSide() == LogicalSide.SERVER;
    }

    public static <T> T unsafeNullCast() {
        return null;
    }

    public static boolean saveAsJson(File file, List<?> list) {
        if (file.exists() && !file.delete()) {
            ModRecycler.LOGGER.warn("can't delete file " + file.getName());
        }
        try {
            if (file.createNewFile()) {
                FileWriter fw = new FileWriter(file);
                fw.write(GSON.toJson(list));
                fw.close();
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static <T> List<T> loadAsJson(File file, Type token) {
        List list = new ArrayList();
        try {
            list = (List)GSON.fromJson((Reader)new BufferedReader(new FileReader(file)), token);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static <T> List<T> loadAsJson(File file, Class<T> type) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            JsonArray arrayDatas = new JsonParser().parse((Reader)new BufferedReader(new FileReader(file))).getAsJsonArray();
            for (JsonElement elem : arrayDatas) {
                list.add(GSON.fromJson(elem, type));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }
}

