/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.network;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import ovh.corail.recycler.network.ServerRecyclerMessage;
import ovh.corail.recycler.network.ServerRecyclingBookMessage;
import ovh.corail.recycler.network.UpdateConfigMessage;

public class PacketHandler {
    private static final String PROTOCOL_VERSION = "corail_recycler-5.2.1";
    private static final SimpleChannel HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("corail_recycler", "recycler_channel"), () -> "corail_recycler-5.2.1", "corail_recycler-5.2.1"::equals, "corail_recycler-5.2.1"::equals);

    public static <T> void sendToServer(T message) {
        HANDLER.sendToServer(message);
    }

    public static <T> void sendToPlayer(T message, ServerPlayerEntity player) {
        HANDLER.send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    public static <T> void sendToAllTrackingPlayers(T message, LivingEntity entity) {
        HANDLER.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), message);
    }

    public static <T> void sendToAllPlayers(T message) {
        HANDLER.send(PacketDistributor.ALL.noArg(), message);
    }

    static {
        HANDLER.registerMessage(0, ServerRecyclerMessage.class, ServerRecyclerMessage::toBytes, ServerRecyclerMessage::fromBytes, ServerRecyclerMessage.Handler::handle);
        HANDLER.registerMessage(1, ServerRecyclingBookMessage.class, ServerRecyclingBookMessage::toBytes, ServerRecyclingBookMessage::fromBytes, ServerRecyclingBookMessage.Handler::handle);
        HANDLER.registerMessage(2, UpdateConfigMessage.class, UpdateConfigMessage::toBytes, UpdateConfigMessage::fromBytes, UpdateConfigMessage.Handler::handle);
    }
}

