/*
 * Decompiled with CFR 0.152.
 */
package com.mcwwindows.kikoz.objects;

import com.mcwwindows.kikoz.init.ItemInit;
import com.mcwwindows.kikoz.init.SoundsInit;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class WindowBarred
extends Block {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.field_208142_aq;
    public static final BooleanProperty OPEN = BlockStateProperties.field_208193_t;
    public static final BooleanProperty LOCKED = BlockStateProperties.field_208191_r;
    protected static final VoxelShape EE = WindowBarred.func_208617_a((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    protected static final VoxelShape NN = WindowBarred.func_208617_a((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);

    public WindowBarred(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(false))).func_206870_a(HINGE, (Comparable)DoorHingeSide.LEFT)).func_206870_a((Property)LOCKED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        Boolean openik = (Boolean)state.func_177229_b((Property)OPEN);
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            default: {
                if (openik.booleanValue()) {
                    return VoxelShapes.func_197880_a();
                }
                return EE;
            }
            case NORTH: {
                if (openik.booleanValue()) {
                    return VoxelShapes.func_197880_a();
                }
                return EE;
            }
            case EAST: {
                if (openik.booleanValue()) {
                    return VoxelShapes.func_197880_a();
                }
                return NN;
            }
            case WEST: 
        }
        if (openik.booleanValue()) {
            return VoxelShapes.func_197880_a();
        }
        return NN;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f())).func_206870_a(HINGE, (Comparable)this.getHinge(context));
    }

    public void func_180633_a(World level, BlockPos pos, BlockState state, @Nullable LivingEntity livent, ItemStack stack) {
        Block block = level.func_180495_p(pos).func_177230_c();
        Block below = level.func_180495_p(pos.func_177979_c(1)).func_177230_c();
        if (block == this && below == block) {
            DoorHingeSide hinge = (DoorHingeSide)level.func_180495_p(pos.func_177979_c(1)).func_177229_b(HINGE);
            level.func_175656_a(pos, (BlockState)state.func_206870_a(HINGE, (Comparable)hinge));
        }
    }

    protected DoorHingeSide getHinge(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        Direction direction = context.func_195992_f();
        int j = direction.func_82601_c();
        int k = direction.func_82599_e();
        Vector3d vector3d = context.func_221532_j();
        double d0 = vector3d.field_72450_a - (double)blockpos.func_177958_n();
        double d1 = vector3d.field_72449_c - (double)blockpos.func_177952_p();
        return !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack itemstack = player.func_184586_b(handIn);
        Item item = itemstack.func_77973_b();
        if (item == ItemInit.KEY.get()) {
            this.raiseBlinds(level, pos, (Boolean)state.func_177229_b((Property)LOCKED) == false, (Direction)state.func_177229_b((Property)FACING), 1000);
            level.func_184133_a(null, pos, SoundEvents.field_187614_cJ, SoundCategory.BLOCKS, 0.5f, level.field_73012_v.nextFloat() * 0.1f + 0.8f);
            state = (BlockState)state.func_235896_a_((Property)LOCKED);
            level.func_180501_a(pos, state, 10);
            return ActionResultType.SUCCESS;
        }
        if (((Boolean)state.func_177229_b((Property)LOCKED)).booleanValue() || item == this.func_199767_j()) {
            return ActionResultType.PASS;
        }
        Boolean open = (Boolean)state.func_177229_b((Property)OPEN);
        if (open.booleanValue()) {
            level.func_184133_a(null, pos, (SoundEvent)SoundsInit.WINDOW_CLOSE.get(), SoundCategory.BLOCKS, 0.5f, level.field_73012_v.nextFloat() * 0.1f + 0.8f);
        } else {
            level.func_184133_a(null, pos, (SoundEvent)SoundsInit.WINDOW_OPEN.get(), SoundCategory.BLOCKS, 0.5f, level.field_73012_v.nextFloat() * 0.1f + 0.8f);
        }
        this.openWindow(level, pos, (Boolean)state.func_177229_b((Property)OPEN) == false, (Direction)state.func_177229_b((Property)FACING));
        state = (BlockState)state.func_235896_a_((Property)OPEN);
        level.func_180501_a(pos, state, 10);
        return ActionResultType.SUCCESS;
    }

    public boolean isOpen(BlockState state) {
        return (Boolean)state.func_177229_b((Property)OPEN);
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return mirror == Mirror.NONE ? state : (BlockState)state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((Property)FACING))).func_235896_a_(HINGE);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return ((Direction)state.func_177229_b((Property)FACING)).func_176740_k() == Direction.Axis.X ? NN : EE;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, OPEN, HINGE, LOCKED});
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState updatePostPlacement(BlockState stateIn, Direction facing, BlockState facingState, World level, BlockPos currentPos, BlockPos facingPos) {
        return super.func_196271_a(stateIn, facing, facingState, (IWorld)level, currentPos, facingPos);
    }

    private void openWindow(World world, BlockPos pos, boolean bool, Direction dir) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this && (Boolean)state.func_177229_b((Property)OPEN) != bool && ((Direction)state.func_177229_b((Property)FACING)).equals((Object)dir)) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(bool)));
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockPos newPos = pos.func_177982_a(x, y, z);
                        this.openWindow(world, newPos, bool, dir);
                    }
                }
            }
        }
    }

    private void raiseBlinds(World world, BlockPos pos, boolean targetOpen, Direction targetDirection, int depth) {
        if (depth <= 0) {
            return;
        }
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this) {
            boolean open = (Boolean)state.func_177229_b((Property)LOCKED);
            Direction direction = (Direction)state.func_177229_b((Property)FACING);
            if (open != targetOpen && direction.equals((Object)targetDirection)) {
                world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)LOCKED, (Comparable)Boolean.valueOf(targetOpen)));
                if (direction.func_176740_k() == Direction.Axis.X) {
                    this.raiseBlinds(world, pos.func_177970_e(1), targetOpen, targetDirection, depth - 2);
                    this.raiseBlinds(world, pos.func_177964_d(1), targetOpen, targetDirection, depth - 2);
                    this.raiseBlinds(world, pos.func_177979_c(1), targetOpen, targetDirection, depth - 2);
                    this.raiseBlinds(world, pos.func_177979_c(2), targetOpen, targetDirection, depth - 2);
                    this.raiseBlinds(world, pos.func_177981_b(1), targetOpen, targetDirection, depth - 2);
                }
                if (direction.func_176740_k() == Direction.Axis.Z) {
                    this.raiseBlinds(world, pos.func_177965_g(1), targetOpen, targetDirection, depth - 2);
                    this.raiseBlinds(world, pos.func_177985_f(1), targetOpen, targetDirection, depth - 2);
                    this.raiseBlinds(world, pos.func_177979_c(1), targetOpen, targetDirection, depth - 2);
                    this.raiseBlinds(world, pos.func_177979_c(2), targetOpen, targetDirection, depth - 2);
                    this.raiseBlinds(world, pos.func_177981_b(1), targetOpen, targetDirection, depth - 2);
                }
            }
        }
    }
}

