/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.text;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.text.Span;
import vazkii.patchouli.client.book.text.SpanState;
import vazkii.patchouli.common.base.Patchouli;
import vazkii.patchouli.common.book.Book;

public class BookTextParser {
    public static final StringTextComponent EMPTY_STRING_COMPONENT = new StringTextComponent("");
    private static final List<CommandLookup> COMMAND_LOOKUPS = new ArrayList<CommandLookup>();
    private static final Map<String, CommandProcessor> COMMANDS = new ConcurrentHashMap<String, CommandProcessor>();
    private static final Map<String, FunctionProcessor> FUNCTIONS = new ConcurrentHashMap<String, FunctionProcessor>();
    private final GuiBook gui;
    private final Book book;
    private final int x;
    private final int y;
    private final int width;
    private final int lineHeight;
    private final Style baseStyle;
    private Pattern COMMAND_PATTERN = Pattern.compile("\\$\\(([^)]*)\\)");

    private static void registerProcessor(CommandLookup processor) {
        COMMAND_LOOKUPS.add(processor);
    }

    public static void register(CommandProcessor handler, String ... names) {
        for (String name : names) {
            COMMANDS.put(name, handler);
        }
    }

    public static void register(FunctionProcessor function, String ... names) {
        for (String name : names) {
            FUNCTIONS.put(name, function);
        }
    }

    public BookTextParser(GuiBook gui, Book book, int x, int y, int width, int lineHeight, Style baseStyle) {
        this.gui = gui;
        this.book = book;
        this.x = x;
        this.y = y;
        this.width = width;
        this.lineHeight = lineHeight;
        this.baseStyle = baseStyle;
    }

    public List<Span> parse(ITextComponent text) {
        ArrayList<Span> spans = new ArrayList<Span>();
        SpanState state = new SpanState(this.gui, this.book, this.baseStyle);
        text.func_230534_b_((style, string) -> {
            spans.addAll(this.processCommands(this.expandMacros(string), state, style));
            return Optional.empty();
        }, this.baseStyle);
        return spans;
    }

    public String expandMacros(@Nullable String text) {
        int i;
        String actualText = text;
        if (actualText == null) {
            actualText = "[ERROR]";
        }
        int expansionCap = 10;
        for (i = 0; i < expansionCap; ++i) {
            String newText = actualText;
            for (Map.Entry<String, String> e : this.book.macros.entrySet()) {
                newText = newText.replace(e.getKey(), e.getValue());
            }
            if (newText.equals(actualText)) break;
            actualText = newText;
        }
        if (i == expansionCap) {
            Patchouli.LOGGER.warn("Expanded macros for {} iterations without reaching fixpoint, stopping. Make sure you don't have circular macro invocations", (Object)expansionCap);
        }
        return actualText;
    }

    private List<Span> processCommands(String text, SpanState state, Style style) {
        state.changeBaseStyle(style);
        ArrayList<Span> spans = new ArrayList<Span>();
        Matcher match = this.COMMAND_PATTERN.matcher(text);
        while (match.find()) {
            StringBuffer sb = new StringBuffer();
            match.appendReplacement(sb, "");
            spans.add(new Span(state, sb.toString()));
            try {
                String processed = this.processCommand(state, match.group(1));
                if (processed.isEmpty()) continue;
                spans.add(new Span(state, processed));
                if (state.cluster != null) continue;
                state.tooltip = EMPTY_STRING_COMPONENT;
            }
            catch (Exception ex) {
                spans.add(Span.error(state, "[ERROR]"));
            }
        }
        spans.add(new Span(state, match.appendTail(new StringBuffer()).toString()));
        return spans;
    }

    private String processCommand(SpanState state, String cmd) {
        CommandLookup lookup;
        state.endingExternal = false;
        Optional<Object> optResult = Optional.empty();
        Iterator<CommandLookup> iterator = COMMAND_LOOKUPS.iterator();
        while (iterator.hasNext() && !(optResult = (lookup = iterator.next()).process(cmd, state)).isPresent()) {
        }
        String result = optResult.orElse("$(" + cmd + ")");
        if (state.endingExternal) {
            result = result + TextFormatting.GRAY + "\u21aa";
        }
        return result;
    }

    private static Optional<String> colorCodeProcessor(String functionName, SpanState state) {
        if (functionName.length() == 1 && functionName.matches("^[0123456789abcdef]$")) {
            state.modifyStyle(s -> s.func_240721_b_(TextFormatting.func_211165_a((char)functionName.charAt(0))));
            return Optional.of("");
        }
        return Optional.empty();
    }

    private static Optional<String> colorHexProcessor(String functionName, SpanState state) {
        if (functionName.startsWith("#") && (functionName.length() == 4 || functionName.length() == 7)) {
            Color color;
            String parse = functionName.substring(1);
            if (parse.length() == 3) {
                parse = "" + parse.charAt(0) + parse.charAt(0) + parse.charAt(1) + parse.charAt(1) + parse.charAt(2) + parse.charAt(2);
            }
            try {
                color = Color.func_240743_a_((int)Integer.parseInt(parse, 16));
            }
            catch (NumberFormatException e) {
                color = state.getBase().func_240711_a_();
            }
            state.color(color);
            return Optional.of("");
        }
        return Optional.empty();
    }

    private static Optional<String> listProcessor(String functionName, SpanState state) {
        if (functionName.matches("li\\d?")) {
            char c = functionName.length() > 2 ? (char)functionName.charAt(2) : (char)'1';
            int dist = Character.isDigit(c) ? Character.digit(c, 10) : 1;
            int pad = dist * 4;
            char bullet = dist % 2 == 0 ? (char)'\u25e6' : '\u2022';
            state.lineBreaks = 1;
            state.spacingLeft = pad;
            state.spacingRight = state.spaceWidth;
            return Optional.of(TextFormatting.BLACK.toString() + bullet);
        }
        return Optional.empty();
    }

    private static Optional<String> lookupFunctionProcessor(String functionName, SpanState state) {
        int index = functionName.indexOf(58);
        if (index > 0) {
            String fname = functionName.substring(0, index);
            String param = functionName.substring(index + 1);
            return Optional.of(Optional.ofNullable(FUNCTIONS.get(fname)).map(f -> f.process(param, state)).orElse("[MISSING FUNCTION: " + fname + "]"));
        }
        return Optional.empty();
    }

    private static Optional<String> lookupCommandProcessor(String functionName, SpanState state) {
        return Optional.ofNullable(COMMANDS.get(functionName)).map(c -> c.process(state));
    }

    private static KeyBinding getKeybindKey(SpanState state, String keybind) {
        KeyBinding[] keys;
        String alt = "key." + keybind;
        for (KeyBinding k : keys = state.gui.getMinecraft().field_71474_y.field_74324_K) {
            String name = k.func_151464_g();
            if (!name.equals(keybind) && !name.equals(alt)) continue;
            return k;
        }
        return null;
    }

    static {
        BookTextParser.registerProcessor(BookTextParser::colorCodeProcessor);
        BookTextParser.registerProcessor(BookTextParser::colorHexProcessor);
        BookTextParser.registerProcessor(BookTextParser::listProcessor);
        BookTextParser.registerProcessor(BookTextParser::lookupFunctionProcessor);
        BookTextParser.registerProcessor(BookTextParser::lookupCommandProcessor);
        BookTextParser.register((SpanState state) -> {
            state.lineBreaks = 1;
            return "";
        }, "br");
        BookTextParser.register((SpanState state) -> {
            state.lineBreaks = 2;
            return "";
        }, "br2", "2br", "p");
        BookTextParser.register((SpanState state) -> {
            state.endingExternal = state.isExternalLink;
            state.popStyle();
            state.cluster = null;
            state.tooltip = EMPTY_STRING_COMPONENT;
            state.onClick = null;
            state.isExternalLink = false;
            return "";
        }, "/l");
        BookTextParser.register((SpanState state) -> {
            state.cluster = null;
            state.tooltip = EMPTY_STRING_COMPONENT;
            return "";
        }, "/t");
        BookTextParser.register((SpanState state) -> state.gui.getMinecraft().field_71439_g.func_200200_C_().getString(), "playername");
        BookTextParser.register((SpanState state) -> {
            state.modifyStyle(s -> s.func_240721_b_(TextFormatting.OBFUSCATED));
            return "";
        }, "k", "obf");
        BookTextParser.register((SpanState state) -> {
            state.modifyStyle(s -> s.func_240721_b_(TextFormatting.BOLD));
            return "";
        }, "l", "bold");
        BookTextParser.register((SpanState state) -> {
            state.modifyStyle(s -> s.func_240721_b_(TextFormatting.STRIKETHROUGH));
            return "";
        }, "m", "strike");
        BookTextParser.register((SpanState state) -> {
            state.modifyStyle(s -> s.func_240721_b_(TextFormatting.UNDERLINE));
            return "";
        }, "n", "underline");
        BookTextParser.register((SpanState state) -> {
            state.modifyStyle(s -> s.func_240721_b_(TextFormatting.ITALIC));
            return "";
        }, "o", "italic", "italics");
        BookTextParser.register((SpanState state) -> {
            state.reset();
            return "";
        }, "", "reset", "clear");
        BookTextParser.register((SpanState state) -> {
            state.baseColor();
            return "";
        }, "nocolor");
        BookTextParser.register((String parameter, SpanState state) -> {
            KeyBinding result = BookTextParser.getKeybindKey(state, parameter);
            if (result == null) {
                state.tooltip = new TranslationTextComponent("patchouli.gui.lexicon.keybind_missing", new Object[]{parameter});
                return "N/A";
            }
            state.tooltip = new TranslationTextComponent("patchouli.gui.lexicon.keybind", new Object[]{new TranslationTextComponent(result.func_151464_g())});
            return result.func_238171_j_().getString();
        }, "k");
        BookTextParser.register((String parameter, SpanState state) -> {
            state.cluster = new LinkedList<Span>();
            state.pushStyle(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)state.book.linkColor)));
            boolean isExternal = parameter.matches("^https?\\:.*");
            if (isExternal) {
                String url = parameter;
                state.tooltip = new TranslationTextComponent("patchouli.gui.lexicon.external_link");
                state.isExternalLink = true;
                state.onClick = () -> {
                    GuiBook.openWebLink(url);
                    return true;
                };
            } else {
                ResourceLocation href;
                BookEntry entry;
                int hash = parameter.indexOf(35);
                String anchor = null;
                if (hash >= 0) {
                    anchor = parameter.substring(hash + 1);
                    parameter = parameter.substring(0, hash);
                }
                if ((entry = state.book.contents.entries.get(href = parameter.contains(":") ? new ResourceLocation(parameter) : new ResourceLocation(state.book.getModNamespace(), parameter))) != null) {
                    state.tooltip = entry.isLocked() ? new TranslationTextComponent("patchouli.gui.lexicon.locked").func_240699_a_(TextFormatting.GRAY) : entry.getName();
                    GuiBook gui = state.gui;
                    Book book = state.book;
                    int page = 0;
                    if (anchor != null) {
                        int anchorPage = entry.getPageFromAnchor(anchor);
                        if (anchorPage >= 0) {
                            page = anchorPage / 2;
                        } else {
                            state.tooltip.func_240702_b_(" (INVALID ANCHOR:" + anchor + ")");
                        }
                    }
                    int finalPage = page;
                    state.onClick = () -> {
                        GuiBookEntry entryGui = new GuiBookEntry(book, entry, finalPage);
                        gui.displayLexiconGui(entryGui, true);
                        GuiBook.playBookFlipSound(book);
                        return true;
                    };
                } else {
                    state.tooltip = new StringTextComponent("BAD LINK: " + parameter);
                }
            }
            return "";
        }, "l");
        BookTextParser.register((String parameter, SpanState state) -> {
            state.tooltip = new StringTextComponent(parameter);
            state.cluster = new LinkedList<Span>();
            return "";
        }, "tooltip", "t");
        BookTextParser.register((String parameter, SpanState state) -> {
            state.pushStyle(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)state.book.linkColor)));
            state.cluster = new LinkedList<Span>();
            state.tooltip = !parameter.startsWith("/") ? new StringTextComponent("INVALID COMMAND (must begin with /)") : new StringTextComponent(parameter.length() < 20 ? parameter : parameter.substring(0, 20) + "...");
            state.onClick = () -> {
                state.gui.getMinecraft().field_71439_g.func_71165_d(parameter);
                return true;
            };
            return "";
        }, "command", "c");
        BookTextParser.register((SpanState state) -> {
            state.popStyle();
            state.cluster = null;
            state.tooltip = EMPTY_STRING_COMPONENT;
            state.onClick = null;
            return "";
        }, "/c");
    }

    public static interface FunctionProcessor {
        public String process(String var1, SpanState var2);
    }

    public static interface CommandProcessor {
        public String process(SpanState var1);
    }

    public static interface CommandLookup {
        public Optional<String> process(String var1, SpanState var2);
    }
}

