/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.tracking;

import com.cazsius.solcarrot.SOLCarrotConfig;
import com.cazsius.solcarrot.lib.Localization;
import com.cazsius.solcarrot.tracking.CapabilityHandler;
import com.cazsius.solcarrot.tracking.FoodList;
import com.cazsius.solcarrot.tracking.MaxHealthHandler;
import com.cazsius.solcarrot.tracking.ProgressInfo;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="solcarrot")
public final class FoodTracker {
    @SubscribeEvent
    public static void onFoodEaten(LivingEntityUseItemEvent.Finish event) {
        boolean isInSurvival;
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntity();
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        ServerWorld world = (ServerWorld)player.field_70170_p;
        ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
        boolean bl = isInSurvival = serverPlayer.field_71134_c.func_73081_b() == GameType.SURVIVAL;
        if (SOLCarrotConfig.limitProgressionToSurvival() && !isInSurvival) {
            return;
        }
        Item usedItem = event.getItem().func_77973_b();
        if (!usedItem.func_219971_r()) {
            return;
        }
        FoodList foodList = FoodList.get(player);
        boolean hasTriedNewFood = foodList.addFood(usedItem);
        boolean newMilestoneReached = MaxHealthHandler.updateFoodHPModifier(player);
        CapabilityHandler.syncFoodList(player);
        ProgressInfo progressInfo = foodList.getProgressInfo();
        if (newMilestoneReached) {
            if (SOLCarrotConfig.shouldPlayMilestoneSounds()) {
                world.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187802_ec, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            if (SOLCarrotConfig.shouldSpawnMilestoneParticles()) {
                FoodTracker.spawnParticles(world, player, (IParticleData)ParticleTypes.field_197633_z, 12);
                if (progressInfo.hasReachedMax()) {
                    FoodTracker.spawnParticles(world, player, (IParticleData)ParticleTypes.field_197632_y, 16);
                }
            }
            IFormattableTextComponent heartsDescription = Localization.localizedQuantityComponent("message", "hearts", SOLCarrotConfig.getHeartsPerMilestone());
            if (SOLCarrotConfig.shouldShowProgressAboveHotbar()) {
                String messageKey = progressInfo.hasReachedMax() ? "finished.hotbar" : "milestone_achieved";
                player.func_146105_b((ITextComponent)Localization.localizedComponent("message", messageKey, heartsDescription), true);
            } else {
                FoodTracker.showChatMessage(player, TextFormatting.DARK_AQUA, (ITextComponent)Localization.localizedComponent("message", "milestone_achieved", heartsDescription));
                if (progressInfo.hasReachedMax()) {
                    FoodTracker.showChatMessage(player, TextFormatting.GOLD, (ITextComponent)Localization.localizedComponent("message", "finished.chat", new Object[0]));
                }
            }
        } else if (hasTriedNewFood && SOLCarrotConfig.shouldSpawnIntermediateParticles()) {
            FoodTracker.spawnParticles(world, player, (IParticleData)ParticleTypes.field_197624_q, 12);
        }
    }

    private static void spawnParticles(ServerWorld world, PlayerEntity player, IParticleData type, int count) {
        world.func_195598_a(type, player.func_226277_ct_(), player.func_226278_cu_() + (double)player.func_70047_e(), player.func_226281_cx_(), count, 0.5, 0.5, 0.5, 0.0);
    }

    private static void showChatMessage(PlayerEntity player, TextFormatting color, ITextComponent message) {
        IFormattableTextComponent component = Localization.localizedComponent("message", "chat_wrapper", message).func_240700_a_(style -> style.func_240721_b_(color));
        player.func_146105_b((ITextComponent)component, false);
    }

    private FoodTracker() {
    }
}

