/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.commands;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.util.lang.ITranslationProvider;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

final class AllowPlayerOverrideManager {
    private final Cache<UUID, Boolean> allowPlayerOverrideCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).removalListener(notification -> BuildingGadgets.LOG.info("Player with id {} was removed from the list of players for which '{}' is {} enabled. He/She will need to run the command again for '{}' to become active again.", notification.getKey(), (Object)logMessage, (Object)((Boolean)notification.getValue() != false ? "" : "not"), (Object)logMessage)).build();
    private final ITranslationProvider noPlayerTranslation;
    private final ITranslationProvider toggledTranslation;
    private final ITranslationProvider listTranslation;
    private final String logMessage;

    public AllowPlayerOverrideManager(ITranslationProvider noPlayerTranslation, ITranslationProvider toggledTranslation, ITranslationProvider listTranslation, String logMessage) {
        this.noPlayerTranslation = noPlayerTranslation;
        this.toggledTranslation = toggledTranslation;
        this.listTranslation = listTranslation;
        this.logMessage = logMessage;
    }

    void toggleAllowOverride(PlayerEntity player) {
        this.toggleAllowOverride(player.func_110124_au());
    }

    void toggleAllowOverride(UUID uuid) {
        try {
            this.allowPlayerOverrideCache.put((Object)uuid, (Object)((Boolean)this.allowPlayerOverrideCache.get((Object)uuid, () -> false) == false ? 1 : 0));
        }
        catch (ExecutionException e) {
            BuildingGadgets.LOG.warn("Failed to toggle '{}' for player {}", (Object)this.logMessage, (Object)uuid, (Object)e);
        }
    }

    boolean mayOverride(UUID uuid) {
        Boolean res = (Boolean)this.allowPlayerOverrideCache.getIfPresent((Object)uuid);
        return res != null ? res : false;
    }

    boolean mayOverride(PlayerEntity player) {
        return this.mayOverride(player.func_110124_au());
    }

    int executeToggle(CommandContext<CommandSource> context, PlayerEntity player) {
        if (player == null) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)this.noPlayerTranslation.componentTranslation(new Object[0]).func_230530_a_(Styles.RED));
            return 0;
        }
        this.toggleAllowOverride(player);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)this.toggledTranslation.componentTranslation(player.func_145748_c_(), this.mayOverride(player)).func_230530_a_(Styles.AQUA), true);
        return 1;
    }

    int executeList(CommandContext<CommandSource> context) {
        for (Map.Entry entry : this.allowPlayerOverrideCache.asMap().entrySet()) {
            TranslationTextComponent component = this.listTranslation.componentTranslation(entry.getKey(), entry.getValue());
            component = (TranslationTextComponent)((Boolean)entry.getValue() != false ? component.func_230530_a_(Styles.BLUE) : component.func_230530_a_(Styles.DK_GREEN));
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)component, true);
        }
        return 1;
    }
}

