/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.network.packets;

import com.direwolf20.buildinggadgets.common.items.GadgetCopyPaste;
import com.direwolf20.buildinggadgets.common.tainted.building.Region;
import com.direwolf20.buildinggadgets.common.util.lang.MessageTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketCopyCoords {
    private final BlockPos start;
    private final BlockPos end;

    public PacketCopyCoords(BlockPos start, BlockPos end) {
        this.start = start;
        this.end = end;
    }

    public static void encode(PacketCopyCoords msg, PacketBuffer buffer) {
        buffer.func_179255_a(msg.start);
        buffer.func_179255_a(msg.end);
    }

    public static PacketCopyCoords decode(PacketBuffer buffer) {
        return new PacketCopyCoords(buffer.func_179259_c(), buffer.func_179259_c());
    }

    public static class Handler {
        public static void handle(PacketCopyCoords msg, Supplier<NetworkEvent.Context> ctx) {
            ServerPlayerEntity playerEntity = ctx.get().getSender();
            if (playerEntity == null) {
                return;
            }
            ctx.get().enqueueWork(() -> {
                ItemStack heldItem = GadgetCopyPaste.getGadget((PlayerEntity)playerEntity);
                if (heldItem.func_190926_b()) {
                    return;
                }
                BlockPos startPos = msg.start;
                BlockPos endPos = msg.end;
                if (startPos.equals((Object)BlockPos.field_177992_a) && endPos.equals((Object)BlockPos.field_177992_a)) {
                    GadgetCopyPaste.setSelectedRegion(heldItem, null);
                    playerEntity.func_146105_b((ITextComponent)MessageTranslation.AREA_RESET.componentTranslation(new Object[0]).func_230530_a_(Styles.AQUA), true);
                } else {
                    GadgetCopyPaste.setSelectedRegion(heldItem, new Region((Vector3i)startPos, (Vector3i)endPos));
                }
                Optional<Region> regionOpt = GadgetCopyPaste.getSelectedRegion(heldItem);
                if (!regionOpt.isPresent()) {
                    playerEntity.func_146105_b((ITextComponent)MessageTranslation.FIRST_COPY.componentTranslation(new Object[0]).func_230530_a_(Styles.DK_GREEN), true);
                }
                regionOpt.ifPresent(region -> ((GadgetCopyPaste)heldItem.func_77973_b()).tryCopy(heldItem, playerEntity.field_70170_p, (PlayerEntity)playerEntity, (Region)region));
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

