/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.save;

import com.direwolf20.buildinggadgets.common.util.helpers.NBTHelper;
import it.unimi.dsi.fastutil.longs.Long2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectSortedMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.storage.WorldSavedData;

public abstract class TimedDataSave<T extends TimedValue>
extends WorldSavedData {
    private Map<UUID, T> idToValue = new HashMap<UUID, T>();
    private Long2ObjectSortedMap<Set<UUID>> timeToId = new Long2ObjectRBTreeMap();

    public TimedDataSave(String name) {
        super(name);
    }

    public UUID getFreeUUID() {
        UUID res = UUID.randomUUID();
        return this.idToValue.containsKey(res) ? this.getFreeUUID() : res;
    }

    protected void writeAllIds(PacketBuffer buffer) {
        for (UUID id : this.idToValue.keySet()) {
            buffer.func_179252_a(id);
        }
    }

    protected T get(UUID id) {
        return (T)this.get(id, uuid -> this.createValue());
    }

    protected T get(UUID id, Function<UUID, T> factory) {
        this.func_76185_a();
        return (T)((TimedValue)this.idToValue.computeIfAbsent(id, factory));
    }

    protected void remove(UUID id) {
        Set set;
        TimedValue val = (TimedValue)this.idToValue.remove(id);
        if (val != null && !(set = (Set)this.timeToId.get(val.getUpdateTime())).isEmpty()) {
            set.remove(id);
            if (set.isEmpty()) {
                this.timeToId.remove(val.getUpdateTime());
            }
        }
    }

    protected boolean contains(UUID id) {
        return this.idToValue.containsKey(id);
    }

    public long getLastUpdateTime(UUID id) {
        return ((TimedValue)this.get(id)).getUpdateTime();
    }

    public void func_76184_a(CompoundNBT nbt) {
        INBT timeList = nbt.func_74781_a("data_map");
        this.timeToId.clear();
        this.idToValue.clear();
        if (timeList instanceof ListNBT) {
            NBTHelper.deserializeUUIDMap((ListNBT)timeList, this.idToValue, inbt -> this.readValue((CompoundNBT)inbt));
            for (Map.Entry<UUID, T> entry : this.idToValue.entrySet()) {
                ((Set)this.timeToId.computeIfAbsent(((TimedValue)entry.getValue()).getUpdateTime(), i -> new HashSet())).add(entry.getKey());
            }
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        ListNBT data = NBTHelper.serializeUUIDMap(this.idToValue, TimedValue::write);
        compound.func_218657_a("data_map", (INBT)data);
        return compound;
    }

    protected abstract T createValue();

    protected abstract T readValue(CompoundNBT var1);

    public static class TimedValue {
        private long lastUpdateTime;

        protected TimedValue(CompoundNBT nbt) {
            this(nbt.func_150297_b("time", 4) ? nbt.func_74763_f("time") : System.currentTimeMillis());
        }

        protected TimedValue(long lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        protected TimedValue() {
            this(System.currentTimeMillis());
        }

        public TimedValue updateTime() {
            this.lastUpdateTime = System.currentTimeMillis();
            return this;
        }

        public long getUpdateTime() {
            return this.lastUpdateTime;
        }

        public CompoundNBT write() {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74772_a("time", this.lastUpdateTime);
            return nbt;
        }
    }
}

