/*
 * Decompiled with CFR 0.152.
 */
package yalter.mousetweaks.handlers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.FurnaceResultSlot;
import net.minecraft.inventory.container.MerchantResultSlot;
import net.minecraft.inventory.container.RepairContainer;
import net.minecraft.inventory.container.Slot;
import yalter.mousetweaks.Constants;
import yalter.mousetweaks.IGuiScreenHandler;
import yalter.mousetweaks.MouseButton;
import yalter.mousetweaks.Reflection;
import yalter.mousetweaks.api.MouseTweaksDisableWheelTweak;
import yalter.mousetweaks.api.MouseTweaksIgnore;

public class GuiContainerHandler
implements IGuiScreenHandler {
    Minecraft mc = Minecraft.func_71410_x();
    private ContainerScreen guiContainer;
    private Method handleMouseClick;

    public GuiContainerHandler(ContainerScreen guiContainer) {
        this.guiContainer = guiContainer;
        this.handleMouseClick = Reflection.getHMCMethod(guiContainer);
    }

    @Override
    public boolean isMouseTweaksDisabled() {
        return this.guiContainer.getClass().isAnnotationPresent(MouseTweaksIgnore.class) || Reflection.guiContainerClass == null;
    }

    @Override
    public boolean isWheelTweakDisabled() {
        return this.guiContainer.getClass().isAnnotationPresent(MouseTweaksDisableWheelTweak.class);
    }

    @Override
    public List<Slot> getSlots() {
        return this.guiContainer.func_212873_a_().field_75151_b;
    }

    @Override
    public Slot getSlotUnderMouse(double mouseX, double mouseY) {
        try {
            return (Slot)Reflection.guiContainerClass.invokeMethod(this.guiContainer, Constants.GETSELECTEDSLOT_NAME.forgeName, mouseX, mouseY);
        }
        catch (InvocationTargetException e) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)e, (String)"GuiContainer.getSlotAtPosition() threw an exception when called from MouseTweaks.");
            throw new ReportedException(crashreport);
        }
    }

    @Override
    public boolean disableRMBDraggingFunctionality() {
        Reflection.guiContainerClass.setFieldValue(this.guiContainer, Constants.IGNOREMOUSEUP_NAME.forgeName, true);
        if (((Boolean)Reflection.guiContainerClass.getFieldValue(this.guiContainer, Constants.DRAGSPLITTING_NAME.forgeName)).booleanValue() && (Integer)Reflection.guiContainerClass.getFieldValue(this.guiContainer, Constants.DRAGSPLITTINGBUTTON_NAME.forgeName) == 1) {
            Reflection.guiContainerClass.setFieldValue(this.guiContainer, Constants.DRAGSPLITTING_NAME.forgeName, false);
            return true;
        }
        return false;
    }

    @Override
    public void clickSlot(Slot slot, MouseButton mouseButton, boolean shiftPressed) {
        try {
            this.handleMouseClick.invoke((Object)this.guiContainer, slot, slot.field_75222_d, mouseButton.getValue(), shiftPressed ? ClickType.QUICK_MOVE : ClickType.PICKUP);
        }
        catch (InvocationTargetException e) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)e, (String)"handleMouseClick() threw an exception when called from MouseTweaks.");
            throw new ReportedException(crashreport);
        }
        catch (IllegalAccessException e) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)e, (String)"Calling handleMouseClick() from MouseTweaks.");
            throw new ReportedException(crashreport);
        }
    }

    @Override
    public boolean isCraftingOutput(Slot slot) {
        return slot instanceof CraftingResultSlot || slot instanceof FurnaceResultSlot || slot instanceof MerchantResultSlot || this.guiContainer.func_212873_a_() instanceof RepairContainer && slot.field_75222_d == 2;
    }

    @Override
    public boolean isIgnored(Slot slot) {
        return false;
    }
}

