/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.modules.filter.items;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import mcjty.lib.varia.ItemStackList;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.ItemHandlerHelper;

public class FilterModuleInventory {
    private ItemStackList stacks = ItemStackList.create();
    private Set<ResourceLocation> tags = new HashSet<ResourceLocation>();
    private final Supplier<ItemStack> filterGetter;

    public FilterModuleInventory(PlayerEntity player) {
        this.filterGetter = () -> player.func_184586_b(Hand.MAIN_HAND);
        CompoundNBT tagCompound = player.func_184586_b(Hand.MAIN_HAND).func_196082_o();
        this.convertFromNBT(tagCompound);
    }

    public FilterModuleInventory(ItemStack filterItem) {
        this.filterGetter = () -> filterItem;
        CompoundNBT tagCompound = filterItem.func_196082_o();
        this.convertFromNBT(tagCompound);
    }

    private void convertFromNBT(CompoundNBT tagCompound) {
        Object s;
        ListNBT itemList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < itemList.size(); ++i) {
            CompoundNBT compound = itemList.func_150305_b(i);
            s = ItemStack.func_199557_a((CompoundNBT)compound);
            if (s.func_190926_b()) continue;
            this.stacks.add(s);
        }
        ListNBT tagList = tagCompound.func_150295_c("Tags", 8);
        for (int i = 0; i < tagList.size(); ++i) {
            s = tagList.func_150307_f(i);
            this.tags.add(new ResourceLocation((String)s));
        }
    }

    public void addStack(ItemStack stack) {
        ItemStack toPlace = stack.func_77946_l();
        toPlace.func_190920_e(1);
        for (ItemStack s : this.stacks) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)s, (ItemStack)toPlace)) continue;
            return;
        }
        this.stacks.add((Object)toPlace);
    }

    public void removeStack(int idx) {
        this.stacks.remove(idx);
    }

    public void removeTag(ResourceLocation id) {
        this.tags.remove(id);
    }

    public void addTag(ResourceLocation id) {
        this.tags.add(id);
    }

    public List<ItemStack> getStacks() {
        return this.stacks;
    }

    public Set<ResourceLocation> getTags() {
        return this.tags;
    }

    public void markDirty() {
        ItemStack heldItem = this.filterGetter.get();
        if (!heldItem.func_190926_b()) {
            CompoundNBT tagCompound = heldItem.func_196082_o();
            ListNBT itemList = new ListNBT();
            for (ItemStack stack : this.stacks) {
                CompoundNBT nbtTagCompound = new CompoundNBT();
                if (!stack.func_190926_b()) {
                    stack.func_77955_b(nbtTagCompound);
                }
                itemList.add((Object)nbtTagCompound);
            }
            tagCompound.func_218657_a("Items", (INBT)itemList);
            ListNBT tagList = new ListNBT();
            for (ResourceLocation tag : this.tags) {
                tagList.add((Object)StringNBT.func_229705_a_((String)tag.toString()));
            }
            tagCompound.func_218657_a("Tags", (INBT)tagList);
        }
    }
}

