/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.blay09.mods.waystones.api.IMutableWaystone;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.api.WaystoneActivatedEvent;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.blay09.mods.waystones.block.WaystoneBlockBase;
import net.blay09.mods.waystones.config.DimensionalWarp;
import net.blay09.mods.waystones.config.InventoryButtonMode;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.IPlayerWaystoneData;
import net.blay09.mods.waystones.core.InMemoryPlayerWaystoneData;
import net.blay09.mods.waystones.core.PersistentPlayerWaystoneData;
import net.blay09.mods.waystones.core.WarpMode;
import net.blay09.mods.waystones.core.WaystoneEditPermissions;
import net.blay09.mods.waystones.core.WaystoneManager;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.core.WaystoneTeleportContext;
import net.blay09.mods.waystones.core.WaystoneTeleporter;
import net.blay09.mods.waystones.core.WaystoneTypes;
import net.blay09.mods.waystones.item.ModItems;
import net.blay09.mods.waystones.network.NetworkHandler;
import net.blay09.mods.waystones.network.message.TeleportEffectMessage;
import net.blay09.mods.waystones.tileentity.WarpPlateTileEntity;
import net.blay09.mods.waystones.worldgen.namegen.NameGenerationMode;
import net.blay09.mods.waystones.worldgen.namegen.NameGenerator;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.network.play.server.SSetPassengersPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerWaystoneManager {
    private static final Logger logger = LogManager.getLogger();
    private static final IPlayerWaystoneData persistentPlayerWaystoneData = new PersistentPlayerWaystoneData();
    private static final IPlayerWaystoneData inMemoryPlayerWaystoneData = new InMemoryPlayerWaystoneData();

    public static boolean mayBreakWaystone(PlayerEntity player, IBlockReader world, BlockPos pos) {
        if (((Boolean)WaystonesConfig.SERVER.restrictToCreative.get()).booleanValue() && !player.field_71075_bZ.field_75098_d) {
            return false;
        }
        return WaystoneManager.get().getWaystoneAt(world, pos).map(waystone -> {
            if (!player.field_71075_bZ.field_75098_d) {
                if (waystone.wasGenerated() && ((Boolean)WaystonesConfig.SERVER.generatedWaystonesUnbreakable.get()).booleanValue()) {
                    return false;
                }
                boolean isGlobal = waystone.isGlobal();
                boolean mayBreakGlobalWaystones = (Boolean)WaystonesConfig.SERVER.globalWaystoneRequiresCreative.get() == false;
                return !isGlobal || mayBreakGlobalWaystones;
            }
            return true;
        }).orElse(true);
    }

    public static boolean mayPlaceWaystone(@Nullable PlayerEntity player) {
        return (Boolean)WaystonesConfig.SERVER.restrictToCreative.get() == false || player != null && player.field_71075_bZ.field_75098_d;
    }

    public static WaystoneEditPermissions mayEditWaystone(PlayerEntity player, World world, IWaystone waystone) {
        if (((Boolean)WaystonesConfig.SERVER.restrictToCreative.get()).booleanValue() && !player.field_71075_bZ.field_75098_d) {
            return WaystoneEditPermissions.NOT_CREATIVE;
        }
        if (((Boolean)WaystonesConfig.SERVER.restrictRenameToOwner.get()).booleanValue() && !waystone.isOwner(player)) {
            return WaystoneEditPermissions.NOT_THE_OWNER;
        }
        if (waystone.isGlobal() && !player.field_71075_bZ.field_75098_d && ((Boolean)WaystonesConfig.SERVER.globalWaystoneRequiresCreative.get()).booleanValue()) {
            return WaystoneEditPermissions.GET_CREATIVE;
        }
        return WaystoneEditPermissions.ALLOW;
    }

    public static boolean isWaystoneActivated(PlayerEntity player, IWaystone waystone) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.field_70170_p).isWaystoneActivated(player, waystone);
    }

    public static void activateWaystone(PlayerEntity player, IWaystone waystone) {
        if (!waystone.hasName() && waystone instanceof IMutableWaystone && waystone.wasGenerated()) {
            NameGenerationMode nameGenerationMode = (NameGenerationMode)((Object)WaystonesConfig.COMMON.nameGenerationMode.get());
            String name = NameGenerator.get().getName(waystone, player.field_70170_p.field_73012_v, nameGenerationMode);
            ((IMutableWaystone)((Object)waystone)).setName(name);
        }
        if (!waystone.hasOwner() && waystone instanceof IMutableWaystone) {
            ((IMutableWaystone)((Object)waystone)).setOwnerUid(player.func_110124_au());
        }
        if (!PlayerWaystoneManager.isWaystoneActivated(player, waystone) && waystone.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE)) {
            PlayerWaystoneManager.getPlayerWaystoneData(player.field_70170_p).activateWaystone(player, waystone);
            MinecraftForge.EVENT_BUS.post((Event)new WaystoneActivatedEvent(player, waystone));
        }
    }

    public static int getExperienceLevelCost(Entity player, IWaystone waystone, WarpMode warpMode, @Nullable IWaystone fromWaystone) {
        WaystoneTeleportContext context = new WaystoneTeleportContext();
        context.setLeashedEntities(PlayerWaystoneManager.findLeashedAnimals(player));
        context.setFromWaystone(fromWaystone);
        return PlayerWaystoneManager.getExperienceLevelCost(player, waystone, warpMode, context);
    }

    public static int getExperienceLevelCost(Entity entity, IWaystone waystone, WarpMode warpMode, WaystoneTeleportContext context) {
        double xpLevelCost;
        if (!(entity instanceof PlayerEntity)) {
            return 0;
        }
        PlayerEntity player = (PlayerEntity)entity;
        if (context.getFromWaystone() != null && waystone.getWaystoneUid().equals(context.getFromWaystone().getWaystoneUid())) {
            return 0;
        }
        boolean enableXPCost = !player.field_71075_bZ.field_75098_d;
        int xpForLeashed = (Integer)WaystonesConfig.SERVER.costPerLeashed.get() * context.getLeashedEntities().size();
        if (waystone.getDimension() != player.field_70170_p.func_234923_W_()) {
            return enableXPCost ? (Integer)WaystonesConfig.SERVER.dimensionalWarpXpCost.get() + xpForLeashed : 0;
        }
        double xpCostMultiplier = warpMode.getXpCostMultiplier();
        if (waystone.isGlobal()) {
            xpCostMultiplier *= ((Double)WaystonesConfig.SERVER.globalWaystoneXpCostMultiplier.get()).doubleValue();
        }
        BlockPos pos = waystone.getPos();
        double dist = Math.sqrt(player.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()));
        double minimumXpCost = (Double)WaystonesConfig.SERVER.minimumXpCost.get();
        double maximumXpCost = (Double)WaystonesConfig.SERVER.maximumXpCost.get();
        if ((Integer)WaystonesConfig.SERVER.blocksPerXPLevel.get() > 0) {
            xpLevelCost = MathHelper.func_151237_a((double)(dist / (double)((Integer)WaystonesConfig.SERVER.blocksPerXPLevel.get()).intValue()), (double)minimumXpCost, (double)maximumXpCost);
            if (((Boolean)WaystonesConfig.SERVER.inverseXpCost.get()).booleanValue()) {
                xpLevelCost = maximumXpCost - xpLevelCost;
            }
        } else {
            xpLevelCost = minimumXpCost;
        }
        return enableXPCost ? (int)Math.round((xpLevelCost + (double)xpForLeashed) * xpCostMultiplier) : 0;
    }

    @Nullable
    public static IWaystone getInventoryButtonWaystone(PlayerEntity player) {
        InventoryButtonMode inventoryButtonMode = WaystonesConfig.getInventoryButtonMode();
        if (inventoryButtonMode.isReturnToNearest()) {
            return PlayerWaystoneManager.getNearestWaystone(player);
        }
        if (inventoryButtonMode.hasNamedTarget()) {
            return WaystoneManager.get().findWaystoneByName(inventoryButtonMode.getNamedTarget()).orElse(null);
        }
        return null;
    }

    public static boolean canUseInventoryButton(PlayerEntity player) {
        IWaystone waystone = PlayerWaystoneManager.getInventoryButtonWaystone(player);
        int xpLevelCost = waystone != null ? PlayerWaystoneManager.getExperienceLevelCost((Entity)player, waystone, WarpMode.INVENTORY_BUTTON, (IWaystone)null) : 0;
        return PlayerWaystoneManager.getInventoryButtonCooldownLeft(player) <= 0L && (xpLevelCost <= 0 || player.field_71068_ca >= xpLevelCost);
    }

    public static boolean canUseWarpStone(PlayerEntity player, ItemStack heldItem) {
        return PlayerWaystoneManager.getWarpStoneCooldownLeft(player) <= 0L;
    }

    public static double getCooldownMultiplier(IWaystone waystone) {
        return waystone.isGlobal() ? (Double)WaystonesConfig.SERVER.globalWaystoneCooldownMultiplier.get() : 1.0;
    }

    private static void informPlayer(Entity entity, String translationKey) {
        if (entity instanceof PlayerEntity) {
            TranslationTextComponent chatComponent = new TranslationTextComponent(translationKey);
            chatComponent.func_240699_a_(TextFormatting.RED);
            ((PlayerEntity)entity).func_146105_b((ITextComponent)chatComponent, false);
        }
    }

    public static boolean tryTeleportToWaystone(Entity entity, IWaystone waystone, WarpMode warpMode, @Nullable IWaystone fromWaystone) {
        boolean isCreativeMode;
        BlockState state;
        MinecraftServer server;
        boolean isDimensionalWarp;
        if (!waystone.isValid()) {
            logger.info("Rejected teleport to invalid waystone");
            return false;
        }
        ItemStack warpItem = PlayerWaystoneManager.findWarpItem(entity, warpMode);
        if (!PlayerWaystoneManager.canUseWarpMode(entity, warpMode, warpItem, fromWaystone)) {
            logger.info("Rejected teleport using warp mode {}", (Object)warpMode);
            return false;
        }
        if (!warpMode.getAllowTeleportPredicate().test(entity, waystone)) {
            logger.info("Rejected teleport due to predicate");
            return false;
        }
        boolean bl = isDimensionalWarp = waystone.getDimension() != entity.field_70170_p.func_234923_W_();
        if (isDimensionalWarp && !PlayerWaystoneManager.canDimensionalWarpBetween(entity, waystone)) {
            logger.info("Rejected dimensional teleport");
            PlayerWaystoneManager.informPlayer(entity, "chat.waystones.cannot_dimension_warp");
            return false;
        }
        List<MobEntity> leashed = PlayerWaystoneManager.findLeashedAnimals(entity);
        if (!leashed.isEmpty()) {
            if (!((Boolean)WaystonesConfig.SERVER.transportLeashed.get()).booleanValue()) {
                logger.info("Rejected teleport with leashed entities");
                PlayerWaystoneManager.informPlayer(entity, "chat.waystones.cannot_transport_leashed");
                return false;
            }
            List forbidden = ((List)WaystonesConfig.SERVER.leashedBlacklist.get()).stream().map(ResourceLocation::new).collect(Collectors.toList());
            if (leashed.stream().anyMatch(e -> forbidden.contains(e.func_200600_R().getRegistryName()))) {
                logger.info("Rejected teleport with denied leashed entity");
                PlayerWaystoneManager.informPlayer(entity, "chat.waystones.cannot_transport_this_leashed");
                return false;
            }
            if (isDimensionalWarp && !((Boolean)WaystonesConfig.SERVER.transportLeashedDimensional.get()).booleanValue()) {
                logger.info("Rejected teleport with dimensionally denied leashed entity");
                PlayerWaystoneManager.informPlayer(entity, "chat.waystones.cannot_transport_leashed_dimensional");
                return false;
            }
        }
        if ((server = entity.func_184102_h()) == null) {
            logger.info("Rejected teleport due to missing server");
            return false;
        }
        ServerWorld targetWorld = Objects.requireNonNull(server).func_71218_a(waystone.getDimension());
        BlockPos pos = waystone.getPos();
        BlockState blockState = state = targetWorld != null ? targetWorld.func_180495_p(pos) : null;
        if (targetWorld == null || !(state.func_177230_c() instanceof WaystoneBlockBase)) {
            logger.info("Rejected teleport due to missing waystone");
            PlayerWaystoneManager.informPlayer(entity, "chat.waystones.waystone_missing");
            return false;
        }
        Direction direction = (Direction)state.func_177229_b((Property)WaystoneBlock.FACING);
        ArrayList directionCandidates = Lists.newArrayList((Object[])new Direction[]{direction, Direction.EAST, Direction.WEST, Direction.SOUTH, Direction.NORTH});
        for (Direction candidate : directionCandidates) {
            BlockPos offsetPos = pos.func_177972_a(candidate);
            BlockPos offsetPosUp = offsetPos.func_177984_a();
            if (targetWorld.func_180495_p(offsetPos).func_229980_m_((IBlockReader)targetWorld, offsetPos) || targetWorld.func_180495_p(offsetPosUp).func_229980_m_((IBlockReader)targetWorld, offsetPosUp)) continue;
            direction = candidate;
            break;
        }
        WaystoneTeleportContext context = new WaystoneTeleportContext();
        context.setLeashedEntities(leashed);
        context.setDirection(direction);
        context.setTargetWorld(targetWorld);
        context.setFromWaystone(fromWaystone);
        int xpLevelCost = PlayerWaystoneManager.getExperienceLevelCost(entity, waystone, warpMode, context);
        if (entity instanceof PlayerEntity && ((PlayerEntity)entity).field_71068_ca < xpLevelCost) {
            logger.info("Rejected teleport due to missing xp");
            return false;
        }
        boolean bl2 = isCreativeMode = entity instanceof PlayerEntity && ((PlayerEntity)entity).field_71075_bZ.field_75098_d;
        if (warpMode.consumesItem() && !isCreativeMode) {
            warpItem.func_190918_g(1);
        }
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            if (warpMode == WarpMode.INVENTORY_BUTTON) {
                int cooldown = (int)((double)((Integer)WaystonesConfig.SERVER.inventoryButtonCooldown.get()).intValue() * PlayerWaystoneManager.getCooldownMultiplier(waystone));
                PlayerWaystoneManager.getPlayerWaystoneData(entity.field_70170_p).setInventoryButtonCooldownUntil(player, player.field_70170_p.func_82737_E() + (long)cooldown * 20L);
                WaystoneSyncManager.sendWaystoneCooldowns(player);
            } else if (warpMode == WarpMode.WARP_STONE) {
                int cooldown = (int)((double)((Integer)WaystonesConfig.SERVER.warpStoneCooldown.get()).intValue() * PlayerWaystoneManager.getCooldownMultiplier(waystone));
                PlayerWaystoneManager.getPlayerWaystoneData(entity.field_70170_p).setWarpStoneCooldownUntil(player, player.field_70170_p.func_82737_E() + (long)cooldown * 20L);
                WaystoneSyncManager.sendWaystoneCooldowns(player);
            }
            if (xpLevelCost > 0) {
                player.func_82242_a(-xpLevelCost);
            }
        }
        PlayerWaystoneManager.teleportToWaystone(entity, waystone, context);
        return true;
    }

    private static boolean canDimensionalWarpBetween(Entity player, IWaystone waystone) {
        ResourceLocation fromDimension = player.func_130014_f_().func_234923_W_().func_240901_a_();
        ResourceLocation toDimension = waystone.getDimension().func_240901_a_();
        List dimensionAllowList = (List)WaystonesConfig.COMMON.dimensionalWarpAllowList.get();
        List dimensionDenyList = (List)WaystonesConfig.COMMON.dimensionalWarpDenyList.get();
        if (!(dimensionAllowList.isEmpty() || dimensionAllowList.contains(toDimension.toString()) && dimensionAllowList.contains(fromDimension.toString()))) {
            return false;
        }
        if (!dimensionDenyList.isEmpty() && (dimensionDenyList.contains(toDimension.toString()) || dimensionDenyList.contains(fromDimension.toString()))) {
            return false;
        }
        DimensionalWarp dimensionalWarpMode = (DimensionalWarp)((Object)WaystonesConfig.SERVER.dimensionalWarp.get());
        return dimensionalWarpMode == DimensionalWarp.ALLOW || dimensionalWarpMode == DimensionalWarp.GLOBAL_ONLY && waystone.isGlobal();
    }

    private static ItemStack findWarpItem(Entity entity, WarpMode warpMode) {
        switch (warpMode) {
            case WARP_SCROLL: {
                return PlayerWaystoneManager.findWarpItem(entity, ModItems.warpScroll);
            }
            case WARP_STONE: {
                return PlayerWaystoneManager.findWarpItem(entity, ModItems.warpStone);
            }
            case RETURN_SCROLL: {
                return PlayerWaystoneManager.findWarpItem(entity, ModItems.returnScroll);
            }
            case BOUND_SCROLL: {
                return PlayerWaystoneManager.findWarpItem(entity, ModItems.boundScroll);
            }
        }
        return ItemStack.field_190927_a;
    }

    private static ItemStack findWarpItem(Entity entity, Item warpItem) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity.func_184614_ca().func_77973_b() == warpItem) {
                return livingEntity.func_184614_ca();
            }
            if (livingEntity.func_184592_cb().func_77973_b() == warpItem) {
                return livingEntity.func_184592_cb();
            }
        }
        return ItemStack.field_190927_a;
    }

    private static List<MobEntity> findLeashedAnimals(Entity player) {
        return player.field_70170_p.func_175647_a(MobEntity.class, new AxisAlignedBB(player.func_233580_cy_()).func_186662_g(10.0), e -> player.equals((Object)e.func_110166_bE()));
    }

    private static void teleportToWaystone(Entity entity, IWaystone waystone, WaystoneTeleportContext context) {
        TileEntity targetTileEntity;
        BlockPos sourcePos = entity.func_233580_cy_();
        BlockPos pos = waystone.getPos();
        Direction direction = context.getDirection();
        ServerWorld targetWorld = context.getTargetWorld();
        BlockPos targetPos = waystone.getWaystoneType().equals((Object)WaystoneTypes.WARP_PLATE) ? pos : pos.func_177972_a(direction);
        Vector3d targetPos3d = new Vector3d((double)targetPos.func_177958_n() + 0.5, (double)targetPos.func_177956_o() + 0.5, (double)targetPos.func_177952_p() + 0.5);
        Entity mount = entity.func_184187_bx();
        if (mount != null) {
            entity.func_184210_p();
            if (targetWorld == mount.field_70170_p) {
                mount.func_70634_a(targetPos3d.field_72450_a, targetPos3d.field_72448_b, targetPos3d.field_72449_c);
            } else {
                mount = mount.changeDimension(targetWorld, (ITeleporter)new WaystoneTeleporter(targetPos3d));
            }
        }
        if ((targetTileEntity = context.getTargetWorld().func_175625_s(waystone.getPos())) instanceof WarpPlateTileEntity) {
            ((WarpPlateTileEntity)targetTileEntity).markEntityForCooldown(entity);
            if (mount != null) {
                ((WarpPlateTileEntity)targetTileEntity).markEntityForCooldown(mount);
            }
            context.getLeashedEntities().forEach(((WarpPlateTileEntity)targetTileEntity)::markEntityForCooldown);
        }
        if (entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            player.func_200619_a(targetWorld, targetPos3d.func_82615_a(), (double)targetPos.func_177956_o(), targetPos3d.func_82616_c(), direction.func_185119_l(), entity.field_70125_A);
            if (mount != null) {
                player.func_184220_m(mount);
                player.field_71135_a.func_147359_a((IPacket)new SSetPassengersPacket(mount));
            }
            for (EffectInstance effectinstance : player.func_70651_bq()) {
                player.field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(entity.func_145782_y(), effectinstance));
            }
            player.func_195399_b(player.field_71068_ca);
        } else {
            PlayerWaystoneManager.teleportEntity(entity, targetWorld, targetPos3d);
        }
        NetworkHandler.channel.send(PacketDistributor.TRACKING_CHUNK.with(() -> entity.field_70170_p.func_175726_f(sourcePos)), (Object)new TeleportEffectMessage(sourcePos));
        NetworkHandler.channel.send(PacketDistributor.TRACKING_CHUNK.with(() -> entity.field_70170_p.func_175726_f(targetPos)), (Object)new TeleportEffectMessage(targetPos));
        context.getLeashedEntities().forEach(mob -> PlayerWaystoneManager.teleportEntity((Entity)mob, targetWorld, targetPos3d));
    }

    private static void teleportEntity(Entity entity, ServerWorld targetWorld, Vector3d targetPos3d) {
        if (targetWorld == entity.field_70170_p) {
            entity.func_70107_b(targetPos3d.field_72450_a, targetPos3d.field_72448_b, targetPos3d.field_72449_c);
        } else {
            entity.changeDimension(targetWorld, (ITeleporter)new WaystoneTeleporter(targetPos3d));
        }
    }

    public static void deactivateWaystone(PlayerEntity player, IWaystone waystone) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.field_70170_p).deactivateWaystone(player, waystone);
    }

    private static boolean canUseWarpMode(Entity entity, WarpMode warpMode, ItemStack heldItem, @Nullable IWaystone fromWaystone) {
        switch (warpMode) {
            case INVENTORY_BUTTON: {
                return entity instanceof PlayerEntity && PlayerWaystoneManager.canUseInventoryButton((PlayerEntity)entity);
            }
            case WARP_SCROLL: {
                return !heldItem.func_190926_b() && heldItem.func_77973_b() == ModItems.warpScroll;
            }
            case BOUND_SCROLL: {
                return !heldItem.func_190926_b() && heldItem.func_77973_b() == ModItems.boundScroll;
            }
            case RETURN_SCROLL: {
                return !heldItem.func_190926_b() && heldItem.func_77973_b() == ModItems.returnScroll;
            }
            case WARP_STONE: {
                return !heldItem.func_190926_b() && heldItem.func_77973_b() == ModItems.warpStone && entity instanceof PlayerEntity && PlayerWaystoneManager.canUseWarpStone((PlayerEntity)entity, heldItem);
            }
            case WAYSTONE_TO_WAYSTONE: {
                return (Boolean)WaystonesConfig.COMMON.allowWaystoneToWaystoneTeleport.get() != false && fromWaystone != null && fromWaystone.isValid() && fromWaystone.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE);
            }
            case SHARESTONE_TO_SHARESTONE: {
                return fromWaystone != null && fromWaystone.isValid() && WaystoneTypes.isSharestone(fromWaystone.getWaystoneType());
            }
            case WARP_PLATE: {
                return fromWaystone != null && fromWaystone.isValid() && fromWaystone.getWaystoneType().equals((Object)WaystoneTypes.WARP_PLATE);
            }
            case PORTSTONE_TO_WAYSTONE: {
                return fromWaystone != null && fromWaystone.isValid() && fromWaystone.getWaystoneType().equals((Object)WaystoneTypes.PORTSTONE);
            }
        }
        return false;
    }

    public static long getWarpStoneCooldownUntil(PlayerEntity player) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.field_70170_p).getWarpStoneCooldownUntil(player);
    }

    public static long getWarpStoneCooldownLeft(PlayerEntity player) {
        long cooldownUntil = PlayerWaystoneManager.getWarpStoneCooldownUntil(player);
        return Math.max(0L, cooldownUntil - player.field_70170_p.func_82737_E());
    }

    public static void setWarpStoneCooldownUntil(PlayerEntity player, long timeStamp) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.field_70170_p).setWarpStoneCooldownUntil(player, timeStamp);
    }

    public static long getInventoryButtonCooldownUntil(PlayerEntity player) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.field_70170_p).getInventoryButtonCooldownUntil(player);
    }

    public static long getInventoryButtonCooldownLeft(PlayerEntity player) {
        long cooldownUntil = PlayerWaystoneManager.getInventoryButtonCooldownUntil(player);
        return Math.max(0L, cooldownUntil - player.field_70170_p.func_82737_E());
    }

    public static void setInventoryButtonCooldownUntil(PlayerEntity player, long timeStamp) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.field_70170_p).setInventoryButtonCooldownUntil(player, timeStamp);
    }

    @Nullable
    public static IWaystone getNearestWaystone(PlayerEntity player) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.field_70170_p).getWaystones(player).stream().filter(it -> it.getDimension() == player.field_70170_p.func_234923_W_()).min((first, second) -> {
            double firstDist = first.getPos().func_218140_a(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), true);
            double secondDist = second.getPos().func_218140_a(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), true);
            return (int)Math.round(firstDist) - (int)Math.round(secondDist);
        }).orElse(null);
    }

    public static List<IWaystone> getWaystones(PlayerEntity player) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.field_70170_p).getWaystones(player);
    }

    public static IPlayerWaystoneData getPlayerWaystoneData(World world) {
        return world.field_72995_K ? inMemoryPlayerWaystoneData : persistentPlayerWaystoneData;
    }

    public static IPlayerWaystoneData getPlayerWaystoneData(LogicalSide side) {
        return side.isClient() ? inMemoryPlayerWaystoneData : persistentPlayerWaystoneData;
    }

    public static boolean mayTeleportToWaystone(PlayerEntity player, IWaystone waystone) {
        return true;
    }

    public static void swapWaystoneSorting(PlayerEntity player, int index, int otherIndex) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.field_70170_p).swapWaystoneSorting(player, index, otherIndex);
    }

    public static boolean mayEditGlobalWaystones(PlayerEntity player) {
        return player.field_71075_bZ.field_75098_d || (Boolean)WaystonesConfig.SERVER.globalWaystoneRequiresCreative.get() == false;
    }

    public static void activeWaystoneForEveryone(IWaystone waystone) {
        List players = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v();
        for (ServerPlayerEntity player : players) {
            if (PlayerWaystoneManager.isWaystoneActivated((PlayerEntity)player, waystone)) continue;
            PlayerWaystoneManager.activateWaystone((PlayerEntity)player, waystone);
        }
    }

    public static void removeKnownWaystone(IWaystone waystone) {
        List players = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v();
        for (ServerPlayerEntity player : players) {
            PlayerWaystoneManager.deactivateWaystone((PlayerEntity)player, waystone);
            WaystoneSyncManager.sendActivatedWaystones((PlayerEntity)player);
        }
    }
}

