/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.core.Waystone;
import net.blay09.mods.waystones.tileentity.WaystoneTileEntityBase;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class WaystoneManager
extends WorldSavedData {
    private static final String DATA_NAME = "waystones";
    private static final String TAG_WAYSTONES = "Waystones";
    private static final WaystoneManager clientStorageCopy = new WaystoneManager();
    private final Map<UUID, IWaystone> waystones = new HashMap<UUID, IWaystone>();

    public WaystoneManager() {
        super(DATA_NAME);
    }

    public void addWaystone(IWaystone waystone) {
        this.waystones.put(waystone.getWaystoneUid(), waystone);
        this.func_76185_a();
    }

    public void updateWaystone(IWaystone waystone) {
        Waystone mutableWaystone = (Waystone)this.waystones.getOrDefault(waystone.getWaystoneUid(), waystone);
        mutableWaystone.setName(waystone.getName());
        mutableWaystone.setGlobal(waystone.isGlobal());
        this.waystones.put(waystone.getWaystoneUid(), mutableWaystone);
        this.func_76185_a();
    }

    public void removeWaystone(IWaystone waystone) {
        this.waystones.remove(waystone.getWaystoneUid());
        this.func_76185_a();
    }

    public Optional<IWaystone> getWaystoneAt(IBlockReader world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof WaystoneTileEntityBase) {
            return Optional.of(((WaystoneTileEntityBase)tileEntity).getWaystone());
        }
        return Optional.empty();
    }

    public Optional<IWaystone> getWaystoneById(UUID waystoneUid) {
        return Optional.ofNullable(this.waystones.get(waystoneUid));
    }

    public Optional<IWaystone> findWaystoneByName(String name) {
        return this.waystones.values().stream().filter(it -> it.getName().equals(name)).findFirst();
    }

    public Stream<IWaystone> getWaystonesByType(ResourceLocation type) {
        return this.waystones.values().stream().filter(it -> it.getWaystoneType().equals((Object)type)).sorted(Comparator.comparing(IWaystone::getName));
    }

    public List<IWaystone> getGlobalWaystones() {
        return this.waystones.values().stream().filter(IWaystone::isGlobal).collect(Collectors.toList());
    }

    public void func_76184_a(CompoundNBT tagCompound) {
        ListNBT tagList = tagCompound.func_150295_c(TAG_WAYSTONES, 10);
        for (INBT tag : tagList) {
            CompoundNBT compound = (CompoundNBT)tag;
            IWaystone waystone = Waystone.read(compound);
            this.waystones.put(waystone.getWaystoneUid(), waystone);
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT tagCompound) {
        ListNBT tagList = new ListNBT();
        for (IWaystone waystone : this.waystones.values()) {
            tagList.add((Object)Waystone.write(waystone, new CompoundNBT()));
        }
        tagCompound.func_218657_a(TAG_WAYSTONES, (INBT)tagList);
        return tagCompound;
    }

    public static WaystoneManager get() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            ServerWorld overworld = server.func_71218_a(World.field_234918_g_);
            DimensionSavedDataManager storage = overworld.func_217481_x();
            return (WaystoneManager)storage.func_215752_a(WaystoneManager::new, DATA_NAME);
        }
        return clientStorageCopy;
    }
}

