/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.mixin;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(targets={"net.minecraft.world.gen.feature.jigsaw.JigsawManager$Assembler"})
public class JigsawManagerAssemblerMixin {
    @Final
    @Shadow
    protected List<? super AbstractVillagePiece> field_214886_e;

    @Redirect(method={"func_236831_a_(Lnet/minecraft/world/gen/feature/structure/AbstractVillagePiece;Lorg/apache/commons/lang3/mutable/MutableObject;IIZ)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/gen/feature/jigsaw/JigsawPattern;getShuffledPieces(Ljava/util/Random;)Ljava/util/List;"))
    private List<JigsawPiece> getShuffledPieces(JigsawPattern pattern, Random rand) {
        boolean hasWaystone = this.field_214886_e.stream().map(piece -> ((AbstractVillagePiece)piece).func_214826_b().toString()).anyMatch(pieceName -> pieceName.contains("waystones:") && pieceName.contains("/waystone"));
        boolean forceWaystone = (Boolean)WaystonesConfig.COMMON.forceSpawnInVillages.get();
        if (hasWaystone) {
            return pattern.func_214943_b(rand).stream().filter(piece -> {
                String pieceName = piece.toString();
                return !pieceName.contains("waystones:") || !pieceName.contains("/waystone");
            }).collect(Collectors.toList());
        }
        if (forceWaystone || Math.random() <= (double)((float)this.field_214886_e.size() / 200.0f)) {
            JigsawPiece waystonePiece = null;
            List original = pattern.func_214943_b(rand);
            ArrayList<JigsawPiece> result = new ArrayList<JigsawPiece>();
            for (JigsawPiece piece2 : original) {
                String pieceName2 = piece2.toString();
                if (pieceName2.contains("waystones:") && pieceName2.contains("/waystone")) {
                    waystonePiece = piece2;
                    continue;
                }
                result.add(piece2);
            }
            if (waystonePiece != null) {
                result.add(0, waystonePiece);
            }
            return result;
        }
        return pattern.func_214943_b(rand);
    }
}

