/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.tileentity;

import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.blay09.mods.waystones.core.InvalidWaystone;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.Waystone;
import net.blay09.mods.waystones.core.WaystoneManager;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public abstract class WaystoneTileEntityBase
extends TileEntity {
    private IWaystone waystone = InvalidWaystone.INSTANCE;
    private boolean shouldNotInitialize;
    private boolean silkTouched;

    public WaystoneTileEntityBase(TileEntityType<? extends WaystoneTileEntityBase> type) {
        super(type);
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        if (this.waystone.isValid()) {
            tagCompound.func_218657_a("UUID", (INBT)NBTUtil.func_240626_a_((UUID)this.waystone.getWaystoneUid()));
        }
        return tagCompound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tagCompound) {
        super.func_230337_a_(state, tagCompound);
        if (tagCompound.func_150297_b("UUID", 11)) {
            this.waystone = new WaystoneProxy(NBTUtil.func_186860_b((INBT)Objects.requireNonNull(tagCompound.func_74781_a("UUID"))));
        }
    }

    public void onLoad() {
        IWaystone backingWaystone = this.waystone;
        if (this.waystone instanceof WaystoneProxy) {
            backingWaystone = ((WaystoneProxy)this.waystone).getBackingWaystone();
        }
        if (backingWaystone instanceof Waystone && this.field_145850_b != null) {
            ((Waystone)backingWaystone).setDimension((RegistryKey<World>)this.field_145850_b.func_234923_W_());
            ((Waystone)backingWaystone).setPos(this.field_174879_c);
        }
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        IWaystone syncedWaystone = Waystone.read(tag);
        WaystoneManager.get().updateWaystone(syncedWaystone);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
        IWaystone syncedWaystone = Waystone.read(pkt.func_148857_g());
        WaystoneManager.get().updateWaystone(syncedWaystone);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tagCompound = new CompoundNBT();
        Waystone.write(this.getWaystone(), tagCompound);
        return this.func_189515_b(tagCompound);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 2), (double)(this.field_174879_c.func_177952_p() + 1));
    }

    public IWaystone getWaystone() {
        BlockState state;
        if (!this.waystone.isValid() && this.field_145850_b != null && !this.field_145850_b.field_72995_K && !this.shouldNotInitialize && (state = this.func_195044_w()).func_177230_c() instanceof WaystoneBlock) {
            TileEntity tileEntity;
            DoubleBlockHalf half = (DoubleBlockHalf)state.func_177229_b((Property)WaystoneBlock.HALF);
            if (half == DoubleBlockHalf.LOWER) {
                this.initializeWaystone((IServerWorld)Objects.requireNonNull(this.field_145850_b), null, true);
            } else if (half == DoubleBlockHalf.UPPER && (tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b())) instanceof WaystoneTileEntityBase) {
                this.initializeFromBase((WaystoneTileEntityBase)tileEntity);
            }
        }
        return this.waystone;
    }

    public void initializeWaystone(IServerWorld world, @Nullable LivingEntity player, boolean wasGenerated) {
        Waystone waystone = new Waystone(this.getWaystoneType(), UUID.randomUUID(), (RegistryKey<World>)world.func_201672_e().func_234923_W_(), this.field_174879_c, wasGenerated, player != null ? player.func_110124_au() : null);
        WaystoneManager.get().addWaystone(waystone);
        this.waystone = waystone;
    }

    protected abstract ResourceLocation getWaystoneType();

    public void initializeFromExisting(IServerWorld world, Waystone existingWaystone, ItemStack itemStack) {
        this.waystone = existingWaystone;
        existingWaystone.setDimension((RegistryKey<World>)world.func_201672_e().func_234923_W_());
        existingWaystone.setPos(this.field_174879_c);
    }

    public void initializeFromBase(WaystoneTileEntityBase tileEntity) {
        this.waystone = tileEntity.getWaystone();
    }

    public void uninitializeWaystone() {
        if (this.waystone.isValid()) {
            WaystoneManager.get().removeWaystone(this.waystone);
            PlayerWaystoneManager.removeKnownWaystone(this.waystone);
        }
        this.waystone = InvalidWaystone.INSTANCE;
        this.shouldNotInitialize = true;
        DoubleBlockHalf half = (DoubleBlockHalf)this.func_195044_w().func_177229_b((Property)WaystoneBlock.HALF);
        BlockPos otherPos = half == DoubleBlockHalf.UPPER ? this.field_174879_c.func_177977_b() : this.field_174879_c.func_177984_a();
        TileEntity tileEntity = Objects.requireNonNull(this.field_145850_b).func_175625_s(otherPos);
        if (tileEntity instanceof WaystoneTileEntityBase) {
            WaystoneTileEntityBase waystoneTile = (WaystoneTileEntityBase)tileEntity;
            waystoneTile.waystone = InvalidWaystone.INSTANCE;
            waystoneTile.shouldNotInitialize = true;
        }
    }

    public void setSilkTouched(boolean silkTouched) {
        this.silkTouched = silkTouched;
    }

    public boolean isSilkTouched() {
        return this.silkTouched;
    }

    public abstract INamedContainerProvider getWaystoneSelectionContainerProvider();

    @Nullable
    public abstract INamedContainerProvider getWaystoneSettingsContainerProvider();
}

