/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import java.util.Vector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.util.FoodStats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.Difficulty;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import squeek.appleskin.ModConfig;
import squeek.appleskin.ModInfo;
import squeek.appleskin.api.event.FoodValuesEvent;
import squeek.appleskin.api.event.HUDOverlayEvent;
import squeek.appleskin.api.food.FoodValues;
import squeek.appleskin.helpers.FoodHelper;
import squeek.appleskin.helpers.HungerHelper;
import squeek.appleskin.util.IntPoint;

@OnlyIn(value=Dist.CLIENT)
public class HUDOverlayHandler {
    private float unclampedFlashAlpha = 0.0f;
    private float flashAlpha = 0.0f;
    private byte alphaDir = 1;
    protected int foodIconsOffset;
    public final Vector<IntPoint> healthBarOffsets = new Vector();
    public final Vector<IntPoint> foodBarOffsets = new Vector();
    private final Random random = new Random();
    private static final ResourceLocation modIcons = new ResourceLocation(ModInfo.MODID_LOWER, "textures/icons.png");

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new HUDOverlayHandler());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPreRender(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.FOOD) {
            return;
        }
        this.foodIconsOffset = ForgeIngameGui.right_height;
        if (event.isCanceled()) {
            return;
        }
        if (!((Boolean)ModConfig.SHOW_FOOD_EXHAUSTION_UNDERLAY.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        assert (player != null);
        int right = mc.func_228018_at_().func_198107_o() / 2 + 91;
        int top = mc.func_228018_at_().func_198087_p() - this.foodIconsOffset;
        float exhaustion = HungerHelper.getExhaustion((PlayerEntity)player);
        HUDOverlayEvent.Exhaustion renderEvent = new HUDOverlayEvent.Exhaustion(exhaustion, right, top, event.getMatrixStack());
        MinecraftForge.EVENT_BUS.post((Event)renderEvent);
        if (!renderEvent.isCanceled()) {
            this.drawExhaustionOverlay(renderEvent, mc, 1.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onRender(RenderGameOverlayEvent.Post event) {
        boolean shouldRenderHeldItemValues;
        if (event.getType() != RenderGameOverlayEvent.ElementType.FOOD && event.getType() != RenderGameOverlayEvent.ElementType.HEALTH) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        if (!this.shouldRenderAnyOverlays()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        assert (player != null);
        FoodStats stats = player.func_71024_bL();
        MatrixStack matrixStack = event.getMatrixStack();
        int top = mc.func_228018_at_().func_198087_p() - this.foodIconsOffset;
        int left = mc.func_228018_at_().func_198107_o() / 2 - 91;
        int right = mc.func_228018_at_().func_198107_o() / 2 + 91;
        if (event.getType() == RenderGameOverlayEvent.ElementType.HEALTH) {
            this.generateHealthBarOffsets(top, left, right, mc.field_71456_v.func_73834_c(), (PlayerEntity)player);
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.FOOD) {
            this.generateHungerBarOffsets(top, left, right, mc.field_71456_v.func_73834_c(), (PlayerEntity)player);
        }
        HUDOverlayEvent.Saturation saturationRenderEvent = null;
        if (event.getType() == RenderGameOverlayEvent.ElementType.FOOD) {
            saturationRenderEvent = new HUDOverlayEvent.Saturation(stats.func_75115_e(), right, top, matrixStack);
            if (!((Boolean)ModConfig.SHOW_SATURATION_OVERLAY.get()).booleanValue()) {
                saturationRenderEvent.setCanceled(true);
            }
            if (!saturationRenderEvent.isCanceled()) {
                MinecraftForge.EVENT_BUS.post((Event)saturationRenderEvent);
            }
            if (!saturationRenderEvent.isCanceled()) {
                this.drawSaturationOverlay(saturationRenderEvent, mc, 0.0f, 1.0f);
            }
        }
        ItemStack heldItem = player.func_184614_ca();
        if (((Boolean)ModConfig.SHOW_FOOD_VALUES_OVERLAY_WHEN_OFFHAND.get()).booleanValue() && !FoodHelper.canConsume(heldItem, (PlayerEntity)player)) {
            heldItem = player.func_184592_cb();
        }
        boolean bl = shouldRenderHeldItemValues = !heldItem.func_190926_b() && FoodHelper.canConsume(heldItem, (PlayerEntity)player);
        if (!shouldRenderHeldItemValues) {
            this.resetFlash();
            return;
        }
        FoodValues modifiedFoodValues = FoodHelper.getModifiedFoodValues(heldItem, (PlayerEntity)player);
        FoodValuesEvent foodValuesEvent = new FoodValuesEvent((PlayerEntity)player, heldItem, FoodHelper.getDefaultFoodValues(heldItem), modifiedFoodValues);
        MinecraftForge.EVENT_BUS.post((Event)foodValuesEvent);
        modifiedFoodValues = foodValuesEvent.modifiedFoodValues;
        if (event.getType() == RenderGameOverlayEvent.ElementType.HEALTH) {
            if (this.healthBarOffsets.size() == 0) {
                return;
            }
            if (!this.shouldShowEstimatedHealth(heldItem, modifiedFoodValues)) {
                return;
            }
            float foodHealthIncrement = FoodHelper.getEstimatedHealthIncrement(heldItem, modifiedFoodValues, (PlayerEntity)player);
            float currentHealth = player.func_110143_aJ();
            float modifiedHealth = Math.min(currentHealth + foodHealthIncrement, player.func_110138_aP());
            HUDOverlayEvent.HealthRestored healthRenderEvent = null;
            if (currentHealth < modifiedHealth) {
                healthRenderEvent = new HUDOverlayEvent.HealthRestored(modifiedHealth, heldItem, modifiedFoodValues, left, top, matrixStack);
            }
            if (healthRenderEvent != null) {
                MinecraftForge.EVENT_BUS.post(healthRenderEvent);
            }
            if (healthRenderEvent != null && !healthRenderEvent.isCanceled()) {
                this.drawHealthOverlay(healthRenderEvent, mc, this.flashAlpha);
            }
        } else if (event.getType() == RenderGameOverlayEvent.ElementType.FOOD) {
            if (!((Boolean)ModConfig.SHOW_FOOD_VALUES_OVERLAY.get()).booleanValue()) {
                return;
            }
            HUDOverlayEvent.HungerRestored renderRenderEvent = new HUDOverlayEvent.HungerRestored(stats.func_75116_a(), heldItem, modifiedFoodValues, right, top, matrixStack);
            MinecraftForge.EVENT_BUS.post((Event)renderRenderEvent);
            if (renderRenderEvent.isCanceled()) {
                return;
            }
            int foodHunger = modifiedFoodValues.hunger;
            float foodSaturationIncrement = modifiedFoodValues.getSaturationIncrement();
            this.drawHungerOverlay(renderRenderEvent, mc, foodHunger, this.flashAlpha, FoodHelper.isRotten(heldItem));
            assert (saturationRenderEvent != null);
            if (!saturationRenderEvent.isCanceled()) {
                int newFoodValue = stats.func_75116_a() + foodHunger;
                float newSaturationValue = stats.func_75115_e() + foodSaturationIncrement;
                float saturationGained = newSaturationValue > (float)newFoodValue ? (float)newFoodValue - stats.func_75115_e() : foodSaturationIncrement;
                this.drawSaturationOverlay(saturationRenderEvent, mc, saturationGained, this.flashAlpha);
            }
        }
    }

    public void drawSaturationOverlay(float saturationGained, float saturationLevel, Minecraft mc, MatrixStack matrixStack, int right, int top, float alpha) {
        if (saturationLevel + saturationGained < 0.0f) {
            return;
        }
        HUDOverlayHandler.enableAlpha(alpha);
        mc.func_110434_K().func_110577_a(modIcons);
        float modifiedSaturation = Math.max(0.0f, Math.min(saturationLevel + saturationGained, 20.0f));
        int startSaturationBar = 0;
        int endSaturationBar = (int)Math.ceil(modifiedSaturation / 2.0f);
        if (saturationGained != 0.0f) {
            startSaturationBar = (int)Math.max(saturationLevel / 2.0f, 0.0f);
        }
        int iconSize = 9;
        for (int i = startSaturationBar; i < endSaturationBar; ++i) {
            IntPoint offset = this.foodBarOffsets.get(i);
            if (offset == null) continue;
            int x = right + offset.x;
            int y = top + offset.y;
            int v = 0;
            int u = 0;
            float effectiveSaturationOfBar = modifiedSaturation / 2.0f - (float)i;
            if (effectiveSaturationOfBar >= 1.0f) {
                u = 3 * iconSize;
            } else if ((double)effectiveSaturationOfBar > 0.5) {
                u = 2 * iconSize;
            } else if ((double)effectiveSaturationOfBar > 0.25) {
                u = 1 * iconSize;
            }
            mc.field_71456_v.func_238474_b_(matrixStack, x, y, u, v, iconSize, iconSize);
        }
        mc.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
        HUDOverlayHandler.disableAlpha(alpha);
    }

    public void drawHungerOverlay(int hungerRestored, int foodLevel, Minecraft mc, MatrixStack matrixStack, int right, int top, float alpha, boolean useRottenTextures) {
        if (hungerRestored <= 0) {
            return;
        }
        HUDOverlayHandler.enableAlpha(alpha);
        mc.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
        int modifiedFood = Math.max(0, Math.min(20, foodLevel + hungerRestored));
        int startFoodBars = Math.max(0, foodLevel / 2);
        int endFoodBars = (int)Math.ceil((float)modifiedFood / 2.0f);
        int iconStartOffset = 16;
        int iconSize = 9;
        for (int i = startFoodBars; i < endFoodBars; ++i) {
            IntPoint offset = this.foodBarOffsets.get(i);
            if (offset == null) continue;
            int x = right + offset.x;
            int y = top + offset.y;
            int v = 3 * iconSize;
            int u = iconStartOffset + 4 * iconSize;
            int ub = iconStartOffset + 1 * iconSize;
            if (useRottenTextures) {
                u += 4 * iconSize;
                ub += 12 * iconSize;
            }
            if (i * 2 + 1 == modifiedFood) {
                u += 1 * iconSize;
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(alpha * 0.25f));
            mc.field_71456_v.func_238474_b_(matrixStack, x, y, ub, v, iconSize, iconSize);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            mc.field_71456_v.func_238474_b_(matrixStack, x, y, u, v, iconSize, iconSize);
        }
        HUDOverlayHandler.disableAlpha(alpha);
    }

    public void drawHealthOverlay(float health, float modifiedHealth, Minecraft mc, MatrixStack matrixStack, int right, int top, float alpha) {
        if (modifiedHealth <= health) {
            return;
        }
        HUDOverlayHandler.enableAlpha(alpha);
        mc.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
        int fixedModifiedHealth = (int)Math.ceil(modifiedHealth);
        boolean isHardcore = mc.field_71439_g.field_70170_p != null && mc.field_71439_g.field_70170_p.func_72912_H().func_76093_s();
        int startHealthBars = (int)Math.max(0.0, Math.ceil(health) / 2.0);
        int endHealthBars = (int)Math.max(0.0, Math.ceil(modifiedHealth / 2.0f));
        int iconStartOffset = 16;
        int iconSize = 9;
        for (int i = startHealthBars; i < endHealthBars; ++i) {
            IntPoint offset = this.healthBarOffsets.get(i);
            if (offset == null) continue;
            int x = right + offset.x;
            int y = top + offset.y;
            int v = 0 * iconSize;
            int u = iconStartOffset + 4 * iconSize;
            int ub = iconStartOffset + 1 * iconSize;
            if (i * 2 + 1 == fixedModifiedHealth) {
                u += 1 * iconSize;
            }
            if (isHardcore) {
                v = 5 * iconSize;
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(alpha * 0.25f));
            mc.field_71456_v.func_238474_b_(matrixStack, x, y, ub, v, iconSize, iconSize);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            mc.field_71456_v.func_238474_b_(matrixStack, x, y, u, v, iconSize, iconSize);
        }
        HUDOverlayHandler.disableAlpha(alpha);
    }

    public void drawExhaustionOverlay(float exhaustion, Minecraft mc, MatrixStack matrixStack, int right, int top, float alpha) {
        mc.func_110434_K().func_110577_a(modIcons);
        float maxExhaustion = HungerHelper.getMaxExhaustion((PlayerEntity)mc.field_71439_g);
        float ratio = Math.min(1.0f, Math.max(0.0f, exhaustion / maxExhaustion));
        int width = (int)(ratio * 81.0f);
        int height = 9;
        HUDOverlayHandler.enableAlpha(0.75f);
        mc.field_71456_v.func_238474_b_(matrixStack, right - width, top, 81 - width, 18, width, height);
        HUDOverlayHandler.disableAlpha(0.75f);
        mc.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
    }

    public static void enableAlpha(float alpha) {
        RenderSystem.enableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.blendFunc((int)770, (int)771);
    }

    public static void disableAlpha(float alpha) {
        RenderSystem.disableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        this.unclampedFlashAlpha += (float)this.alphaDir * 0.125f;
        if (this.unclampedFlashAlpha >= 1.5f) {
            this.alphaDir = (byte)-1;
        } else if (this.unclampedFlashAlpha <= -0.5f) {
            this.alphaDir = 1;
        }
        this.flashAlpha = Math.max(0.0f, Math.min(1.0f, this.unclampedFlashAlpha)) * Math.max(0.0f, Math.min(1.0f, ((Double)ModConfig.MAX_HUD_OVERLAY_FLASH_ALPHA.get()).floatValue()));
    }

    public void resetFlash() {
        this.flashAlpha = 0.0f;
        this.unclampedFlashAlpha = 0.0f;
        this.alphaDir = 1;
    }

    private void drawSaturationOverlay(HUDOverlayEvent.Saturation event, Minecraft mc, float saturationGained, float alpha) {
        this.drawSaturationOverlay(saturationGained, event.saturationLevel, mc, event.matrixStack, event.x, event.y, alpha);
    }

    private void drawHungerOverlay(HUDOverlayEvent.HungerRestored event, Minecraft mc, int hunger, float alpha, boolean useRottenTextures) {
        this.drawHungerOverlay(hunger, event.currentFoodLevel, mc, event.matrixStack, event.x, event.y, alpha, useRottenTextures);
    }

    private void drawHealthOverlay(HUDOverlayEvent.HealthRestored event, Minecraft mc, float alpha) {
        this.drawHealthOverlay(mc.field_71439_g.func_110143_aJ(), event.modifiedHealth, mc, event.matrixStack, event.x, event.y, alpha);
    }

    private void drawExhaustionOverlay(HUDOverlayEvent.Exhaustion event, Minecraft mc, float alpha) {
        this.drawExhaustionOverlay(event.exhaustion, mc, event.matrixStack, event.x, event.y, alpha);
    }

    private boolean shouldRenderAnyOverlays() {
        return (Boolean)ModConfig.SHOW_FOOD_VALUES_OVERLAY.get() != false || (Boolean)ModConfig.SHOW_SATURATION_OVERLAY.get() != false || (Boolean)ModConfig.SHOW_FOOD_HEALTH_HUD_OVERLAY.get() != false;
    }

    private boolean shouldShowEstimatedHealth(ItemStack hoveredStack, FoodValues modifiedFoodValues) {
        if (!((Boolean)ModConfig.SHOW_FOOD_HEALTH_HUD_OVERLAY.get()).booleanValue()) {
            return false;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        FoodStats stats = player.func_71024_bL();
        if (player.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
            return false;
        }
        if (stats.func_75116_a() >= 18) {
            return false;
        }
        if (player.func_70644_a(Effects.field_76436_u)) {
            return false;
        }
        if (player.func_70644_a(Effects.field_82731_v)) {
            return false;
        }
        return !player.func_70644_a(Effects.field_76428_l);
    }

    private void generateHealthBarOffsets(int top, int left, int right, int ticks, PlayerEntity player) {
        this.random.setSeed((long)ticks * 312871L);
        int preferHealthBars = 10;
        float maxHealth = player.func_110138_aP();
        float absorptionHealth = (float)Math.ceil(player.func_110139_bj());
        int healthBars = (int)Math.ceil((maxHealth + absorptionHealth) / 2.0f);
        if (healthBars < 0 || healthBars > 1000) {
            this.healthBarOffsets.setSize(0);
            return;
        }
        int healthRows = (int)Math.ceil((float)healthBars / 10.0f);
        int healthRowHeight = Math.max(10 - (healthRows - 2), 3);
        boolean shouldAnimatedHealth = false;
        if (((Boolean)ModConfig.SHOW_VANILLA_ANIMATION_OVERLAY.get()).booleanValue()) {
            boolean bl = shouldAnimatedHealth = Math.ceil(player.func_110143_aJ()) <= 4.0;
        }
        if (this.healthBarOffsets.size() != healthBars) {
            this.healthBarOffsets.setSize(healthBars);
        }
        for (int i = healthBars - 1; i >= 0; --i) {
            IntPoint point;
            int row = (int)Math.ceil((float)(i + 1) / 10.0f) - 1;
            int x = left + i % 10 * 8;
            int y = top - row * healthRowHeight;
            if (shouldAnimatedHealth) {
                y += this.random.nextInt(2);
            }
            if ((point = this.healthBarOffsets.get(i)) == null) {
                point = new IntPoint();
                this.healthBarOffsets.set(i, point);
            }
            point.x = x - left;
            point.y = y - top;
        }
    }

    private void generateHungerBarOffsets(int top, int left, int right, int ticks, PlayerEntity player) {
        int preferFoodBars = 10;
        boolean shouldAnimatedFood = false;
        if (((Boolean)ModConfig.SHOW_VANILLA_ANIMATION_OVERLAY.get()).booleanValue()) {
            FoodStats stats = player.func_71024_bL();
            float saturationLevel = stats.func_75115_e();
            int foodLevel = stats.func_75116_a();
            boolean bl = shouldAnimatedFood = saturationLevel <= 0.0f && ticks % (foodLevel * 3 + 1) == 0;
        }
        if (this.foodBarOffsets.size() != 10) {
            this.foodBarOffsets.setSize(10);
        }
        for (int i = 0; i < 10; ++i) {
            IntPoint point;
            int x = right - i * 8 - 9;
            int y = top;
            if (shouldAnimatedFood) {
                y += this.random.nextInt(3) - 1;
            }
            if ((point = this.foodBarOffsets.get(i)) == null) {
                point = new IntPoint();
                this.foodBarOffsets.set(i, point);
            }
            point.x = x - right;
            point.y = y - top;
        }
    }
}

