/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import squeek.appleskin.ModConfig;
import squeek.appleskin.ModInfo;
import squeek.appleskin.api.event.FoodValuesEvent;
import squeek.appleskin.api.event.TooltipOverlayEvent;
import squeek.appleskin.api.food.FoodValues;
import squeek.appleskin.helpers.FoodHelper;
import squeek.appleskin.helpers.KeyHelper;

@OnlyIn(value=Dist.CLIENT)
public class TooltipOverlayHandler {
    private static ResourceLocation modIcons = new ResourceLocation(ModInfo.MODID_LOWER, "textures/icons.png");
    public static final int TOOLTIP_REAL_HEIGHT_OFFSET_BOTTOM = 3;
    public static final int TOOLTIP_REAL_HEIGHT_OFFSET_TOP = -3;
    public static final int TOOLTIP_REAL_WIDTH_OFFSET_RIGHT = 3;
    private static final TextureOffsets normalBarTextureOffsets = new TextureOffsets();
    private static final TextureOffsets rottenBarTextureOffsets;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new TooltipOverlayHandler());
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        if (event.isCanceled()) {
            return;
        }
        ItemStack hoveredStack = event.getItemStack();
        if (!this.shouldShowTooltip(hoveredStack)) {
            return;
        }
        List tooltip = event.getToolTip();
        if (tooltip == null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        FoodValues defaultFood = FoodHelper.getDefaultFoodValues(hoveredStack);
        FoodValues modifiedFood = FoodHelper.getModifiedFoodValues(hoveredStack, (PlayerEntity)mc.field_71439_g);
        FoodValuesEvent foodValuesEvent = new FoodValuesEvent((PlayerEntity)mc.field_71439_g, hoveredStack, defaultFood, modifiedFood);
        MinecraftForge.EVENT_BUS.post((Event)foodValuesEvent);
        defaultFood = foodValuesEvent.defaultFoodValues;
        modifiedFood = foodValuesEvent.modifiedFoodValues;
        TooltipOverlayEvent.Pre prerenderEvent = new TooltipOverlayEvent.Pre(hoveredStack, defaultFood, modifiedFood);
        MinecraftForge.EVENT_BUS.post((Event)prerenderEvent);
        if (prerenderEvent.isCanceled()) {
            return;
        }
        FoodOverlay foodOverlay = new FoodOverlay(prerenderEvent.itemStack, defaultFood, modifiedFood, (PlayerEntity)mc.field_71439_g);
        if (foodOverlay.shouldRenderHungerBars()) {
            Style style = Style.field_240709_b_.func_240719_a_((ResourceLocation)new FoodOverlayFont(foodOverlay));
            StringTextComponent placeholder = new StringTextComponent(foodOverlay.getTooltip());
            tooltip.add(placeholder.func_230530_a_(style));
            tooltip.add(placeholder.func_230530_a_(style));
        }
    }

    @SubscribeEvent
    public void onRenderTooltip(RenderTooltipEvent.PostText event) {
        if (event.isCanceled()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        Screen gui = mc.field_71462_r;
        if (gui == null) {
            return;
        }
        int toolTipY = event.getY();
        int toolTipX = event.getX();
        int toolTipZ = 400;
        FoodOverlay foodOverlay = null;
        List lines = event.getLines();
        for (int i = 0; i < lines.size(); ++i) {
            foodOverlay = FoodOverlayFont.getFoodOverlay((ITextProperties)lines.get(i));
            if (foodOverlay == null) continue;
            toolTipY += i * 10;
            break;
        }
        if (foodOverlay == null) {
            return;
        }
        MatrixStack matrixStack = event.getMatrixStack();
        ItemStack itemStack = foodOverlay.itemStack;
        FoodValues defaultFood = foodOverlay.defaultFood;
        FoodValues modifiedFood = foodOverlay.modifiedFood;
        TooltipOverlayEvent.Render renderEvent = new TooltipOverlayEvent.Render(itemStack, toolTipX, toolTipY, matrixStack, defaultFood, modifiedFood);
        MinecraftForge.EVENT_BUS.post((Event)renderEvent);
        if (renderEvent.isCanceled()) {
            return;
        }
        toolTipX = renderEvent.x;
        toolTipY = renderEvent.y;
        matrixStack = renderEvent.matrixStack;
        RenderSystem.disableLighting();
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, (double)toolTipZ);
        int x = toolTipX;
        int y = toolTipY + 2;
        int defaultHunger = defaultFood.hunger;
        int modifiedHunger = modifiedFood.hunger;
        x += (foodOverlay.hungerBars - 1) * 9;
        mc.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
        TextureOffsets offsets = FoodHelper.isRotten(itemStack) ? rottenBarTextureOffsets : normalBarTextureOffsets;
        for (int i = 0; i < foodOverlay.hungerBars * 2; i += 2) {
            if (modifiedHunger < 0) {
                gui.func_238474_b_(matrixStack, x, y, offsets.containerNegativeHunger, 27, 9, 9);
            } else if (modifiedHunger > defaultHunger && defaultHunger <= i) {
                gui.func_238474_b_(matrixStack, x, y, offsets.containerExtraHunger, 27, 9, 9);
            } else if (modifiedHunger > i + 1 || defaultHunger == modifiedHunger) {
                gui.func_238474_b_(matrixStack, x, y, offsets.containerNormalHunger, 27, 9, 9);
            } else if (modifiedHunger == i + 1) {
                gui.func_238474_b_(matrixStack, x, y, offsets.containerPartialHunger, 27, 9, 9);
            } else {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                gui.func_238474_b_(matrixStack, x, y, offsets.containerMissingHunger, 27, 9, 9);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
            gui.func_238474_b_(matrixStack, x, y, defaultHunger - 1 == i ? offsets.shankMissingPartial : offsets.shankMissingFull, 27, 9, 9);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (modifiedHunger > i) {
                gui.func_238474_b_(matrixStack, x, y, modifiedHunger - 1 == i ? offsets.shankPartial : offsets.shankFull, 27, 9, 9);
            }
            x -= 9;
        }
        if (foodOverlay.hungerBarsText != null) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)(x += 18), (double)y, 0.0);
            matrixStack.func_227862_a_(0.75f, 0.75f, 0.75f);
            mc.field_71466_p.func_238406_a_(matrixStack, foodOverlay.hungerBarsText, 2.0f, 2.0f, -5592406, false);
            matrixStack.func_227865_b_();
        }
        x = toolTipX;
        y += 10;
        float modifiedSaturationIncrement = modifiedFood.getSaturationIncrement();
        float absModifiedSaturationIncrement = Math.abs(modifiedSaturationIncrement);
        x += (foodOverlay.saturationBars - 1) * 7;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.func_110434_K().func_110577_a(modIcons);
        for (int i = 0; i < foodOverlay.saturationBars * 2; i += 2) {
            boolean shouldBeFaded;
            float effectiveSaturationOfBar = (absModifiedSaturationIncrement - (float)i) / 2.0f;
            boolean bl = shouldBeFaded = absModifiedSaturationIncrement <= (float)i;
            if (shouldBeFaded) {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            }
            gui.func_238474_b_(matrixStack, x, y, effectiveSaturationOfBar >= 1.0f ? 21 : ((double)effectiveSaturationOfBar > 0.5 ? 14 : ((double)effectiveSaturationOfBar > 0.25 ? 7 : (effectiveSaturationOfBar > 0.0f ? 0 : 28))), modifiedSaturationIncrement >= 0.0f ? 27 : 34, 7, 7);
            if (shouldBeFaded) {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            x -= 7;
        }
        if (foodOverlay.saturationBarsText != null) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)(x += 14), (double)y, 0.0);
            matrixStack.func_227862_a_(0.75f, 0.75f, 0.75f);
            mc.field_71466_p.func_238406_a_(matrixStack, foodOverlay.saturationBarsText, 2.0f, 1.0f, -5592406, false);
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
        RenderSystem.disableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableRescaleNormal();
        RenderHelper.func_74518_a();
        RenderSystem.disableLighting();
        RenderSystem.disableDepthTest();
    }

    private boolean shouldShowTooltip(ItemStack hoveredStack) {
        boolean shouldShowTooltip;
        if (hoveredStack.func_190926_b()) {
            return false;
        }
        boolean bl = shouldShowTooltip = (Boolean)ModConfig.SHOW_FOOD_VALUES_IN_TOOLTIP.get() != false && KeyHelper.isShiftKeyDown() || (Boolean)ModConfig.ALWAYS_SHOW_FOOD_VALUES_TOOLTIP.get() != false;
        if (!shouldShowTooltip) {
            return false;
        }
        return FoodHelper.isFood(hoveredStack);
    }

    static {
        TooltipOverlayHandler.normalBarTextureOffsets.containerNegativeHunger = 43;
        TooltipOverlayHandler.normalBarTextureOffsets.containerExtraHunger = 133;
        TooltipOverlayHandler.normalBarTextureOffsets.containerNormalHunger = 16;
        TooltipOverlayHandler.normalBarTextureOffsets.containerPartialHunger = 124;
        TooltipOverlayHandler.normalBarTextureOffsets.containerMissingHunger = 34;
        TooltipOverlayHandler.normalBarTextureOffsets.shankMissingFull = 70;
        TooltipOverlayHandler.normalBarTextureOffsets.shankMissingPartial = TooltipOverlayHandler.normalBarTextureOffsets.shankMissingFull + 9;
        TooltipOverlayHandler.normalBarTextureOffsets.shankFull = 52;
        TooltipOverlayHandler.normalBarTextureOffsets.shankPartial = TooltipOverlayHandler.normalBarTextureOffsets.shankFull + 9;
        rottenBarTextureOffsets = new TextureOffsets();
        TooltipOverlayHandler.rottenBarTextureOffsets.containerNegativeHunger = TooltipOverlayHandler.normalBarTextureOffsets.containerNegativeHunger;
        TooltipOverlayHandler.rottenBarTextureOffsets.containerExtraHunger = TooltipOverlayHandler.normalBarTextureOffsets.containerExtraHunger;
        TooltipOverlayHandler.rottenBarTextureOffsets.containerNormalHunger = TooltipOverlayHandler.normalBarTextureOffsets.containerNormalHunger;
        TooltipOverlayHandler.rottenBarTextureOffsets.containerPartialHunger = TooltipOverlayHandler.normalBarTextureOffsets.containerPartialHunger;
        TooltipOverlayHandler.rottenBarTextureOffsets.containerMissingHunger = TooltipOverlayHandler.normalBarTextureOffsets.containerMissingHunger;
        TooltipOverlayHandler.rottenBarTextureOffsets.shankMissingFull = 106;
        TooltipOverlayHandler.rottenBarTextureOffsets.shankMissingPartial = TooltipOverlayHandler.rottenBarTextureOffsets.shankMissingFull + 9;
        TooltipOverlayHandler.rottenBarTextureOffsets.shankFull = 88;
        TooltipOverlayHandler.rottenBarTextureOffsets.shankPartial = TooltipOverlayHandler.rottenBarTextureOffsets.shankFull + 9;
    }

    static class FoodOverlay {
        private FoodValues defaultFood;
        private FoodValues modifiedFood;
        private int biggestHunger;
        private float biggestSaturationIncrement;
        private int hungerBars;
        private String hungerBarsText;
        private int saturationBars;
        private String saturationBarsText;
        private String tooltip;
        private ItemStack itemStack;

        FoodOverlay(ItemStack itemStack, FoodValues defaultFood, FoodValues modifiedFood, PlayerEntity player) {
            this.itemStack = itemStack;
            this.defaultFood = defaultFood;
            this.modifiedFood = modifiedFood;
            this.biggestHunger = Math.max(defaultFood.hunger, modifiedFood.hunger);
            this.biggestSaturationIncrement = Math.max(defaultFood.getSaturationIncrement(), modifiedFood.getSaturationIncrement());
            this.hungerBars = (int)Math.ceil((float)Math.abs(this.biggestHunger) / 2.0f);
            if (this.hungerBars > 10) {
                this.hungerBarsText = "x" + (this.biggestHunger < 0 ? -1 : 1) * this.hungerBars;
                this.hungerBars = 1;
            }
            this.saturationBars = (int)Math.ceil(Math.abs(this.biggestSaturationIncrement) / 2.0f);
            if (this.saturationBars > 10 || this.saturationBars == 0) {
                this.saturationBarsText = "x" + (this.biggestSaturationIncrement < 0.0f ? -1 : 1) * this.saturationBars;
                this.saturationBars = 1;
            }
        }

        String getTooltip() {
            if (this.tooltip != null) {
                return this.tooltip;
            }
            float scale = 2.2f;
            float hungerBarsLength = (float)this.hungerBars * scale;
            if (this.hungerBarsText != null) {
                hungerBarsLength += (float)this.hungerBarsText.length();
            }
            float saturationBarsLength = (float)this.saturationBars * scale;
            if (this.saturationBarsText != null) {
                saturationBarsLength += (float)this.saturationBarsText.length();
            }
            int length = (int)Math.ceil(Math.max(hungerBarsLength, saturationBarsLength * 0.8f));
            StringBuilder s = new StringBuilder(" ");
            for (int i = 0; i < length; ++i) {
                s.append(" ");
            }
            this.tooltip = s.toString();
            return this.tooltip;
        }

        boolean shouldRenderHungerBars() {
            return this.hungerBars > 0;
        }
    }

    static class FoodOverlayFont
    extends ResourceLocation {
        private FoodOverlay foodOverlay;

        FoodOverlayFont(FoodOverlay foodOverlay) {
            super(Style.field_240708_a_.func_110624_b(), Style.field_240708_a_.func_110623_a());
            this.foodOverlay = foodOverlay;
        }

        static Object getFontId(ITextProperties line) {
            if (line instanceof ITextComponent) {
                return ((ITextComponent)line).func_150256_b().func_240729_k_();
            }
            final Object[] fontId = new Object[]{Style.field_240708_a_};
            line.func_230439_a_((ITextProperties.IStyledTextAcceptor)new ITextProperties.IStyledTextAcceptor<ITextProperties>(){

                public Optional<ITextProperties> accept(Style n, String s) {
                    fontId[0] = n.func_240729_k_();
                    return Optional.empty();
                }
            }, Style.field_240709_b_);
            return fontId[0];
        }

        static FoodOverlay getFoodOverlay(ITextProperties line) {
            Object fontId = FoodOverlayFont.getFontId(line);
            if (fontId instanceof FoodOverlayFont) {
                return ((FoodOverlayFont)((Object)fontId)).foodOverlay;
            }
            return null;
        }
    }

    static class TextureOffsets {
        int containerNegativeHunger;
        int containerExtraHunger;
        int containerNormalHunger;
        int containerPartialHunger;
        int containerMissingHunger;
        int shankMissingFull;
        int shankMissingPartial;
        int shankFull;
        int shankPartial;

        TextureOffsets() {
        }
    }
}

