/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.controls;

import com.ldtteam.blockout.Color;
import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.AbstractTextElement;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.controls.Tooltip;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;

public abstract class AbstractTextBuilder<P extends AbstractTextElement, R extends AbstractTextBuilder<P, R>> {
    private final Supplier<P> paneFactory;
    private int defaultColor = 0;
    private int color = 0;
    private boolean bold = false;
    private boolean italic = false;
    private boolean underlined = false;
    private boolean strikeThrough = false;
    private boolean obfuscated = false;
    private ClickEvent clickEvent = null;
    private String insertionEvent = null;
    private IFormattableTextComponent currentComponent;
    private final List<IFormattableTextComponent> text = new ArrayList<IFormattableTextComponent>();
    private int lastParagraphStart = 0;
    private R thiz = this;

    protected AbstractTextBuilder(Supplier<P> paneFactory, int defaultColor) {
        this.paneFactory = paneFactory;
        this.color = defaultColor;
        this.defaultColor = defaultColor;
    }

    public R appendNL(ITextComponent text) {
        return this.appendNL((IFormattableTextComponent)text);
    }

    public R appendNL(IFormattableTextComponent text) {
        this.newLine();
        this.append(text);
        return this.thiz;
    }

    public R append(ITextComponent text) {
        return this.append((IFormattableTextComponent)text);
    }

    public R append(IFormattableTextComponent text) {
        this.currentComponent = this.currentComponent == null ? text : this.currentComponent.func_230529_a_((ITextComponent)text);
        return this.thiz;
    }

    public R newLine() {
        if (this.currentComponent != null) {
            this.text.add(this.currentComponent);
            this.currentComponent = null;
        }
        return this.thiz;
    }

    public R emptyLines(int count) {
        this.newLine();
        for (int i = 0; i < count; ++i) {
            this.text.add((IFormattableTextComponent)StringTextComponent.field_240750_d_);
        }
        return this.thiz;
    }

    public R paragraphBreak() {
        return this.paragraphBreak(false);
    }

    public R paragraphBreak(boolean forceStyle) {
        this.newLine();
        Style style = new Style(Color.toVanilla(this.color), Boolean.valueOf(this.bold), Boolean.valueOf(this.italic), Boolean.valueOf(this.underlined), Boolean.valueOf(this.strikeThrough), Boolean.valueOf(this.obfuscated), this.clickEvent, null, this.insertionEvent, null);
        for (int i = this.lastParagraphStart; i < this.text.size(); ++i) {
            if (!forceStyle && !this.text.get(i).func_150256_b().equals((Object)Style.field_240709_b_)) continue;
            this.text.get(i).func_230530_a_(style);
        }
        this.lastParagraphStart = this.text.size();
        this.resetStyle();
        return this.thiz;
    }

    public R resetStyle() {
        this.color = this.defaultColor;
        this.bold = false;
        this.italic = false;
        this.underlined = false;
        this.strikeThrough = false;
        this.obfuscated = false;
        this.clickEvent = null;
        this.insertionEvent = null;
        return this.thiz;
    }

    public R style(Style style) {
        if (style == null) {
            return this.resetStyle();
        }
        this.color = style.func_240711_a_().func_240742_a_();
        this.bold = style.func_150223_b();
        this.italic = style.func_150242_c();
        this.underlined = style.func_150234_e();
        this.strikeThrough = style.func_150236_d();
        this.obfuscated = style.func_150233_f();
        this.clickEvent = style.func_150235_h();
        this.insertionEvent = style.func_179986_j();
        return this.thiz;
    }

    public R style(TextFormatting textFormatting) {
        if (textFormatting == null) {
            return this.resetStyle();
        }
        switch (textFormatting) {
            case BOLD: {
                return this.bold();
            }
            case ITALIC: {
                return this.italic();
            }
            case OBFUSCATED: {
                return this.obfuscated();
            }
            case RESET: {
                return this.resetStyle();
            }
            case STRIKETHROUGH: {
                return this.strikeThrough();
            }
            case UNDERLINE: {
                return this.underlined();
            }
        }
        if (!textFormatting.func_96302_c()) {
            throw new IllegalArgumentException("Unknown non-color textformatting.");
        }
        return this.color(textFormatting.func_211163_e());
    }

    public R colorVanillaCode(char code) {
        TextFormatting tf = TextFormatting.func_211165_a((char)code);
        return this.color(tf == null || tf.func_211163_e() == null ? this.defaultColor : tf.func_211163_e());
    }

    public R colorName(String name) {
        TextFormatting tf = TextFormatting.func_96300_b((String)name);
        return this.color(Color.getByName(name, tf.func_96302_c() ? tf.func_211163_e() : this.color));
    }

    public R colorParse(String colorIn) {
        return this.color(Color.parse(colorIn, this.color));
    }

    public R color(int color) {
        this.color = color;
        return this.thiz;
    }

    public R bold() {
        return this.bold(true);
    }

    public R bold(boolean bold) {
        this.bold = bold;
        return this.thiz;
    }

    public R italic() {
        return this.italic(true);
    }

    public R italic(boolean italic) {
        this.italic = italic;
        return this.thiz;
    }

    public R underlined() {
        return this.underlined(true);
    }

    public R underlined(boolean underlined) {
        this.underlined = underlined;
        return this.thiz;
    }

    public R strikeThrough() {
        return this.strikeThrough(true);
    }

    public R strikeThrough(boolean strikeThrough) {
        this.strikeThrough = strikeThrough;
        return this.thiz;
    }

    public R obfuscated() {
        return this.obfuscated(true);
    }

    public R obfuscated(boolean obfuscated) {
        this.obfuscated = obfuscated;
        return this.thiz;
    }

    public R clickEvent(ClickEvent clickEvent) {
        this.clickEvent = clickEvent;
        return this.thiz;
    }

    public R insertionEvent(String insertionEvent) {
        this.insertionEvent = insertionEvent;
        return this.thiz;
    }

    public P build() {
        this.paragraphBreak();
        AbstractTextElement pane = (AbstractTextElement)((Object)this.paneFactory.get());
        pane.setText(this.getText());
        return (P)((Object)pane);
    }

    public List<IFormattableTextComponent> getText() {
        return new ArrayList<IFormattableTextComponent>(this.text);
    }

    public static class TextBuilder
    extends AbstractTextBuilder<Text, TextBuilder> {
        public TextBuilder() {
            super(Text::new, 0xFFFFFF);
        }
    }

    public static class TooltipBuilder
    extends AbstractTextBuilder<Tooltip, TooltipBuilder> {
        private Pane hoverPane;

        public TooltipBuilder() {
            super(Tooltip::new, 0xFFFFFF);
        }

        public TooltipBuilder hoverPane(Pane hoverPane) {
            this.hoverPane = hoverPane;
            return this;
        }

        @Override
        public Tooltip build() {
            if (this.hoverPane == null) {
                throw new IllegalStateException("No hover pane specified.");
            }
            if (this.hoverPane.getWindow() == null) {
                throw new IllegalStateException("Hover pane does not have parent window specified.");
            }
            Tooltip tooltipPane = (Tooltip)((Object)super.build());
            this.hoverPane.setHoverPane(tooltipPane);
            return tooltipPane;
        }
    }
}

