/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.hooks;

import java.util.function.Supplier;

public class TriggerMechanism<T> {
    static final TriggerMechanism<?>[] TRIGGER_MECHANISMS = new TriggerMechanism[2];
    private static final TriggerMechanism<Double> DISTANCE_TRIGGER = new TriggerMechanism<Double>(Type.DISTANCE, "dist", () -> 16.0, 10, 0);
    private static final TriggerMechanism<?> RAY_TRACE_TRIGGER = new TriggerMechanism<Object>(Type.RAY_TRACE, "ray_trace", () -> null, 1, 1);
    private final Type type;
    private final String name;
    private final Supplier<T> config;
    private final int tickEveryXTicks;
    private int priority;

    private TriggerMechanism(Type type, String name, Supplier<T> config, int tickEveryXTicks, int priority) {
        this.type = type;
        this.name = name;
        this.config = config;
        this.tickEveryXTicks = tickEveryXTicks;
        this.priority = priority;
        TriggerMechanism.TRIGGER_MECHANISMS[((Type)type).id] = this;
    }

    public static TriggerMechanism<?> getRayTrace() {
        return RAY_TRACE_TRIGGER;
    }

    public static TriggerMechanism<Double> getDistance() {
        return DISTANCE_TRIGGER;
    }

    public static TriggerMechanism<Double> getDistance(double blocks) {
        return new TriggerMechanism<Double>(TriggerMechanism.DISTANCE_TRIGGER.type, TriggerMechanism.DISTANCE_TRIGGER.name, () -> blocks, TriggerMechanism.DISTANCE_TRIGGER.tickEveryXTicks, TriggerMechanism.DISTANCE_TRIGGER.priority);
    }

    public TriggerMechanism<T> priority(int priority) {
        this.priority = priority;
        return this;
    }

    public Type getType() {
        return this.type;
    }

    int getId() {
        return this.type.id;
    }

    String getName() {
        return this.name;
    }

    boolean canTick(long ticks) {
        return ticks % (long)this.tickEveryXTicks == 0L;
    }

    boolean isLowerPriority(TriggerMechanism<?> other) {
        return this.priority < other.priority;
    }

    public T getConfig() {
        return this.config.get();
    }

    public static enum Type {
        DISTANCE(0),
        RAY_TRACE(1);

        private final int id;

        private Type(int id) {
            this.id = id;
        }
    }
}

