/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structures.client;

import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structures.client.BlueprintRenderer;
import com.ldtteam.structurize.api.util.Log;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.ints.Int2LongArrayMap;
import it.unimi.dsi.fastutil.ints.Int2LongMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;

public final class BlueprintHandler {
    private static final BlueprintHandler ourInstance = new BlueprintHandler();
    private static final int CACHE_SIZE = 30;
    private static final long CACHE_EVICT_TIME = 45000L;
    private final Int2ObjectArrayMap<BlueprintRenderer> rendererCache = new Int2ObjectArrayMap(30);
    private final Int2LongArrayMap evictTimeCache = new Int2LongArrayMap(30);

    private BlueprintHandler() {
    }

    @Deprecated
    public static BlueprintHandler getInstance() {
        return ourInstance;
    }

    public void draw(Blueprint blueprint, BlockPos pos, MatrixStack stack, float partialTicks) {
        BlueprintRenderer renderer;
        if (blueprint == null) {
            Log.getLogger().warn("Trying to draw null blueprint!");
            return;
        }
        Minecraft.func_71410_x().func_213239_aq().func_76320_a("struct_render_cache");
        int blueprintHash = blueprint.hashCode();
        BlueprintRenderer rendererRef = (BlueprintRenderer)this.rendererCache.get(blueprintHash);
        BlueprintRenderer blueprintRenderer = renderer = rendererRef == null ? BlueprintRenderer.buildRendererForBlueprint(blueprint) : rendererRef;
        if (rendererRef == null) {
            this.rendererCache.put(blueprintHash, (Object)renderer);
        }
        renderer.updateBlueprint(blueprint);
        renderer.draw(pos, stack, partialTicks);
        this.evictTimeCache.put(blueprintHash, System.currentTimeMillis());
        Minecraft.func_71410_x().func_213239_aq().func_76319_b();
    }

    public void cleanCache() {
        long now = System.currentTimeMillis();
        ObjectIterator iter = this.evictTimeCache.int2LongEntrySet().iterator();
        while (iter.hasNext()) {
            Int2LongMap.Entry entry = (Int2LongMap.Entry)iter.next();
            if (entry.getLongValue() + 45000L >= now) continue;
            ((BlueprintRenderer)this.rendererCache.remove(entry.getIntKey())).close();
            iter.remove();
        }
    }

    public void clearCache() {
        this.evictTimeCache.clear();
        this.rendererCache.values().forEach(BlueprintRenderer::close);
        this.rendererCache.clear();
    }

    public void drawAtListOfPositions(Blueprint blueprint, List<BlockPos> points, MatrixStack stack, float partialTicks) {
        BlueprintRenderer renderer;
        if (points.isEmpty() || blueprint == null) {
            return;
        }
        Minecraft.func_71410_x().func_213239_aq().func_76320_a("struct_render_multi");
        int blueprintHash = blueprint.hashCode();
        BlueprintRenderer rendererRef = (BlueprintRenderer)this.rendererCache.get(blueprintHash);
        BlueprintRenderer blueprintRenderer = renderer = rendererRef == null ? BlueprintRenderer.buildRendererForBlueprint(blueprint) : rendererRef;
        if (rendererRef == null) {
            this.rendererCache.put(blueprintHash, (Object)renderer);
        }
        renderer.updateBlueprint(blueprint);
        for (BlockPos coord : points) {
            renderer.draw(coord, stack, partialTicks);
        }
        this.evictTimeCache.put(blueprintHash, System.currentTimeMillis());
        Minecraft.func_71410_x().func_213239_aq().func_76319_b();
    }
}

