/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structures.client;

import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structures.client.BlueprintBlockAccess;
import com.ldtteam.structures.helpers.Settings;
import com.ldtteam.structures.lib.BlueprintUtils;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.event.ClientEventSubscriber;
import com.ldtteam.structurize.optifine.OptifineCompat;
import com.ldtteam.structurize.util.BlockInfo;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.FluidRenderer;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.CompassItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlueprintRenderer
implements AutoCloseable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Supplier<Map<RenderType, VertexBuffer>> blockVertexBuffersFactory = () -> RenderType.func_228661_n_().stream().collect(Collectors.toMap(type -> type, type -> new VertexBuffer(DefaultVertexFormats.field_176600_a)));
    private final BlueprintBlockAccess blockAccess;
    private List<Entity> entities;
    private List<TileEntity> tileEntities;
    private Map<RenderType, VertexBuffer> vertexBuffers;

    public static BlueprintRenderer buildRendererForBlueprint(Blueprint blueprint) {
        BlueprintBlockAccess blockAccess = new BlueprintBlockAccess(blueprint);
        return new BlueprintRenderer(blockAccess);
    }

    private BlueprintRenderer(BlueprintBlockAccess blockAccess) {
        this.blockAccess = blockAccess;
        this.init();
    }

    public void updateBlueprint(Blueprint blueprint) {
        if (this.blockAccess.getBlueprint() != blueprint && this.blockAccess.getBlueprint().hashCode() == blueprint.hashCode()) {
            this.blockAccess.setBlueprint(blueprint);
            Settings.instance.scheduleRefresh();
        }
    }

    private void init() {
        this.clearVertexBuffers();
        this.entities = BlueprintUtils.instantiateEntities(this.blockAccess.getBlueprint(), this.blockAccess);
        this.tileEntities = BlueprintUtils.instantiateTileEntities(this.blockAccess.getBlueprint(), this.blockAccess);
        BlockRendererDispatcher blockRendererDispatcher = Minecraft.func_71410_x().func_175602_ab();
        Random random = new Random();
        MatrixStack matrixStack = new MatrixStack();
        List<BlockInfo> blocks = this.blockAccess.getBlueprint().getBlockInfoAsList();
        Map<RenderType, VertexBuffer> newVertexBuffers = blockVertexBuffersFactory.get();
        for (RenderType renderType : RenderType.func_228661_n_()) {
            BufferBuilder buffer = new BufferBuilder(renderType.func_228662_o_());
            buffer.func_181668_a(renderType.func_228664_q_(), renderType.func_228663_p_());
            for (BlockInfo blockInfo : blocks) {
                try {
                    BlockState state = blockInfo.getState();
                    if (state.func_177230_c() == ModBlocks.blockSubstitution.get() && Settings.instance.renderLightPlaceholders() || state.func_177230_c() == ModBlocks.blockTagSubstitution.get()) {
                        state = Blocks.field_150350_a.func_176223_P();
                    }
                    if (state.func_177230_c() == ModBlocks.blockFluidSubstitution.get()) {
                        state = Minecraft.func_71410_x().field_71441_e != null ? BlockUtils.getFluidForDimension((World)Minecraft.func_71410_x().field_71441_e) : Blocks.field_150355_j.func_176223_P();
                    }
                    BlockPos blockPos = blockInfo.getPos();
                    FluidState fluidState = state.func_204520_s();
                    matrixStack.func_227860_a_();
                    matrixStack.func_227861_a_((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p());
                    if (state.func_185901_i() != BlockRenderType.INVISIBLE && RenderTypeLookup.canRenderInLayer((BlockState)state, (RenderType)renderType)) {
                        blockRendererDispatcher.renderModel(state, blockPos, (IBlockDisplayReader)this.blockAccess, matrixStack, (IVertexBuilder)buffer, true, random, (IModelData)EmptyModelData.INSTANCE);
                    }
                    if (!fluidState.func_206888_e() && RenderTypeLookup.canRenderInLayer((FluidState)fluidState, (RenderType)renderType)) {
                        FluidRenderer.render((IBlockDisplayReader)this.blockAccess, blockPos, (IVertexBuilder)buffer, fluidState);
                    }
                    matrixStack.func_227865_b_();
                }
                catch (ReportedException e) {
                    LOGGER.error("Error while trying to render structure part: " + e.getMessage(), e.getCause());
                }
            }
            buffer.func_178977_d();
            OptifineCompat.getInstance().beforeBuilderUpload(buffer);
            newVertexBuffers.get(renderType).func_227875_a_(buffer);
        }
        this.vertexBuffers = newVertexBuffers;
    }

    public void draw(BlockPos pos, MatrixStack matrixStack, float partialTicks) {
        Minecraft.func_71410_x().func_213239_aq().func_76320_a("struct_render_init");
        if (Settings.instance.shouldRefresh()) {
            this.init();
        }
        Minecraft.func_71410_x().func_213239_aq().func_219895_b("struct_render_blocks");
        Minecraft mc = Minecraft.func_71410_x();
        Vector3d viewPosition = mc.field_71460_t.func_215316_n().func_216785_c();
        BlockPos primaryBlockOffset = this.blockAccess.getBlueprint().getPrimaryBlockOffset();
        int x = pos.func_177958_n() - primaryBlockOffset.func_177958_n();
        int y = pos.func_177956_o() - primaryBlockOffset.func_177956_o();
        int z = pos.func_177952_p() - primaryBlockOffset.func_177952_p();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)x - viewPosition.func_82615_a(), (double)y - viewPosition.func_82617_b(), (double)z - viewPosition.func_82616_c());
        Matrix4f rawPosMatrix = matrixStack.func_227866_c_().func_227870_a_();
        Minecraft.func_71410_x().func_213239_aq().func_219895_b("struct_render_blocks_finish");
        this.renderBlockLayer(RenderType.func_228639_c_(), rawPosMatrix);
        mc.func_209506_al().func_229356_a_(AtlasTexture.field_110575_b).setBlurMipmap(false, mc.field_71474_y.field_151442_I > 0);
        this.renderBlockLayer(RenderType.func_228641_d_(), rawPosMatrix);
        mc.func_209506_al().func_229356_a_(AtlasTexture.field_110575_b).restoreLastBlurMipmap();
        this.renderBlockLayer(RenderType.func_228643_e_(), rawPosMatrix);
        OptifineCompat.getInstance().endTerrainBeginEntities();
        Minecraft.func_71410_x().func_213239_aq().func_219895_b("struct_render_entities");
        IRenderTypeBuffer.Impl renderBufferSource = ClientEventSubscriber.renderBuffers.func_228487_b_();
        this.entities.forEach(entity -> {
            if (entity instanceof ItemFrameEntity && ((ItemFrameEntity)entity).func_82335_i().func_77973_b() instanceof CompassItem) {
                ItemFrameEntity copy = (ItemFrameEntity)EntityType.field_200766_F.func_200721_a((World)this.blockAccess);
                copy.func_180432_n(entity);
                copy.func_82334_a(ItemStack.field_190927_a);
                entity = copy;
            }
            OptifineCompat.getInstance().preRenderEntity((Entity)entity);
            Minecraft.func_71410_x().func_175598_ae().func_229084_a_(entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), MathHelper.func_219799_g((float)partialTicks, (float)entity.field_70126_B, (float)entity.field_70177_z), 0.0f, matrixStack, (IRenderTypeBuffer)renderBufferSource, 200);
        });
        Minecraft.func_71410_x().func_213239_aq().func_219895_b("struct_render_entities_finish");
        renderBufferSource.func_228462_a_(RenderType.func_228634_a_((ResourceLocation)AtlasTexture.field_110575_b));
        renderBufferSource.func_228462_a_(RenderType.func_228638_b_((ResourceLocation)AtlasTexture.field_110575_b));
        renderBufferSource.func_228462_a_(RenderType.func_228640_c_((ResourceLocation)AtlasTexture.field_110575_b));
        renderBufferSource.func_228462_a_(RenderType.func_228646_f_((ResourceLocation)AtlasTexture.field_110575_b));
        OptifineCompat.getInstance().endEntitiesBeginBlockEntities();
        Minecraft.func_71410_x().func_213239_aq().func_219895_b("struct_render_blockentities");
        ActiveRenderInfo oldActiveRenderInfo = TileEntityRendererDispatcher.field_147556_a.field_217666_g;
        World oldWorld = TileEntityRendererDispatcher.field_147556_a.field_147550_f;
        TileEntityRendererDispatcher.field_147556_a.field_217666_g = new ActiveRenderInfo();
        TileEntityRendererDispatcher.field_147556_a.field_217666_g.func_216774_a(viewPosition.func_178786_a((double)x, (double)y, (double)z));
        TileEntityRendererDispatcher.field_147556_a.field_147550_f = this.blockAccess;
        this.tileEntities.forEach(tileEntity -> {
            BlockPos tePos = tileEntity.func_174877_v();
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)tePos.func_177958_n(), (double)tePos.func_177956_o(), (double)tePos.func_177952_p());
            OptifineCompat.getInstance().preRenderBlockEntity((TileEntity)tileEntity);
            TileEntityRendererDispatcher.field_147556_a.func_228850_a_(tileEntity, partialTicks, matrixStack, (IRenderTypeBuffer)renderBufferSource);
            matrixStack.func_227865_b_();
        });
        TileEntityRendererDispatcher.field_147556_a.field_217666_g = oldActiveRenderInfo;
        TileEntityRendererDispatcher.field_147556_a.field_147550_f = oldWorld;
        Minecraft.func_71410_x().func_213239_aq().func_219895_b("struct_render_blockentities_finish");
        renderBufferSource.func_228462_a_(RenderType.func_228639_c_());
        renderBufferSource.func_228462_a_(Atlases.func_228782_g_());
        renderBufferSource.func_228462_a_(Atlases.func_228783_h_());
        renderBufferSource.func_228462_a_(Atlases.func_228778_c_());
        renderBufferSource.func_228462_a_(Atlases.func_228779_d_());
        renderBufferSource.func_228462_a_(Atlases.func_228780_e_());
        renderBufferSource.func_228462_a_(Atlases.func_228781_f_());
        if (OptifineCompat.getInstance().isOptifineEnabled()) {
            renderBufferSource.func_228462_a_(Atlases.func_228768_a_());
        }
        ClientEventSubscriber.renderBuffers.func_228490_d_().func_228471_a_();
        OptifineCompat.getInstance().endBlockEntitiesBeginDebug();
        renderBufferSource.func_228462_a_(Atlases.func_228785_j_());
        renderBufferSource.func_228462_a_(Atlases.func_228768_a_());
        renderBufferSource.func_228462_a_(Atlases.func_228776_b_());
        renderBufferSource.func_228462_a_(RenderType.func_239270_k_());
        renderBufferSource.func_228462_a_(RenderType.func_239271_l_());
        renderBufferSource.func_228462_a_(RenderType.func_228653_j_());
        renderBufferSource.func_228462_a_(RenderType.func_239273_n_());
        renderBufferSource.func_228462_a_(RenderType.func_243501_m());
        renderBufferSource.func_228462_a_(RenderType.func_228655_k_());
        renderBufferSource.func_228462_a_(RenderType.func_239274_p_());
        renderBufferSource.func_228462_a_(RenderType.func_228651_i_());
        ClientEventSubscriber.renderBuffers.func_228489_c_().func_228461_a_();
        renderBufferSource.func_228462_a_(RenderType.func_228659_m_());
        renderBufferSource.func_228461_a_();
        Minecraft.func_71410_x().func_213239_aq().func_219895_b("struct_render_blocks_finish2");
        OptifineCompat.getInstance().endDebugPreWaterBeginWater();
        this.renderBlockLayer(RenderType.func_228645_f_(), rawPosMatrix);
        OptifineCompat.getInstance().endWater();
        this.renderBlockLayer(RenderType.func_241715_r_(), rawPosMatrix);
        matrixStack.func_227865_b_();
        Minecraft.func_71410_x().func_213239_aq().func_76319_b();
    }

    private void clearVertexBuffers() {
        if (this.vertexBuffers != null) {
            this.vertexBuffers.values().forEach(buffer -> buffer.close());
            this.vertexBuffers = null;
        }
    }

    @Override
    public void close() {
        this.clearVertexBuffers();
    }

    private void renderBlockLayer(RenderType layerRenderType, Matrix4f rawPosMatrix) {
        VertexBuffer buffer = this.vertexBuffers.get(layerRenderType);
        layerRenderType.func_228547_a_();
        OptifineCompat.getInstance().preLayerDraw(layerRenderType);
        buffer.func_177359_a();
        DefaultVertexFormats.field_176600_a.func_227892_a_(0L);
        OptifineCompat.getInstance().setupArrayPointers();
        buffer.func_227874_a_(rawPosMatrix, layerRenderType.func_228664_q_());
        VertexBuffer.func_177361_b();
        RenderSystem.clearCurrentColor();
        DefaultVertexFormats.field_176600_a.func_227895_d_();
        OptifineCompat.getInstance().postLayerDraw(layerRenderType);
        layerRenderType.func_228549_b_();
    }
}

