/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structures.lib;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import org.jetbrains.annotations.NotNull;

public final class RenderUtil {
    public static final float QUARTER = 90.0f;
    public static final float HALF = 180.0f;

    private RenderUtil() {
        throw new IllegalArgumentException("Utility Class");
    }

    public static void applyRotationToYAxis(@NotNull Rotation rotation, MatrixStack stack) {
        float angle;
        switch (rotation) {
            case NONE: {
                angle = 0.0f;
                break;
            }
            case CLOCKWISE_90: {
                angle = -90.0f;
                break;
            }
            case CLOCKWISE_180: {
                angle = -180.0f;
                break;
            }
            case COUNTERCLOCKWISE_90: {
                angle = 90.0f;
                break;
            }
            default: {
                angle = 0.0f;
            }
        }
        stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(angle));
    }

    public static void applyMirror(@NotNull Mirror mirror, @NotNull BlockPos appliedPrimaryBlockOff, MatrixStack stack) {
        switch (mirror) {
            case NONE: {
                stack.func_227862_a_(1.0f, 1.0f, 1.0f);
                break;
            }
            case FRONT_BACK: {
                stack.func_227861_a_((double)(2 * appliedPrimaryBlockOff.func_177958_n() + 1), 0.0, 0.0);
                stack.func_227862_a_(-1.0f, 1.0f, 1.0f);
                break;
            }
            case LEFT_RIGHT: {
                stack.func_227861_a_(0.0, 0.0, (double)(2 * appliedPrimaryBlockOff.func_177952_p() + 1));
                stack.func_227862_a_(1.0f, 1.0f, -1.0f);
                break;
            }
        }
    }
}

