/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.api.generation;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.fml.RegistryObject;

public class ModLanguageProvider
extends LanguageProvider {
    private static ModLanguageProvider instance;
    private final String modId;

    public ModLanguageProvider(DataGenerator gen, String modid, String locale) {
        super(gen, modid, locale);
        this.modId = modid;
        instance = this;
    }

    protected void addTranslations() {
        this.add("AUTO-GENERATED TRANSLATION OBJECT", "Coder, leave those keys alone! *TOUCH THEM AT YOUR PERIL* (use the data generator)!");
    }

    public <B extends Block> void translate(List<B> blocks, Function<B, String> getLangValue) {
        for (Block block : blocks) {
            if (block.getRegistryName() == null || getLangValue.apply(block) == null) continue;
            this.add(block.func_149739_a(), getLangValue.apply(block));
        }
    }

    public <B extends Block> void autoTranslate(List<B> blocks) {
        for (Block block : blocks) {
            if (block.getRegistryName() == null) continue;
            this.add(block.func_149739_a(), ModLanguageProvider.format(block.getRegistryName().func_110623_a()));
        }
    }

    public static String format(String key) {
        ArrayList<String> name = new ArrayList<String>();
        for (String word : key.split("[_. /]")) {
            name.add(word.substring(0, 1).toUpperCase(Locale.US) + word.substring(1));
        }
        return String.join((CharSequence)" ", name);
    }

    public void add(RegistryObject<?> key) {
        this.add((IItemProvider)key.get());
    }

    public void add(IItemProvider key) {
        this.add(key.func_199767_j(), ModLanguageProvider.format(Objects.requireNonNull(key.func_199767_j().getRegistryName()).func_110623_a()));
    }

    public void add(ItemGroup key, String name) {
        this.add(key.func_242392_c().getString(), name);
    }

    public void add(KeyPrefix prefix, String key, String name) {
        this.add(String.join((CharSequence)".", prefix.name().toLowerCase(), this.modId, key), name);
    }

    public String func_200397_b() {
        return this.modId + " Language Writer";
    }

    public static ModLanguageProvider getInstance() {
        return instance;
    }

    public static enum KeyPrefix {
        CONFIG,
        COMMAND,
        CHAT,
        GUI;

    }
}

