/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.commands;

import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.commands.AbstractCommand;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashSet;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.command.CommandSource;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class UpdateSchematicsCommand
extends AbstractCommand {
    private static final String NAME = "updateschematics";

    protected static LiteralArgumentBuilder<CommandSource> build() {
        return (LiteralArgumentBuilder)UpdateSchematicsCommand.newLiteral(NAME).executes(s -> UpdateSchematicsCommand.onExecute((CommandContext<CommandSource>)s));
    }

    private static int onExecute(CommandContext<CommandSource> command) throws CommandSyntaxException {
        File updaterInput = new File(Structurize.proxy.getSchematicsFolder(), "/updater/input");
        File updaterOutput = new File(Structurize.proxy.getSchematicsFolder(), "/updater/output");
        updaterInput.mkdirs();
        for (File file : updaterInput.listFiles()) {
            UpdateSchematicsCommand.update(file, updaterInput, updaterOutput);
        }
        return 1;
    }

    private static void update(@NotNull File input, @NotNull File globalInputFolder, @NotNull File globalOutputFolder) {
        if (input.isDirectory()) {
            for (File file : input.listFiles()) {
                UpdateSchematicsCommand.update(file, globalInputFolder, globalOutputFolder);
            }
            return;
        }
        if (input.getPath().endsWith(".blueprint")) {
            return;
        }
        try {
            File output = new File(globalOutputFolder, input.toString().replaceAll("\\.nbt", ".blueprint").replace(globalInputFolder.toString(), ""));
            output.getParentFile().mkdirs();
            CompoundNBT blueprint = CompressedStreamTools.func_74796_a((InputStream)Files.newInputStream(input.toPath(), new OpenOption[0]));
            if (blueprint == null || blueprint.isEmpty()) {
                return;
            }
            ListNBT blocks = blueprint.func_150295_c("blocks", 10);
            ListNBT pallete = blueprint.func_150295_c("palette", 10);
            CompoundNBT bluePrintCompound = new CompoundNBT();
            ListNBT list = blueprint.func_150295_c("size", 3);
            int[] size = new int[]{list.func_186858_c(0), list.func_186858_c(1), list.func_186858_c(2)};
            bluePrintCompound.func_74777_a("size_x", (short)size[0]);
            bluePrintCompound.func_74777_a("size_y", (short)size[1]);
            bluePrintCompound.func_74777_a("size_z", (short)size[2]);
            boolean addStructureVoid = blocks.size() != size[0] * size[1] * size[2];
            short structureVoidID = 0;
            if (addStructureVoid) {
                structureVoidID = (short)pallete.size();
                pallete.add((Object)NBTUtil.func_190009_a((BlockState)Blocks.field_189881_dj.func_176223_P()));
            }
            HashSet<String> mods = new HashSet<String>();
            for (int i = 0; i < pallete.size(); ++i) {
                CompoundNBT blockState = pallete.func_150305_b(i);
                String modid = blockState.func_74779_i("Name").split(":")[0];
                mods.add(modid);
            }
            ListNBT requiredMods = new ListNBT();
            for (String str : mods) {
                requiredMods.add((Object)StringNBT.func_229705_a_((String)str));
            }
            bluePrintCompound.func_218657_a("palette", (INBT)pallete);
            bluePrintCompound.func_218657_a("required_mods", (INBT)requiredMods);
            BlockPos.Mutable pos = new BlockPos.Mutable();
            short[][][] dataArray = new short[size[1]][size[2]][size[0]];
            if (addStructureVoid) {
                for (int i = 0; i < size[1]; ++i) {
                    for (int j = 0; j < size[2]; ++j) {
                        for (int k = 0; k < size[0]; ++k) {
                            dataArray[i][j][k] = structureVoidID;
                        }
                    }
                }
            }
            ListNBT tileEntities = new ListNBT();
            for (int i = 0; i < blocks.size(); ++i) {
                CompoundNBT comp = blocks.func_150305_b(i);
                UpdateSchematicsCommand.updatePos(pos, comp);
                dataArray[pos.func_177956_o()][pos.func_177952_p()][pos.func_177958_n()] = (short)comp.func_74762_e("state");
                if (!comp.func_74764_b("nbt")) continue;
                CompoundNBT te = comp.func_74775_l("nbt");
                te.func_74777_a("x", (short)pos.func_177958_n());
                te.func_74777_a("y", (short)pos.func_177956_o());
                te.func_74777_a("z", (short)pos.func_177952_p());
                tileEntities.add((Object)te);
            }
            bluePrintCompound.func_74783_a("blocks", UpdateSchematicsCommand.convertBlocksToSaveData(dataArray, (short)size[0], (short)size[1], (short)size[2]));
            bluePrintCompound.func_218657_a("tile_entities", (INBT)tileEntities);
            bluePrintCompound.func_218657_a("architects", (INBT)new ListNBT());
            bluePrintCompound.func_218657_a("name", (INBT)StringNBT.func_229705_a_((String)input.getName().replaceAll("\\.nbt", "")));
            bluePrintCompound.func_74768_a("version", 1);
            ListNBT newEntities = new ListNBT();
            if (blueprint.func_74764_b("entities")) {
                ListNBT entities = blueprint.func_150295_c("entities", 10);
                for (int i = 0; i < entities.size(); ++i) {
                    CompoundNBT entityData = entities.func_150305_b(i);
                    CompoundNBT entity = entityData.func_74775_l("nbt");
                    entity.func_218657_a("Pos", entityData.func_74781_a("pos"));
                    newEntities.add((Object)entity);
                }
            }
            bluePrintCompound.func_218657_a("entities", (INBT)newEntities);
            output.createNewFile();
            CompressedStreamTools.func_74799_a((CompoundNBT)bluePrintCompound, (OutputStream)Files.newOutputStream(output.toPath(), new OpenOption[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void updatePos(BlockPos.Mutable pos, CompoundNBT comp) {
        ListNBT list = comp.func_150295_c("pos", 3);
        pos.func_181079_c(list.func_186858_c(0), list.func_186858_c(1), list.func_186858_c(2));
    }

    private static int[] convertBlocksToSaveData(short[][][] multDimArray, short sizeX, short sizeY, short sizeZ) {
        int currentInt;
        short[] oneDimArray = new short[sizeX * sizeY * sizeZ];
        int j = 0;
        for (short y = 0; y < sizeY; y = (short)(y + 1)) {
            for (short z = 0; z < sizeZ; z = (short)(z + 1)) {
                for (short x = 0; x < sizeX; x = (short)(x + 1)) {
                    oneDimArray[j++] = multDimArray[y][z][x];
                }
            }
        }
        int[] ints = new int[(int)Math.ceil((float)oneDimArray.length / 2.0f)];
        for (int i = 1; i < oneDimArray.length; i += 2) {
            currentInt = oneDimArray[i - 1];
            ints[(int)Math.ceil((double)((double)((float)i / 2.0f))) - 1] = currentInt = currentInt << 16 | oneDimArray[i];
        }
        if (oneDimArray.length % 2 == 1) {
            ints[ints.length - 1] = currentInt = oneDimArray[oneDimArray.length - 1] << 16;
        }
        return ints;
    }
}

