/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.event;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.commands.EntryPoint;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.management.Structures;
import com.ldtteam.structurize.network.messages.ServerUUIDMessage;
import com.ldtteam.structurize.network.messages.StructurizeStylesMessage;
import com.ldtteam.structurize.util.BackUpHelper;
import com.mojang.brigadier.CommandDispatcher;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public class EventSubscriber {
    private EventSubscriber() {
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        EntryPoint.register((CommandDispatcher<CommandSource>)event.getDispatcher(), event.getEnvironment());
    }

    @SubscribeEvent
    public static void onServerStarted(FMLServerStartedEvent event) {
        Structures.init();
        BackUpHelper.loadLinkSessionManager();
    }

    @SubscribeEvent
    public static void onServerStopping(FMLServerStoppingEvent event) {
        BackUpHelper.saveLinkSessionManager();
    }

    @SubscribeEvent
    public static void onPlayerLogin(@NotNull PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            Network.getNetwork().sendToPlayer(new ServerUUIDMessage(), (ServerPlayerEntity)event.getPlayer());
            Network.getNetwork().sendToPlayer(new StructurizeStylesMessage(), (ServerPlayerEntity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onWorldTick(@NotNull TickEvent.WorldTickEvent event) {
        if (event.world.field_72995_K) {
            return;
        }
        Manager.onWorldTick((ServerWorld)event.world);
    }

    @SubscribeEvent
    public static void onMissingBlockMappings(RegistryEvent.MissingMappings<Block> missingBlockEvent) {
        ImmutableList missingBlocks = missingBlockEvent.getMappings("structurize");
        if (missingBlocks.isEmpty()) {
            return;
        }
        EventSubscriber.handleMissingMappingsDueToRestructureIn9af7543d7dcefa0bf7b52c2e809d6c8d48b803a6(missingBlocks, ForgeRegistries.BLOCKS);
    }

    @SubscribeEvent
    public static void onMissingItemMappings(RegistryEvent.MissingMappings<Item> missingBlockEvent) {
        ImmutableList missingItems = missingBlockEvent.getMappings("structurize");
        if (missingItems.isEmpty()) {
            return;
        }
        EventSubscriber.handleMissingMappingsDueToRestructureIn9af7543d7dcefa0bf7b52c2e809d6c8d48b803a6(missingItems, ForgeRegistries.ITEMS);
    }

    private static <T extends IForgeRegistryEntry<T>> void handleMissingMappingsDueToRestructureIn9af7543d7dcefa0bf7b52c2e809d6c8d48b803a6(ImmutableList<RegistryEvent.MissingMappings.Mapping<T>> missingMappings, IForgeRegistry<T> registry) {
        ImmutableMap replacementPatterns = ImmutableMap.builder().put((Object)Pattern.compile("(\\S+)?stone_brick(\\S+)?"), (Object)Lists.newArrayList((Object[])new String[]{"stone_bricks"})).put((Object)Pattern.compile("(\\S+)?cobble_stone(\\S+)?"), (Object)Lists.newArrayList((Object[])new String[]{"cobblestone"})).put((Object)Pattern.compile("(\\S+)?blockbrownbrick(\\S+)?"), (Object)Lists.newArrayList((Object[])new String[]{"brown_brick", "brown_brick_", "_brown_brick", "_brown_brick_"})).put((Object)Pattern.compile("(\\S+)?blockbeigebrick(\\S+)?"), (Object)Lists.newArrayList((Object[])new String[]{"beige_brick", "beige_brick_", "_beige_brick", "_beige_brick_"})).put((Object)Pattern.compile("(\\S+)?blockcreambrick(\\S+)?"), (Object)Lists.newArrayList((Object[])new String[]{"cream_brick", "cream_brick_", "_cream_brick", "_cream_brick_"})).put((Object)Pattern.compile("(\\S+)?_brick_(\\S+)?"), (Object)Lists.newArrayList((Object[])new String[]{"_bricks_"})).build();
        missingMappings.forEach(arg_0 -> EventSubscriber.lambda$handleMissingMappingsDueToRestructureIn9af7543d7dcefa0bf7b52c2e809d6c8d48b803a6$0((Map)replacementPatterns, registry, arg_0));
    }

    private static /* synthetic */ void lambda$handleMissingMappingsDueToRestructureIn9af7543d7dcefa0bf7b52c2e809d6c8d48b803a6$0(Map replacementPatterns, IForgeRegistry registry, RegistryEvent.MissingMappings.Mapping mapping) {
        if (mapping.key.func_110623_a().equals("placeholderblock")) {
            mapping.ignore();
            return;
        }
        String namespace = mapping.key.func_110624_b();
        String path = mapping.key.func_110623_a();
        for (Map.Entry patternToReplace : replacementPatterns.entrySet()) {
            Matcher patternMatcher = ((Pattern)patternToReplace.getKey()).matcher(path);
            if (!patternMatcher.find()) continue;
            for (String replacementCandidate : (List)patternToReplace.getValue()) {
                String replacedPath = patternMatcher.replaceAll("$1" + replacementCandidate + "$2");
                ResourceLocation remappedObjectKey = new ResourceLocation(namespace, replacedPath);
                if (!registry.containsKey(remappedObjectKey)) continue;
                IForgeRegistryEntry remappedObject = registry.getValue(remappedObjectKey);
                mapping.remap(remappedObject);
                return;
            }
        }
    }
}

