/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.network.messages.IMessage;
import com.ldtteam.structurize.network.messages.SchematicSaveMessage;
import com.ldtteam.structurize.util.StructureLoadingUtils;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchematicRequestMessage
implements IMessage {
    private final String filename;

    public SchematicRequestMessage(PacketBuffer buf) {
        this.filename = buf.func_150789_c(Short.MAX_VALUE);
    }

    public SchematicRequestMessage(String filename) {
        this.filename = filename;
    }

    @Override
    public void toBytes(@NotNull PacketBuffer buf) {
        buf.func_180714_a(this.filename);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        byte[] schematic = StructureLoadingUtils.getByteArray(this.filename);
        if (schematic.length == 0) {
            Log.getLogger().error("SchematicRequestMessage: file \"" + this.filename + "\" not found");
        } else {
            Log.getLogger().info("Request: player " + ctxIn.getSender().func_200200_C_().getString() + " is requesting schematic " + this.filename);
            Network.getNetwork().sendToPlayer(new SchematicSaveMessage(schematic, UUID.randomUUID(), 1, 1), ctxIn.getSender());
        }
    }
}

