/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.placement;

import com.ldtteam.structurize.api.util.BlockPosUtil;
import com.ldtteam.structurize.placement.structure.IStructureHandler;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.BlueprintPositionInfo;
import java.util.Collections;
import java.util.function.Supplier;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.common.util.TriPredicate;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBlueprintIterator {
    public static final BlockPos NULL_POS = new BlockPos(-1, -1, -1);
    protected final BlockPos.Mutable progressPos = new BlockPos.Mutable(-1, -1, -1);
    protected final BlockPos size;
    private final IStructureHandler structureHandler;
    private boolean includeEntities;
    private boolean isRemoving;

    public AbstractBlueprintIterator(IStructureHandler structureHandler) {
        this(structureHandler, new BlockPos((int)structureHandler.getBluePrint().getSizeX(), (int)structureHandler.getBluePrint().getSizeY(), (int)structureHandler.getBluePrint().getSizeZ()));
    }

    public AbstractBlueprintIterator(IStructureHandler structureHandler, BlockPos size) {
        this.structureHandler = structureHandler;
        this.size = size;
    }

    public Result increment(TriPredicate<BlueprintPositionInfo, BlockPos, IStructureHandler> skipCondition) {
        return this.iterateWithCondition(skipCondition, this::increment);
    }

    public abstract Result increment();

    public abstract Result decrement();

    public Result decrement(TriPredicate<BlueprintPositionInfo, BlockPos, IStructureHandler> skipCondition) {
        return this.iterateWithCondition(skipCondition, this::decrement);
    }

    private Result iterateWithCondition(TriPredicate<BlueprintPositionInfo, BlockPos, IStructureHandler> skipCondition, Supplier<Result> function) {
        int count = 0;
        do {
            if (function.get() == Result.AT_END) {
                return Result.AT_END;
            }
            BlockPos worldPos = this.structureHandler.getProgressPosInWorld((BlockPos)this.progressPos);
            BlueprintPositionInfo info = this.getBluePrintPositionInfo((BlockPos)this.progressPos);
            if (skipCondition.test((Object)info, (Object)worldPos, (Object)this.structureHandler)) continue;
            if (!this.isRemoving) {
                if (BlockUtils.areBlockStatesEqual(info.getBlockInfo().getState(), this.structureHandler.getWorld().func_180495_p(worldPos), this.structureHandler::replaceWithSolidBlock, this.structureHandler.fancyPlacement(), this.structureHandler::shouldBlocksBeConsideredEqual) && info.getEntities().length == 0) {
                    this.structureHandler.triggerSuccess((BlockPos)this.progressPos, Collections.emptyList(), false);
                    continue;
                }
            }
            return Result.NEW_BLOCK;
        } while (count++ < this.structureHandler.getMaxBlocksCheckedPerCall());
        return Result.CONFIG_LIMIT;
    }

    public void setProgressPos(@NotNull BlockPos localPosition) {
        if (localPosition.equals((Object)NULL_POS)) {
            this.progressPos.func_189533_g((Vector3i)localPosition);
        } else {
            this.progressPos.func_181079_c(localPosition.func_177958_n() % this.size.func_177958_n(), localPosition.func_177956_o() % this.size.func_177956_o(), localPosition.func_177952_p() % this.size.func_177952_p());
        }
    }

    @NotNull
    public BlueprintPositionInfo getBluePrintPositionInfo(BlockPos localPos) {
        return this.structureHandler.getBluePrint().getBluePrintPositionInfo(localPos, this.includeEntities);
    }

    public void includeEntities() {
        this.includeEntities = true;
    }

    public void setRemoving() {
        this.isRemoving = true;
    }

    public void reset() {
        BlockPosUtil.set(this.progressPos, NULL_POS);
        this.includeEntities = false;
        this.isRemoving = false;
    }

    public BlockPos getProgressPos() {
        return new BlockPos((Vector3i)this.progressPos);
    }

    public static enum Result {
        NEW_BLOCK,
        AT_END,
        CONFIG_LIMIT;

    }
}

