/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.util.List;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.component.ScrollListPane;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.option.CategorySlot;
import journeymap.client.ui.option.SlotMetadata;
import net.minecraft.client.Minecraft;

public class DraggableListPane<T extends Slot>
extends ScrollListPane<T> {
    private boolean clicked = false;
    private Integer frameColor = new Color(-6250336).getRGB();
    private boolean dragging = false;
    private boolean didDrag = false;
    private int mouseDragOffsetX = 0;
    private int mouseDragOffsetY = 0;

    public DraggableListPane(JmUI parent, Minecraft mc, int width, int height, int x, int y) {
        super(parent, mc, width, height, 0, height, 20);
        this.field_230675_l_ = x;
        this.field_230674_k_ = x + width;
        this.field_230672_i_ = y;
        this.field_230673_j_ = y + height;
    }

    @Override
    public void func_230430_a_(MatrixStack poseStack, int pMouseX, int pMouseY, float pPartialTicks) {
        super.func_230430_a_(poseStack, pMouseX, pMouseY, pPartialTicks);
    }

    @Override
    public void setSlots(List<T> slots) {
        int newWidth = this.field_230670_d_;
        int newHeight = this.field_230671_e_;
        super.setSlots(slots);
        for (Slot slot : this.getRootSlots()) {
            if (!(slot instanceof CategorySlot)) continue;
            newHeight = ((CategorySlot)slot).getAllChildMetadata().size() * 25;
            for (SlotMetadata child : ((CategorySlot)slot).getAllChildMetadata()) {
                String name = child.getName();
                int sWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(name) * 2;
                newWidth = Math.max(sWidth, newWidth);
            }
        }
        this.func_230940_a_(newWidth, newHeight, this.field_230672_i_, this.field_230673_j_);
    }

    @Override
    public void func_230940_a_(int width, int height, int top, int bottom) {
        this.field_230670_d_ = width;
        this.field_230671_e_ = height;
        this.field_230672_i_ = top;
        this.field_230673_j_ = top + height;
        this.field_230674_k_ = this.field_230675_l_ + width;
        this.scrollbarX = this.field_230670_d_ - this.hpad + this.field_230675_l_;
        this.listWidth = this.field_230670_d_ - this.hpad * 4;
    }

    @Override
    protected void func_230433_a_(MatrixStack mStack) {
        if (this.clicked) {
            this.func_238468_a_(mStack, this.field_230675_l_, this.field_230672_i_, this.field_230674_k_, this.field_230673_j_, -1072689136, -804253680);
            float alpha = 1.0f;
            DrawUtil.drawRectangle(mStack, this.field_230675_l_ - 1, this.field_230672_i_ - 1, this.field_230670_d_ + 2, 1.0, this.frameColor, alpha);
            DrawUtil.drawRectangle(mStack, this.field_230675_l_ - 1, this.field_230672_i_ + this.field_230671_e_, this.field_230670_d_ + 2, 1.0, this.frameColor, alpha);
            DrawUtil.drawRectangle(mStack, this.field_230675_l_ - 1, this.field_230672_i_ - 1, 1.0, this.field_230671_e_ + 1, this.frameColor, alpha);
            DrawUtil.drawRectangle(mStack, this.field_230670_d_ + this.field_230675_l_, this.field_230672_i_ - 1, 1.0, this.field_230671_e_ + 2, this.frameColor, alpha);
        }
    }

    @Override
    public boolean func_231044_a_(double pMouseX, double pMouseY, int pButton) {
        boolean paneClicked = false;
        if (super.func_231047_b_(pMouseX, pMouseY) && !(this.func_230933_a_(pMouseX, pMouseY) instanceof CategorySlot)) {
            paneClicked = super.func_231044_a_(pMouseX, pMouseY, pButton);
        } else if (super.func_231047_b_(pMouseX, pMouseY) && this.func_230933_a_(pMouseX, pMouseY) instanceof CategorySlot) {
            this.mouseDragOffsetX = (int)(pMouseX - (double)this.field_230675_l_);
            this.mouseDragOffsetY = (int)(pMouseY - (double)this.field_230672_i_);
            this.dragging = true;
        }
        return paneClicked;
    }

    @Override
    public boolean func_231045_a_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.dragging) {
            this.didDrag = true;
            int posX = (int)(pMouseX - (double)this.mouseDragOffsetX);
            int posY = (int)(pMouseY - (double)this.mouseDragOffsetY);
            this.updatePosition(posX, posY);
        }
        return super.func_231045_a_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    @Override
    public boolean func_231048_c_(double mouseX, double mouseY, int mouseButton) {
        if (this.dragging && this.didDrag) {
            this.didDrag = false;
            this.dragging = false;
        } else if (super.func_231047_b_(mouseX, mouseY) && this.func_230933_a_(mouseX, mouseY) instanceof CategorySlot) {
            this.didDrag = false;
            this.dragging = false;
            super.func_231044_a_(mouseX, mouseY, mouseButton);
            CategorySlot slot = (CategorySlot)this.func_230933_a_(mouseX, mouseY);
            this.clicked = slot.isSelected();
        }
        return super.func_231048_c_(mouseX, mouseY, mouseButton);
    }

    public void updatePosition(int x, int y) {
        this.field_230672_i_ = y;
        this.field_230673_j_ = this.field_230672_i_ + this.field_230671_e_;
        this.field_230675_l_ = x;
        this.field_230674_k_ = this.field_230675_l_ + this.field_230670_d_;
        this.scrollbarX = this.field_230670_d_ - this.hpad + this.field_230675_l_;
        this.listWidth = this.field_230670_d_ - this.hpad * 4;
    }
}

