/*
 * Decompiled with CFR 0.152.
 */
package com.github.elrol.industrialagriculture.init;

import com.github.elrol.industrialagriculture.init.SoundInit;
import com.github.elrol.industrialagriculture.items.SeedBag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.MusicDiscItem;
import net.minecraft.item.Rarity;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemInit {
    private static final Logger logger = Logger.getLogger(ItemInit.class.getName());
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"industrialagriculture");
    public static final Map<String, RegistryObject<? extends Item>> itemMap = new HashMap<String, RegistryObject<? extends Item>>();
    public static final List<Item> items = new ArrayList<Item>();
    public static final RegistryObject<Item> BAG_TIER_ONE = ItemInit.registerItem("bag_tier_one", new SeedBag(1));
    public static final RegistryObject<Item> BAG_TIER_TWO = ItemInit.registerItem("bag_tier_two", new SeedBag(2));
    public static final RegistryObject<Item> BAG_TIER_THREE = ItemInit.registerItem("bag_tier_three", new SeedBag(3));
    public static final RegistryObject<Item> BAG_TIER_FOUR = ItemInit.registerItem("bag_tier_four", new SeedBag(4));
    public static final RegistryObject<Item> BAG_TIER_FIVE = ItemInit.registerItem("bag_tier_five", new SeedBag(5));
    public static final RegistryObject<Item> BAG_TIER_SIX = ItemInit.registerItem("bag_tier_six", new SeedBag(6));
    public static final RegistryObject<MusicDiscItem> LLAMA_DISC = ItemInit.registerItem("llama_disc", new MusicDiscItem(13, () -> SoundInit.llama, ItemInit.unstackable().func_208103_a(Rarity.RARE)));

    public static void init(RegistryEvent.Register<Item> event) {
        for (Item item : items) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
    }

    public static void registerItem(Item item) {
        items.add(item);
    }

    public static void registerItems(List<Item> newItems) {
        items.addAll(newItems);
    }

    public static <I extends Item> RegistryObject<I> registerItem(String id, I item) {
        logger.info(id + " item was registered");
        RegistryObject regObj = ITEMS.register(id, () -> item);
        itemMap.put(id, (RegistryObject<? extends Item>)regObj);
        return regObj;
    }

    private static Item.Properties unstackable() {
        return new Item.Properties().func_200916_a(ItemGroup.field_78026_f).func_200917_a(1);
    }

    public static Item getSeedBag(int tier) {
        switch (tier) {
            case 6: {
                return (Item)BAG_TIER_SIX.get();
            }
            case 5: {
                return (Item)BAG_TIER_FIVE.get();
            }
            case 4: {
                return (Item)BAG_TIER_FOUR.get();
            }
            case 3: {
                return (Item)BAG_TIER_THREE.get();
            }
            case 2: {
                return (Item)BAG_TIER_TWO.get();
            }
        }
        return (Item)BAG_TIER_ONE.get();
    }
}

