/*
 * Decompiled with CFR 0.152.
 */
package com.github.elrol.industrialagriculture.init;

import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.crafting.recipe.InfusionRecipe;
import com.github.elrol.industrialagriculture.init.CropInit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class RecipeInit {
    private static final Logger logger = Logger.getLogger(RecipeInit.class.getName());
    private static final Map<String, List<Ingredient>> recipes = new HashMap<String, List<Ingredient>>();

    public static void makeSeedRecipe(String name, List<Item> items) {
        if (recipes.containsKey(name)) {
            logger.info("A recipe with this name has already been registered.");
            return;
        }
        ArrayList ingredients = new ArrayList();
        items.forEach(item -> ingredients.add(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item})));
        logger.info("Adding Seed Recipe: " + name);
        recipes.put(name, ingredients);
    }

    private static InfusionRecipe makeSeed(String name, List<Ingredient> items) {
        Crop crop = CropInit.getCrop(name);
        Item essenceItem = crop.getTier().getEssence();
        if (essenceItem == null) {
            return null;
        }
        Item craftingSeedItem = crop.getType().getCraftingSeed();
        if (craftingSeedItem == null) {
            return null;
        }
        Ingredient aI = items.get(0);
        Ingredient bI = items.get(1);
        Ingredient cI = items.get(2);
        Ingredient dI = items.get(3);
        if (aI == Ingredient.field_193370_a || bI == Ingredient.field_193370_a || cI == Ingredient.field_193370_a || dI == Ingredient.field_193370_a) {
            return null;
        }
        Ingredient essence = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{essenceItem});
        Ingredient seed = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{craftingSeedItem});
        NonNullList inputs = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{seed, aI, essence, bI, essence, cI, essence, dI, essence});
        ItemStack output = new ItemStack((IItemProvider)crop.getSeeds());
        return new InfusionRecipe(new ResourceLocation("industrialagriculture", crop.getNameWithSuffix("seeds_infusion")), inputs, output);
    }
}

