/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.net;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.blay09.mods.craftingtweaks.CompressType;
import net.blay09.mods.craftingtweaks.CraftingTweaksConfig;
import net.blay09.mods.craftingtweaks.CraftingTweaksProviderManager;
import net.blay09.mods.craftingtweaks.InventoryCraftingCompress;
import net.blay09.mods.craftingtweaks.InventoryCraftingDecompress;
import net.blay09.mods.craftingtweaks.api.TweakProvider;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IRecipeHolder;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageCompress {
    private final int slotNumber;
    private final CompressType type;

    public MessageCompress(int slotNumber, CompressType type) {
        this.slotNumber = slotNumber;
        this.type = type;
    }

    public static MessageCompress decode(PacketBuffer buf) {
        int slotNumber = buf.readInt();
        CompressType type = CompressType.values()[buf.readByte()];
        return new MessageCompress(slotNumber, type);
    }

    public static void encode(MessageCompress message, PacketBuffer buf) {
        buf.writeInt(message.slotNumber);
        buf.writeByte(message.type.ordinal());
    }

    public static void handle(MessageCompress message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayerEntity player = context.getSender();
            if (player == null) {
                return;
            }
            Container container = player.field_71070_bA;
            if (container == null) {
                return;
            }
            CompressType compressType = message.type;
            Slot mouseSlot = (Slot)container.field_75151_b.get(message.slotNumber);
            if (!(mouseSlot.field_75224_c instanceof PlayerInventory)) {
                return;
            }
            ItemStack mouseStack = mouseSlot.func_75211_c();
            if (mouseStack.func_190926_b()) {
                return;
            }
            TweakProvider<Container> provider = CraftingTweaksProviderManager.getProvider(container);
            if (!((Boolean)CraftingTweaksConfig.COMMON.compressAnywhere.get()).booleanValue() && provider == null) {
                return;
            }
            if (compressType == CompressType.DECOMPRESS_ALL || compressType == CompressType.DECOMPRESS_STACK || compressType == CompressType.DECOMPRESS_ONE) {
                boolean decompressAll = compressType != CompressType.DECOMPRESS_ONE;
                block0: for (Slot slot : container.field_75151_b) {
                    ItemStack result;
                    if (compressType != CompressType.DECOMPRESS_ALL && slot != mouseSlot || !(slot.field_75224_c instanceof PlayerInventory) || !slot.func_75216_d() || !ItemStack.func_179545_c((ItemStack)slot.func_75211_c(), (ItemStack)mouseSlot.func_75211_c()) || !ItemStack.func_77970_a((ItemStack)slot.func_75211_c(), (ItemStack)mouseSlot.func_75211_c()) || (result = MessageCompress.findMatchingResult(new InventoryCraftingDecompress(container, slot.func_75211_c()), player)).func_190926_b() || MessageCompress.isBlacklisted(result) || slot.func_75211_c().func_190926_b() || slot.func_75211_c().func_190916_E() < 1) continue;
                    while (player.field_71071_by.func_70441_a(result.func_77946_l())) {
                        MessageCompress.giveLeftoverItems(player, slot.func_75211_c(), 1);
                        slot.func_75209_a(1);
                        if (decompressAll && slot.func_75216_d() && slot.func_75211_c().func_190916_E() >= 1) continue;
                        continue block0;
                    }
                }
            } else {
                boolean compressAll = compressType != CompressType.COMPRESS_ONE;
                int size = provider != null ? provider.getCraftingGridSize((PlayerEntity)player, container, 0) : 9;
                block2: for (Slot slot : container.field_75151_b) {
                    ItemStack result;
                    if (compressType != CompressType.COMPRESS_ALL && slot != mouseSlot) continue;
                    ItemStack slotStack = slot.func_75211_c();
                    if (!(slot.field_75224_c instanceof PlayerInventory) || !slot.func_75216_d() || !ItemStack.func_179545_c((ItemStack)slotStack, (ItemStack)mouseSlot.func_75211_c()) || !ItemStack.func_77970_a((ItemStack)slotStack, (ItemStack)mouseSlot.func_75211_c())) continue;
                    if (size == 9 && !slotStack.func_190926_b() && slotStack.func_190916_E() >= 9) {
                        result = MessageCompress.findMatchingResult(new InventoryCraftingCompress(container, 3, slotStack), player);
                        if (!result.func_190926_b() && !MessageCompress.isBlacklisted(result)) {
                            while (player.field_71071_by.func_70441_a(result.func_77946_l())) {
                                MessageCompress.giveLeftoverItems(player, slotStack, 9);
                                slot.func_75209_a(9);
                                if (compressAll && slot.func_75216_d() && slotStack.func_190916_E() >= 9) continue;
                                continue block2;
                            }
                            continue;
                        }
                        result = MessageCompress.findMatchingResult(new InventoryCraftingCompress(container, 2, slotStack), player);
                        if (result.func_190926_b() || MessageCompress.isBlacklisted(result)) continue;
                        while (player.field_71071_by.func_70441_a(result.func_77946_l())) {
                            MessageCompress.giveLeftoverItems(player, slotStack, 4);
                            slot.func_75209_a(4);
                            if (compressAll && slot.func_75216_d() && slotStack.func_190916_E() >= 4) continue;
                            continue block2;
                        }
                        continue;
                    }
                    if (size < 4 || slotStack.func_190926_b() || slotStack.func_190916_E() < 4 || (result = MessageCompress.findMatchingResult(new InventoryCraftingCompress(container, 2, slotStack), player)).func_190926_b() || MessageCompress.isBlacklisted(result)) continue;
                    while (player.field_71071_by.func_70441_a(result.func_77946_l())) {
                        MessageCompress.giveLeftoverItems(player, slotStack, 4);
                        slot.func_75209_a(4);
                        if (compressAll && slot.func_75216_d() && slotStack.func_190916_E() >= 4) continue;
                        continue block2;
                    }
                }
            }
            container.func_75142_b();
        });
        context.setPacketHandled(true);
    }

    private static void giveLeftoverItems(ServerPlayerEntity player, ItemStack slotStack, int count) {
        for (int i = 0; i < count; ++i) {
            ItemEntity itemEntity;
            ItemStack containerItem = slotStack.getContainerItem();
            if (player.func_191521_c(containerItem) || (itemEntity = player.func_71019_a(containerItem, false)) == null) continue;
            itemEntity.func_174868_q();
            itemEntity.func_200217_b(player.func_110124_au());
        }
    }

    private static <T extends CraftingInventory> ItemStack findMatchingResult(T craftingInventory, ServerPlayerEntity player) {
        RecipeManager recipeManager = Objects.requireNonNull(player.func_184102_h()).func_199529_aN();
        IRecipe recipe = recipeManager.func_215371_a(IRecipeType.field_222149_a, craftingInventory, player.field_70170_p).orElse(null);
        if (recipe != null && ((IRecipeHolder)craftingInventory).func_201561_a(player.field_70170_p, player, recipe)) {
            return recipe.func_77572_b(craftingInventory);
        }
        return ItemStack.field_190927_a;
    }

    private static boolean isBlacklisted(ItemStack result) {
        ResourceLocation registryName = result.func_77973_b().getRegistryName();
        return registryName != null && ((List)CraftingTweaksConfig.COMMON.compressBlacklist.get()).contains(registryName.toString());
    }
}

