/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear;

import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.command.arguments.ArgumentSerializer;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.silentchaos512.gear.IProxy;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.part.MaterialGrade;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.client.ColorHandlers;
import net.silentchaos512.gear.client.DebugOverlay;
import net.silentchaos512.gear.client.KeyTracker;
import net.silentchaos512.gear.client.event.ExtraBlockBreakHandler;
import net.silentchaos512.gear.client.event.GearHudOverlay;
import net.silentchaos512.gear.client.event.TooltipHandler;
import net.silentchaos512.gear.client.material.MaterialDisplayManager;
import net.silentchaos512.gear.client.model.fragment.FragmentModelLoader;
import net.silentchaos512.gear.client.model.gear.GearModelLoader;
import net.silentchaos512.gear.client.model.part.CompoundPartModelLoader;
import net.silentchaos512.gear.client.renderer.entity.GearElytraLayer;
import net.silentchaos512.gear.client.util.ModItemModelProperties;
import net.silentchaos512.gear.compat.curios.CurioGearItemCapability;
import net.silentchaos512.gear.compat.curios.CuriosCompat;
import net.silentchaos512.gear.compat.gamestages.GameStagesCompat;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.data.DataGenerators;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.gear.material.MaterialSerializers;
import net.silentchaos512.gear.gear.part.CompoundPart;
import net.silentchaos512.gear.gear.part.PartManager;
import net.silentchaos512.gear.gear.trait.TraitManager;
import net.silentchaos512.gear.init.GearVillages;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.init.ModCommands;
import net.silentchaos512.gear.init.ModContainers;
import net.silentchaos512.gear.init.ModEntities;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.init.ModTileEntities;
import net.silentchaos512.gear.init.NerfedGear;
import net.silentchaos512.gear.init.Registration;
import net.silentchaos512.gear.item.BlueprintPackageItem;
import net.silentchaos512.gear.item.CraftingItems;
import net.silentchaos512.gear.network.Network;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.world.ModWorldFeatures;
import net.silentchaos512.lib.event.Greetings;
import net.silentchaos512.lib.event.InitialSpawnItems;
import net.silentchaos512.lib.util.LibHooks;

class SideProxy
implements IProxy {
    @Nullable
    private static MinecraftServer server;

    SideProxy() {
        Registration.register();
        Config.init();
        Network.init();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(DataGenerators::gatherData);
        modEventBus.addListener(SideProxy::commonSetup);
        modEventBus.addListener(SideProxy::imcEnqueue);
        modEventBus.addListener(SideProxy::imcProcess);
        modEventBus.addListener(ItemStats::createRegistry);
        modEventBus.addGenericListener(Feature.class, ModWorldFeatures::registerFeatures);
        modEventBus.addGenericListener(ItemStat.class, ItemStats::registerStats);
        modEventBus.addGenericListener(Placement.class, ModWorldFeatures::registerPlacements);
        MinecraftForge.EVENT_BUS.addListener(ModCommands::registerAll);
        MinecraftForge.EVENT_BUS.addListener(SideProxy::onAddReloadListeners);
        MinecraftForge.EVENT_BUS.addListener(SideProxy::serverStarted);
        MinecraftForge.EVENT_BUS.addListener(SideProxy::serverStopping);
        ArgumentTypes.func_218136_a((String)"material_grade", MaterialGrade.Argument.class, (IArgumentSerializer)new ArgumentSerializer(MaterialGrade.Argument::new));
    }

    private static void commonSetup(FMLCommonSetupEvent event) {
        InitialSpawnItems.add((ResourceLocation)SilentGear.getId("starter_blueprints"), p -> {
            if (((Boolean)Config.Common.spawnWithStarterBlueprints.get()).booleanValue()) {
                return Collections.singleton(((BlueprintPackageItem)ModItems.BLUEPRINT_PACKAGE.get()).getStack());
            }
            return Collections.emptyList();
        });
        SideProxy.registerCompostables();
        NerfedGear.init();
        event.enqueueWork(GearVillages::init);
        Greetings.addMessage(SideProxy::detectDataLoadingFailure);
        if (ModList.get().isLoaded("curios")) {
            CurioGearItemCapability.register();
        }
    }

    private static void registerCompostables() {
        LibHooks.registerCompostable((float)0.3f, ModItems.FLAX_SEEDS);
        LibHooks.registerCompostable((float)0.3f, ModItems.FLUFFY_SEEDS);
        LibHooks.registerCompostable((float)0.5f, (IItemProvider)CraftingItems.FLAX_FIBER);
        LibHooks.registerCompostable((float)0.5f, (IItemProvider)CraftingItems.FLUFFY_PUFF);
    }

    private static void imcEnqueue(InterModEnqueueEvent event) {
        if (ModList.get().isLoaded("curios")) {
            CuriosCompat.imcEnqueue(event);
        }
    }

    private static void imcProcess(InterModProcessEvent event) {
    }

    private static void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)TraitManager.INSTANCE);
        event.addListener((IFutureReloadListener)PartManager.INSTANCE);
        event.addListener((IFutureReloadListener)MaterialManager.INSTANCE);
        if (ModList.get().isLoaded("gamestages")) {
            event.addListener(GameStagesCompat.INSTANCE);
        }
    }

    private static void serverStarted(FMLServerStartedEvent event) {
        server = event.getServer();
        SilentGear.LOGGER.info(TraitManager.MARKER, "Traits loaded: {}", (Object)TraitManager.getValues().size());
        SilentGear.LOGGER.info(PartManager.MARKER, "Parts loaded: {}", (Object)PartManager.getValues().size());
        SilentGear.LOGGER.info(PartManager.MARKER, "- Compound: {}", (Object)PartManager.getValues().stream().filter(part -> part instanceof CompoundPart).count());
        SilentGear.LOGGER.info(PartManager.MARKER, "- Simple: {}", (Object)PartManager.getValues().stream().filter(part -> !(part instanceof CompoundPart)).count());
        SilentGear.LOGGER.info(MaterialManager.MARKER, "Materials loaded: {}", (Object)MaterialManager.getValues().size());
        SilentGear.LOGGER.info(MaterialManager.MARKER, "- Standard: {}", (Object)MaterialManager.getValues().stream().filter(mat -> mat.getSerializer() == MaterialSerializers.STANDARD).count());
    }

    private static void serverStopping(FMLServerStoppingEvent event) {
        server = null;
    }

    @Override
    @Nullable
    public PlayerEntity getClientPlayer() {
        return null;
    }

    @Override
    @Nullable
    public World getClientLevel() {
        return null;
    }

    @Override
    @Nullable
    public MinecraftServer getServer() {
        return server;
    }

    @Nullable
    public static ITextComponent detectDataLoadingFailure(PlayerEntity player) {
        if (MaterialManager.getValues().isEmpty() || PartManager.getValues().isEmpty() || TraitManager.getValues().isEmpty()) {
            String msg = "Materials, parts, and/or traits have not loaded! This may be caused by a broken mod, even those not related to Silent Gear. Search your log for \"Failed to reload data packs\" to find the error.";
            SilentGear.LOGGER.error(msg);
            return new StringTextComponent(msg);
        }
        return null;
    }

    static class Server
    extends SideProxy {
        Server() {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::serverSetup);
        }

        private void serverSetup(FMLDedicatedServerSetupEvent event) {
        }
    }

    static class Client
    extends SideProxy {
        Client() {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(Client::clientSetup);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(Client::postSetup);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(ColorHandlers::onItemColors);
            MinecraftForge.EVENT_BUS.register((Object)ExtraBlockBreakHandler.INSTANCE);
            MinecraftForge.EVENT_BUS.register((Object)new GearHudOverlay());
            MinecraftForge.EVENT_BUS.register((Object)TooltipHandler.INSTANCE);
            MinecraftForge.EVENT_BUS.addListener(this::onPlayerLoggedIn);
            if (SilentGear.isDevBuild()) {
                MinecraftForge.EVENT_BUS.register((Object)new DebugOverlay());
            }
            if (Minecraft.func_71410_x() != null) {
                ModelLoaderRegistry.registerLoader((ResourceLocation)Const.COMPOUND_PART_MODEL_LOADER, (IModelLoader)new CompoundPartModelLoader());
                ModelLoaderRegistry.registerLoader((ResourceLocation)Const.FRAGMENT_MODEL_LOADER, (IModelLoader)new FragmentModelLoader());
                ModelLoaderRegistry.registerLoader((ResourceLocation)Const.GEAR_MODEL_LOADER, (IModelLoader)new GearModelLoader());
                IResourceManager resourceManager = Minecraft.func_71410_x().func_195551_G();
                if (resourceManager instanceof IReloadableResourceManager) {
                    ((IReloadableResourceManager)resourceManager).func_219534_a((IFutureReloadListener)MaterialDisplayManager.INSTANCE);
                }
            } else {
                SilentGear.LOGGER.warn("MC instance is null? Must be running data generators! Not registering model loaders...");
            }
        }

        private static void clientSetup(FMLClientSetupEvent event) {
            KeyTracker.register(event);
            ModBlocks.registerRenderTypes(event);
            ModEntities.registerRenderers(event);
            ModTileEntities.registerRenderers(event);
            ModContainers.registerScreens(event);
            ModItemModelProperties.register(event);
        }

        private static void postSetup(FMLLoadCompleteEvent event) {
            EntityRendererManager rendererManager = Minecraft.func_71410_x().func_175598_ae();
            rendererManager.getSkinMap().values().forEach(renderer -> renderer.func_177094_a(new GearElytraLayer(renderer)));
        }

        private void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        }

        @Override
        @Nullable
        public PlayerEntity getClientPlayer() {
            return Minecraft.func_71410_x().field_71439_g;
        }

        @Override
        @Nullable
        public World getClientLevel() {
            return Minecraft.func_71410_x().field_71441_e;
        }
    }
}

