/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.stats;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.stats.IItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.utils.Color;

public class ItemStat
extends ForgeRegistryEntry<ItemStat>
implements IItemStat {
    private final float baseValue;
    private final float defaultValue;
    private final float minimumValue;
    private final float maximumValue;
    private final StatInstance.Operation defaultOperation;
    private final Color nameColor;
    private final boolean visible;
    private final boolean synergyApplies;
    private final boolean affectedByGrades;
    private final boolean displayAsInt;
    private final DisplayFormat displayFormat;
    private final Function<Float, Float> missingRodFunction;
    private static final float WEIGHT_BASE_MIN = 2.0f;
    private static final float WEIGHT_BASE_MAX = 40.0f;
    private static final float WEIGHT_DEVIATION_COEFF = 2.0f;

    public ItemStat(float defaultValue, float minValue, float maxValue, TextFormatting nameColor, Properties properties) {
        this(defaultValue, minValue, maxValue, new Color(nameColor.func_211163_e() != null ? nameColor.func_211163_e() : 0xFFFFFF), properties);
    }

    public ItemStat(float defaultValue, float minValue, float maxValue, Color nameColor, Properties properties) {
        this.baseValue = properties.baseValue;
        this.defaultValue = defaultValue;
        this.minimumValue = minValue;
        this.maximumValue = maxValue;
        this.nameColor = nameColor;
        this.defaultOperation = properties.defaultOp;
        this.displayAsInt = properties.displayAsInt;
        this.displayFormat = properties.displayFormat;
        this.visible = properties.visible;
        this.synergyApplies = properties.synergyApplies;
        this.affectedByGrades = properties.affectedByGrades;
        this.missingRodFunction = properties.missingRodFunction;
        if (this.minimumValue > this.maximumValue) {
            throw new IllegalArgumentException("Minimum value cannot be bigger than maximum value!");
        }
        if (this.defaultValue < this.minimumValue) {
            throw new IllegalArgumentException("Default value cannot be lower than minimum value!");
        }
        if (this.defaultValue > this.maximumValue) {
            throw new IllegalArgumentException("Default value cannot be bigger than maximum value!");
        }
        ItemStats.STATS_IN_ORDER.add(this);
    }

    @Override
    public ResourceLocation getStatId() {
        return Objects.requireNonNull(this.getRegistryName());
    }

    @Override
    public float getBaseValue() {
        return this.baseValue;
    }

    @Override
    public float getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public float getMinimumValue() {
        return this.minimumValue;
    }

    @Override
    public float getMaximumValue() {
        return this.maximumValue;
    }

    @Override
    public StatInstance.Operation getDefaultOperation() {
        return this.defaultOperation;
    }

    public boolean isDisplayAsInt() {
        return this.displayAsInt;
    }

    public DisplayFormat getDisplayFormat() {
        return this.displayFormat;
    }

    @Deprecated
    public boolean isDisplayAsMultiplier() {
        return this.displayFormat == DisplayFormat.MULTIPLIER;
    }

    public Color getNameColor() {
        return this.nameColor;
    }

    public float clampValue(float value) {
        value = MathHelper.func_76131_a((float)value, (float)this.minimumValue, (float)this.maximumValue);
        return value;
    }

    public float compute(Collection<StatInstance> modifiers) {
        return this.compute(this.baseValue, modifiers);
    }

    public float compute(float baseValue, Collection<StatInstance> modifiers) {
        return this.compute(baseValue, true, GearType.ALL, modifiers);
    }

    @Deprecated
    public float compute(float baseValue, boolean clampValue, Collection<StatInstance> modifiers) {
        return this.compute(baseValue, clampValue, GearType.ALL, modifiers);
    }

    public float compute(float baseValue, boolean clampValue, GearType gearType, Collection<StatInstance> modifiers) {
        return this.compute(baseValue, clampValue, gearType, gearType, modifiers);
    }

    public float compute(float baseValue, boolean clampValue, GearType itemGearType, GearType statGearType, Collection<StatInstance> modifiers) {
        if (modifiers.isEmpty()) {
            return baseValue;
        }
        float f0 = baseValue;
        f0 += ItemStat.getWeightedAverage(modifiers, StatInstance.Operation.AVG);
        for (StatInstance mod : modifiers) {
            if (mod.getOp() != StatInstance.Operation.MAX) continue;
            f0 = Math.max(f0, mod.getValue());
        }
        float f1 = f0;
        for (StatInstance mod : modifiers) {
            if (mod.getOp() != StatInstance.Operation.MUL1) continue;
            f1 += f0 * mod.getValue();
        }
        for (StatInstance mod : modifiers) {
            if (mod.getOp() != StatInstance.Operation.MUL2) continue;
            f1 *= 1.0f + mod.getValue();
        }
        for (StatInstance mod : modifiers) {
            if (mod.getOp() != StatInstance.Operation.ADD) continue;
            f1 += mod.getValue();
        }
        return clampValue ? this.clampValue(f1) : f1;
    }

    private static float getPrimaryMod(Iterable<StatInstance> modifiers, StatInstance.Operation op) {
        float primaryMod = -1.0f;
        for (StatInstance mod : modifiers) {
            if (mod.getOp() != op || !(primaryMod < 0.0f)) continue;
            primaryMod = mod.getValue();
        }
        return primaryMod > 0.0f ? primaryMod : 1.0f;
    }

    public static float getWeightedAverage(Collection<StatInstance> modifiers, StatInstance.Operation op) {
        float primaryMod = ItemStat.getPrimaryMod(modifiers, op);
        float ret = 0.0f;
        int count = 0;
        float totalWeight = 0.0f;
        for (StatInstance mod : modifiers) {
            if (mod.getOp() != op) continue;
            float weight = ItemStat.getModifierWeight(mod, primaryMod, ++count);
            totalWeight += weight;
            ret += mod.getValue() * weight;
        }
        return count > 0 && totalWeight > 0.0f ? ret / totalWeight : ret;
    }

    private static float getModifierWeight(StatInstance mod, float primaryMod, int count) {
        float weightBase = 2.0f + 2.0f * (mod.getValue() - primaryMod) / primaryMod;
        float weightBaseClamped = MathHelper.func_76131_a((float)weightBase, (float)2.0f, (float)40.0f);
        return (float)Math.pow(weightBaseClamped, -(count == 0 ? (double)count : 0.5 + (double)(0.5f * (float)count)));
    }

    private static float getMaterialPrimaryMod(Iterable<StatInstance> modifiers, StatInstance.Operation op) {
        float ret = -1.0f;
        for (StatInstance mod : modifiers) {
            if (mod.getOp() != op || !(ret < mod.value)) continue;
            ret = mod.value;
        }
        return ret > 0.0f ? ret : 1.0f;
    }

    public static float getMaterialWeightedAverage(Collection<StatInstance> modifiers, StatInstance.Operation op) {
        float primaryMod = ItemStat.getMaterialPrimaryMod(modifiers, op);
        float ret = 0.0f;
        float totalWeight = 0.0f;
        for (StatInstance mod : modifiers) {
            if (mod.getOp() != op) continue;
            float weight = ItemStat.getMaterialModifierWeight(mod, primaryMod);
            totalWeight += weight;
            ret += mod.getValue() * weight;
        }
        return totalWeight > 0.0f ? ret / totalWeight : ret;
    }

    private static float getMaterialModifierWeight(StatInstance mod, float primaryMod) {
        return 1.0f + mod.value / (1.0f + Math.abs(primaryMod));
    }

    public StatInstance computeForDisplay(float baseValue, GearType gearType, Collection<StatInstance> modifiers) {
        if (modifiers.isEmpty()) {
            return StatInstance.of(baseValue, StatInstance.Operation.AVG, StatInstance.DEFAULT_KEY);
        }
        boolean add = true;
        for (StatInstance inst : modifiers) {
            StatInstance.Operation op = inst.getOp();
            if (op != StatInstance.Operation.AVG && op != StatInstance.Operation.ADD && op != StatInstance.Operation.MAX) continue;
            add = false;
            break;
        }
        float value = this.compute(baseValue + (float)add, false, gearType, modifiers) - (float)add;
        StatInstance.Operation op = modifiers.iterator().next().getOp();
        return StatInstance.of(value, op, StatInstance.DEFAULT_KEY);
    }

    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public boolean doesSynergyApply() {
        return this.synergyApplies;
    }

    public boolean isAffectedByGrades() {
        return this.affectedByGrades;
    }

    @Deprecated
    public float withMissingRodEffect(float statValue) {
        if (this.missingRodFunction == null) {
            return statValue;
        }
        return this.missingRodFunction.apply(Float.valueOf(statValue)).floatValue();
    }

    public String toString() {
        return String.format("ItemStat{%s}", this.getRegistryName());
    }

    public IFormattableTextComponent getDisplayName() {
        ResourceLocation name = this.getRegistryName();
        if (name == null) {
            return new StringTextComponent("Unregistered stat: " + this);
        }
        return new TranslationTextComponent("stat." + name.func_110624_b() + "." + name.func_110623_a());
    }

    public static class Properties {
        private float baseValue = 0.0f;
        private StatInstance.Operation defaultOp = StatInstance.Operation.AVG;
        private boolean displayAsInt;
        private DisplayFormat displayFormat = DisplayFormat.UNIT;
        private boolean visible = true;
        private boolean synergyApplies = false;
        private boolean affectedByGrades = true;
        private Function<Float, Float> missingRodFunction;

        public Properties baseValue(float value) {
            this.baseValue = value;
            return this;
        }

        public Properties defaultOp(StatInstance.Operation op) {
            this.defaultOp = op;
            return this;
        }

        public Properties displayAsInt() {
            this.displayAsInt = true;
            return this;
        }

        public Properties displayFormat(DisplayFormat format) {
            this.displayFormat = format;
            return this;
        }

        @Deprecated
        public Properties displayAsMultiplier() {
            this.displayFormat = DisplayFormat.MULTIPLIER;
            return this;
        }

        public Properties hidden() {
            this.visible = false;
            return this;
        }

        public Properties synergyApplies() {
            this.synergyApplies = true;
            return this;
        }

        public Properties affectedByGrades(boolean value) {
            this.affectedByGrades = value;
            return this;
        }

        @Deprecated
        public Properties missingRodFunction(Function<Float, Float> function) {
            this.missingRodFunction = function;
            return this;
        }
    }

    public static enum DisplayFormat {
        UNIT,
        MULTIPLIER,
        PERCENTAGE;

    }
}

