/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class TextListBuilder {
    static final String[] BULLETS = new String[]{"\u2022", "\u25e6", "\u25aa"};
    static final String VANILLA_BULLET = "\u2666";
    private final List<ITextComponent> list = new ArrayList<ITextComponent>();
    private int indent = 0;

    public TextListBuilder indent() {
        ++this.indent;
        return this;
    }

    public TextListBuilder unindent() {
        if (this.indent > 0) {
            --this.indent;
        }
        return this;
    }

    public TextListBuilder add(ITextComponent text) {
        this.list.add((ITextComponent)this.indentWithBullet().func_230529_a_(text));
        return this;
    }

    public TextListBuilder removeLast() {
        this.list.remove(this.list.size() - 1);
        return this;
    }

    private IFormattableTextComponent indentWithBullet() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.indent; ++i) {
            builder.append("  ");
        }
        String bullet = BULLETS[MathHelper.func_76125_a((int)this.indent, (int)0, (int)(BULLETS.length - 1))];
        builder.append(bullet).append(" ");
        return new StringTextComponent(builder.toString());
    }

    public List<ITextComponent> build() {
        return this.list;
    }
}

