/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.compat.curios;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.silentchaos512.gear.item.gear.CoreElytra;
import net.silentchaos512.gear.util.GearHelper;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class CurioGearItemCapability {
    public static void register() {
        CapabilityManager.INSTANCE.register(CurioGearItemWrapper.class, (Capability.IStorage)new Capability.IStorage<CurioGearItemWrapper>(){

            public INBT writeNBT(Capability<CurioGearItemWrapper> capability, CurioGearItemWrapper instance, Direction side) {
                return new CompoundNBT();
            }

            public void readNBT(Capability<CurioGearItemWrapper> capability, CurioGearItemWrapper instance, Direction side, INBT nbt) {
            }
        }, () -> new CurioGearItemWrapper());
    }

    public static ICapabilityProvider createProvider(ItemStack stack, Consumer<Multimap<Attribute, AttributeModifier>> extraAttributes) {
        return new Provider(new CurioGearItemWrapper(stack, extraAttributes));
    }

    public static ICapabilityProvider createElytraProvider(final ItemStack stack, CoreElytra item) {
        return new Provider(new CurioGearItemWrapper(stack, multimap -> item.addAttributes("back", stack, (Multimap<Attribute, AttributeModifier>)multimap, false)){

            @Override
            public void curioTick(String identifier, int index, LivingEntity livingEntity) {
                if (livingEntity.field_70170_p.field_72995_K || !ElytraItem.func_185069_d((ItemStack)stack)) {
                    return;
                }
                Integer ticksFlying = (Integer)ObfuscationReflectionHelper.getPrivateValue(LivingEntity.class, (Object)livingEntity, (String)"field_184629_bo");
                if (ticksFlying != null && (ticksFlying + 1) % 20 == 0) {
                    stack.func_222118_a(1, livingEntity, entity -> entity.func_213361_c(EquipmentSlotType.CHEST));
                }
            }
        });
    }

    public static ICapabilityProvider createProvider(CurioGearItemWrapper curio) {
        return new Provider(curio);
    }

    public static class CurioGearItemWrapper
    implements ICurio {
        private final ItemStack stack;
        private final Consumer<Multimap<Attribute, AttributeModifier>> extraAttributes;

        private CurioGearItemWrapper() {
            this(ItemStack.field_190927_a, multimap -> {});
        }

        private CurioGearItemWrapper(ItemStack stack, Consumer<Multimap<Attribute, AttributeModifier>> extraAttributes) {
            this.stack = stack;
            this.extraAttributes = extraAttributes;
        }

        public void curioTick(String identifier, int index, LivingEntity livingEntity) {
            GearHelper.inventoryTick(this.stack, livingEntity.field_70170_p, (Entity)livingEntity, -1, true);
        }

        public Multimap<Attribute, AttributeModifier> getAttributeModifiers(String identifier) {
            Multimap<Attribute, AttributeModifier> multimap = GearHelper.getAttributeModifiers(identifier, this.stack, (Multimap<Attribute, AttributeModifier>)HashMultimap.create(), false);
            this.extraAttributes.accept(multimap);
            return multimap;
        }

        public int getFortuneBonus(String identifier, LivingEntity livingEntity, ItemStack curio, int index) {
            return 0;
        }

        public int getLootingBonus(String identifier, LivingEntity livingEntity, ItemStack curio, int index) {
            return 0;
        }

        @Nonnull
        public ICurio.DropRule getDropRule(LivingEntity livingEntity) {
            return ICurio.DropRule.ALWAYS_KEEP;
        }

        public boolean canRightClickEquip() {
            return true;
        }

        public void playRightClickEquipSound(LivingEntity livingEntity) {
            livingEntity.field_70170_p.func_184133_a(null, new BlockPos(livingEntity.func_213303_ch()), SoundEvents.field_187722_q, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        }
    }

    public static class Provider
    implements ICapabilityProvider {
        final LazyOptional<ICurio> capability = LazyOptional.of(() -> curio);

        Provider(CurioGearItemWrapper curio) {
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return CuriosCapability.ITEM.orEmpty(cap, this.capability);
        }
    }
}

