/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import com.google.gson.JsonObject;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.init.ModRecipes;
import net.silentchaos512.gear.item.FragmentItem;
import net.silentchaos512.gear.item.RepairKitItem;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.lib.collection.StackList;

public class FillRepairKitRecipe
extends SpecialRecipe {
    public FillRepairKitRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        boolean kitFound = false;
        int matsFound = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof RepairKitItem) {
                if (kitFound) {
                    return false;
                }
                kitFound = true;
                continue;
            }
            if (FillRepairKitRecipe.isRepairMaterial(stack)) {
                ++matsFound;
                continue;
            }
            return false;
        }
        return kitFound && matsFound > 0;
    }

    public ItemStack assemble(CraftingInventory inv) {
        StackList list = StackList.from((IInventory)inv);
        ItemStack repairKit = list.uniqueOfType(RepairKitItem.class).func_77946_l();
        repairKit.func_190920_e(1);
        RepairKitItem repairKitItem = (RepairKitItem)repairKit.func_77973_b();
        for (ItemStack mat : list.allMatches(FillRepairKitRecipe::isRepairMaterial)) {
            if (repairKitItem.addMaterial(repairKit, mat)) continue;
            return ItemStack.field_190927_a;
        }
        return repairKit;
    }

    private static boolean isRepairMaterial(ItemStack stack) {
        if (stack.func_77973_b() instanceof FragmentItem) {
            IMaterialInstance material = FragmentItem.getMaterial(stack);
            return material != null && FillRepairKitRecipe.isRepairMaterial(material);
        }
        MaterialInstance material = MaterialInstance.from(stack);
        return material != null && FillRepairKitRecipe.isRepairMaterial(material);
    }

    private static boolean isRepairMaterial(IMaterialInstance material) {
        float durability = material.getStat(PartType.MAIN, ItemStats.DURABILITY);
        float armorDurability = material.getStat(PartType.MAIN, ItemStats.ARMOR_DURABILITY);
        IMaterial mat = (IMaterial)material.get();
        return mat != null && mat.allowedInPart(material, PartType.MAIN) && (durability > 0.0f || armorDurability > 0.0f);
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public ResourceLocation func_199560_c() {
        return Const.FILL_REPAIR_KIT;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipes.FILL_REPAIR_KIT.get();
    }

    public static final class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<FillRepairKitRecipe> {
        public FillRepairKitRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            return new FillRepairKitRecipe(recipeId);
        }

        public FillRepairKitRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            return new FillRepairKitRecipe(recipeId);
        }

        public void toNetwork(PacketBuffer buffer, FillRepairKitRecipe recipe) {
        }
    }
}

