/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.entity.projectile;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.init.ModEntities;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;

public class GearArrowEntity
extends ArrowEntity {
    private static final Cache<UUID, ItemStack> STACK_CACHE = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private ItemStack arrowStack = ItemStack.field_190927_a;

    public GearArrowEntity(EntityType<? extends ArrowEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public GearArrowEntity(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public GearArrowEntity(World worldIn, LivingEntity shooter) {
        super(worldIn, shooter);
    }

    public GearArrowEntity(FMLPlayMessages.SpawnEntity message, World world) {
        this((EntityType<? extends ArrowEntity>)((EntityType)ModEntities.ARROW.get()), world);
    }

    private static boolean isSameArrowStack(UUID uuid, ItemStack other) {
        return other.func_77952_i() > 0 && GearHelper.isGear(other) && GearData.getUUID(other).equals(uuid);
    }

    public void setArrowStack(ItemStack stack) {
        try {
            this.arrowStack = (ItemStack)STACK_CACHE.get((Object)GearData.getUUID(stack), () -> GearArrowEntity.getArrowClone(stack));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    private static ItemStack getArrowClone(ItemStack stack) {
        ItemStack ret = stack.func_77946_l();
        ret.func_196085_b(ret.func_77958_k() - 1);
        return ret;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        Entity shooter = this.func_234616_v_();
        if (shooter instanceof PlayerEntity && !((PlayerEntity)shooter).field_71075_bZ.field_75098_d) {
            this.field_70251_a = AbstractArrowEntity.PickupStatus.ALLOWED;
        }
    }

    public void func_234612_a_(Entity shooter, float x, float y, float z, float velocity, float inaccuracy) {
        float speedMulti = GearData.getStat(this.arrowStack, ItemStats.PROJECTILE_SPEED);
        float accuracy = GearData.getStat(this.arrowStack, ItemStats.PROJECTILE_ACCURACY);
        super.func_234612_a_(shooter, x, y, z, velocity * speedMulti, accuracy > 0.0f ? inaccuracy / accuracy : inaccuracy);
    }

    public void func_70100_b_(PlayerEntity entityIn) {
        if (!this.field_70170_p.field_72995_K && (this.field_70254_i || this.func_203047_q()) && this.field_70249_b <= 0) {
            boolean flag;
            boolean bl = flag = this.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED || this.field_70251_a == AbstractArrowEntity.PickupStatus.CREATIVE_ONLY && entityIn.field_71075_bZ.field_75098_d || this.func_203047_q() && this.func_234616_v_().func_110124_au() == entityIn.func_110124_au();
            if (!(this.field_70251_a != AbstractArrowEntity.PickupStatus.ALLOWED || GearHelper.isGear(this.arrowStack) && this.addArrowToPlayerInventory(entityIn))) {
                flag = false;
            }
            if (flag) {
                entityIn.func_71001_a((Entity)this, 1);
                this.func_70106_y();
            }
        }
    }

    private boolean addArrowToPlayerInventory(PlayerEntity player) {
        UUID uuid = GearData.getUUID(this.arrowStack);
        for (ItemStack stack : player.field_71071_by.field_184439_c) {
            if (!GearArrowEntity.isSameArrowStack(uuid, stack)) continue;
            stack.func_196085_b(stack.func_77952_i() - 1);
            return true;
        }
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (!GearArrowEntity.isSameArrowStack(uuid, stack)) continue;
            stack.func_196085_b(stack.func_77952_i() - 1);
            return true;
        }
        return player.func_191521_c(this.arrowStack);
    }
}

