/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.event;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.fish.CodEntity;
import net.minecraft.entity.passive.fish.PufferfishEntity;
import net.minecraft.entity.passive.fish.SalmonEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.FireworkRocketItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.material.MaterialList;
import net.silentchaos512.gear.api.part.PartDataList;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.gear.part.CompoundPart;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.item.gear.CoreArmor;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.SynergyUtils;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.lib.advancements.LibTriggers;
import net.silentchaos512.lib.util.EntityHelper;

@Mod.EventBusSubscriber
public final class GearEvents {
    public static final ResourceLocation APPLY_TIP_UPGRADE = SilentGear.getId("apply_tip_upgrade");
    public static final ResourceLocation CRAFTED_WITH_ROUGH_ROD = SilentGear.getId("crafted_with_rough_rod");
    public static final ResourceLocation MAX_DURABILITY = SilentGear.getId("max_durability");
    public static final ResourceLocation REPAIR_FROM_BROKEN = SilentGear.getId("repair_from_broken");
    public static final ResourceLocation UNIQUE_MAIN_PARTS = SilentGear.getId("unique_main_parts");
    public static final ResourceLocation FALL_WITH_MOONWALKER = SilentGear.getId("fall_with_moonwalker");
    private static final Set<UUID> entityAttackedThisTick = new HashSet<UUID>();
    private static final float BURN_TICKS_PER_DURABILITY = 4.0f;
    private static final List<Function<World, Entity>> JABBERWOCKY_MOBS = ImmutableList.of(world -> new WolfEntity(EntityType.field_200724_aC, world), world -> new CatEntity(EntityType.field_220360_g, world), world -> new RabbitEntity(EntityType.field_200736_ab, world), world -> new ChickenEntity(EntityType.field_200795_i, world), world -> new CodEntity(EntityType.field_203780_j, world), world -> new SalmonEntity(EntityType.field_203778_ae, world), world -> new PufferfishEntity(EntityType.field_203779_Z, world));
    private static final Map<Entity, Vector3d> BOUNCE_TICKS = new HashMap<Entity, Vector3d>();

    private GearEvents() {
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent events) {
        entityAttackedThisTick.clear();
    }

    @SubscribeEvent
    public static void onAttackEntity(LivingAttackEvent event) {
        LivingEntity attacked = event.getEntityLiving();
        if (attacked == null || attacked.field_70170_p.field_72995_K || entityAttackedThisTick.contains(attacked.func_110124_au())) {
            return;
        }
        DamageSource source = event.getSource();
        if (source == null || !"player".equals(source.field_76373_n)) {
            return;
        }
        Entity attacker = source.func_76346_g();
        if (!(attacker instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)attacker;
        ItemStack weapon = player.func_184614_ca();
        if (!(weapon.func_77973_b() instanceof ICoreTool)) {
            return;
        }
        float baseDamage = event.getAmount();
        float newDamage = TraitHelper.activateTraits(weapon, baseDamage, (trait, level, value) -> trait.onAttackEntity(new TraitActionContext(player, level, weapon), attacked, value));
        if (Math.abs(newDamage - baseDamage) > 1.0E-4f) {
            event.setCanceled(true);
            entityAttackedThisTick.add(attacked.func_110124_au());
            attacked.func_70097_a(source, newDamage);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        int chilled;
        int aquatic;
        LivingEntity attacked = event.getEntityLiving();
        DamageSource source = event.getSource();
        if (source == null || !"player".equals(source.field_76373_n)) {
            return;
        }
        Entity attacker = source.func_76346_g();
        if (!(attacker instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)attacker;
        ItemStack weapon = player.func_184614_ca();
        if (!(weapon.func_77973_b() instanceof ICoreTool)) {
            return;
        }
        int adamant = TraitHelper.getTraitLevel(weapon, Const.Traits.ADAMANT);
        if (adamant > 0 && attacked.func_110138_aP() > 21.0f) {
            event.setAmount(event.getAmount() + (float)(2 * adamant));
        }
        if ((aquatic = TraitHelper.getTraitLevel(weapon, Const.Traits.AQUATIC)) > 0 && attacked.func_70648_aU()) {
            event.setAmount(event.getAmount() + (float)(2 * aquatic));
        }
        if ((chilled = TraitHelper.getTraitLevel(weapon, Const.Traits.CHILLED)) > 0 && attacked.func_230279_az_()) {
            event.setAmount(event.getAmount() + (float)(2 * chilled));
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        if (event.getEntity() instanceof PlayerEntity && GearEvents.isFireDamage(event.getSource())) {
            GearEvents.damageFlammableItems(event);
        }
    }

    private static boolean isFireDamage(DamageSource source) {
        return source == DamageSource.field_76372_a || source == DamageSource.field_76370_b || source == DamageSource.field_76371_c;
    }

    private static void damageFlammableItems(LivingDamageEvent event) {
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            ItemStack stack = event.getEntityLiving().func_184582_a(slot);
            if (!GearHelper.isGear(stack) || !TraitHelper.hasTrait(stack, Const.Traits.FLAMMABLE)) continue;
            GearHelper.attemptDamage(stack, 2, event.getEntityLiving(), slot);
            if (!GearHelper.isBroken(stack)) continue;
            event.getEntityLiving().func_145747_a((ITextComponent)TextUtil.translate("trait", "flammable.itemDestroyed", stack.func_200301_q()), Util.field_240973_b_);
            event.getEntityLiving().func_213361_c(slot);
            stack.func_190918_g(1);
        }
    }

    @SubscribeEvent
    public static void onFurnaceFuelBurnTimeEvent(FurnaceFuelBurnTimeEvent event) {
        ItemStack stack = event.getItemStack();
        if (GearHelper.isGear(stack) && TraitHelper.hasTrait(stack, Const.Traits.FLAMMABLE)) {
            float durability = GearData.getStat(stack, GearHelper.getDurabilityStat(stack));
            event.setBurnTime((int)(durability * 4.0f));
        }
    }

    @SubscribeEvent
    public static void onLivingHurtMagicArmor(LivingHurtEvent event) {
        if (event.getSource().func_82725_o()) {
            float magicArmor = GearEvents.getTotalMagicArmor(event.getEntityLiving());
            float scale = 1.0f - GearEvents.getReducedMagicDamageScale(magicArmor);
            if (event.getEntityLiving() instanceof PlayerEntity) {
                ((PlayerEntity)event.getEntityLiving()).field_71071_by.func_234563_a_(event.getSource(), event.getAmount());
            }
            event.setAmount(event.getAmount() * scale);
        }
    }

    private static float getTotalMagicArmor(LivingEntity entity) {
        float total = 0.0f;
        for (ItemStack stack : entity.func_184193_aE()) {
            if (!(stack.func_77973_b() instanceof CoreArmor)) continue;
            total = (float)((double)total + ((CoreArmor)stack.func_77973_b()).getArmorMagicProtection(stack));
        }
        return total;
    }

    private static float getReducedMagicDamageScale(float magicArmor) {
        if (magicArmor > 20.0f) {
            return 0.6f + 0.015f * (magicArmor - 20.0f);
        }
        return 0.03f * magicArmor;
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        PlayerEntity player = event.getPlayer();
        ItemStack tool = player.func_184614_ca();
        if (tool.func_77973_b() instanceof ICoreItem) {
            boolean canHarvest;
            BlockState state = event.getState();
            ToolType toolClass = state.func_177230_c().getHarvestTool(state);
            int blockLevel = state.func_177230_c().getHarvestLevel(state);
            int toolLevel = tool.func_77973_b().getHarvestLevel(tool, toolClass, player, state);
            boolean bl = canHarvest = toolLevel >= blockLevel;
            if (canHarvest) {
                int level = TraitHelper.getTraitLevel(tool, Const.Traits.LUSTROUS);
                int light = GearEvents.getLightForLustrousTrait((IBlockDisplayReader)player.field_70170_p, player.func_233580_cy_());
                event.setNewSpeed(event.getNewSpeed() + (float)GearEvents.getLustrousSpeedBonus(level, light));
            }
        }
    }

    public static int getLightForLustrousTrait(IBlockDisplayReader world, BlockPos pos) {
        int blockLight = world.func_226658_a_(LightType.BLOCK, pos);
        int skyLight = world.func_226658_a_(LightType.SKY, pos);
        return Math.max(skyLight, blockLight * 3 / 4);
    }

    public static int getLustrousSpeedBonus(int level, int light) {
        return 4 * level * light / 15;
    }

    @SubscribeEvent
    public static void onXpDrop(LivingExperienceDropEvent event) {
        if (event.getAttackingPlayer() == null) {
            return;
        }
        ItemStack tool = event.getAttackingPlayer().func_184614_ca();
        if (tool.func_190926_b() || !(tool.func_77973_b() instanceof ICoreTool)) {
            return;
        }
        int ancientLevel = TraitHelper.getTraitLevel(tool, Const.Traits.ANCIENT);
        if (ancientLevel == 0) {
            return;
        }
        int bonusXp = (int)((float)event.getOriginalExperience() * 0.25f * (float)ancientLevel);
        event.setDroppedExperience(event.getDroppedExperience() + bonusXp);
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        ItemStack tool = event.getPlayer().func_184614_ca();
        if (tool.func_190926_b() || !(tool.func_77973_b() instanceof ICoreTool)) {
            return;
        }
        int ancientLevel = TraitHelper.getTraitLevel(tool, Const.Traits.ANCIENT);
        if (ancientLevel > 0) {
            int bonusXp = (int)((float)event.getExpToDrop() * 0.25f * (float)ancientLevel);
            event.setExpToDrop(event.getExpToDrop() + bonusXp);
        }
        if (TraitHelper.hasTrait(tool, Const.Traits.JABBERWOCKY) && event.getState().func_235714_a_((ITag)Tags.Blocks.ORES_DIAMOND) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)tool) == 0) {
            Entity entity = JABBERWOCKY_MOBS.get(SilentGear.RANDOM.nextInt(JABBERWOCKY_MOBS.size())).apply(event.getPlayer().func_130014_f_());
            entity.func_70634_a((double)event.getPos().func_177958_n() + 0.5, (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p() + 0.5);
            EntityHelper.safeSpawn((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void onGearCrafted(PlayerEvent.ItemCraftedEvent event) {
        ItemStack result = event.getCrafting();
        if (GearHelper.isGear(result) && event.getPlayer() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            if (GearData.hasPart(result, PartType.ROD, p -> p.containsMaterial(Const.Materials.WOOD_ROUGH))) {
                LibTriggers.GENERIC_INT.trigger(player, CRAFTED_WITH_ROUGH_ROD, 1);
            }
            int brokenCount = GearData.getBrokenCount(result);
            int repairCount = GearData.getRepairCount(result);
            if (brokenCount > 0 && repairCount > 0) {
                LibTriggers.GENERIC_INT.trigger(player, REPAIR_FROM_BROKEN, brokenCount);
            }
            LibTriggers.GENERIC_INT.trigger(player, MAX_DURABILITY, result.func_77958_k());
            PartDataList parts = GearData.getConstructionParts(result);
            if (!parts.getTips().isEmpty()) {
                LibTriggers.GENERIC_INT.trigger(player, APPLY_TIP_UPGRADE, 1);
            }
            LibTriggers.GENERIC_INT.trigger(player, UNIQUE_MAIN_PARTS, GearEvents.getUniqueMainMaterialCount(parts));
        }
    }

    private static int getUniqueMainMaterialCount(PartDataList parts) {
        for (PartData part : parts) {
            if (!(part.get() instanceof CompoundPart) || part.getType() != PartType.MAIN) continue;
            MaterialList materials = CompoundPartItem.getMaterials(part.getItem());
            return SynergyUtils.getUniques(materials).size();
        }
        return 1;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingDeath(LivingDeathEvent event) {
        PlayerEntity player;
        Entity killer = event.getSource().func_76346_g();
        if (killer instanceof PlayerEntity && !killer.field_70170_p.field_72995_K && TraitHelper.hasTraitEitherHand(player = (PlayerEntity)killer, Const.Traits.CONFETTI)) {
            for (int i = 0; i < 3; ++i) {
                FireworkRocketEntity rocket = new FireworkRocketEntity(player.field_70170_p, event.getEntity().func_226277_ct_(), event.getEntity().func_226280_cw_(), event.getEntity().func_226281_cx_(), GearEvents.createRandomFirework());
                EntityHelper.safeSpawn((Entity)rocket);
            }
        }
    }

    private static ItemStack createRandomFirework() {
        ItemStack ret = new ItemStack((IItemProvider)Items.field_196152_dE);
        CompoundNBT nbt = ret.func_190925_c("Fireworks");
        nbt.func_74774_a("Flight", (byte)(SilentGear.RANDOM.nextInt(3) + 1));
        CompoundNBT explosion = new CompoundNBT();
        explosion.func_74774_a("Type", (byte)SilentGear.RANDOM.nextInt(FireworkRocketItem.Shape.values().length));
        ListNBT colors = new ListNBT();
        for (int i = 0; i < SilentGear.RANDOM.nextInt(4) + 1; ++i) {
            DyeColor dye = DyeColor.values()[SilentGear.RANDOM.nextInt(DyeColor.values().length)];
            SilentGear.LOGGER.debug((Object)dye);
            colors.add((Object)IntNBT.func_229692_a_((int)dye.func_196060_f()));
        }
        explosion.func_218657_a("Colors", (INBT)colors);
        ListNBT explosions = new ListNBT();
        explosions.add((Object)explosion);
        nbt.func_218657_a("Explosions", (INBT)explosions);
        return ret;
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.phase == TickEvent.Phase.START) {
            int magnetic = Math.max(TraitHelper.getHighestLevelEitherHand(event.player, Const.Traits.MAGNETIC), TraitHelper.getHighestLevelCurio((LivingEntity)event.player, Const.Traits.MAGNETIC));
            if (magnetic > 0) {
                GearEvents.tickMagnetic(event.player, magnetic);
            }
            if (!event.player.func_208600_a((ITag)FluidTags.field_206959_a) && TraitHelper.hasTrait(event.player.func_184582_a(EquipmentSlotType.HEAD), Const.Traits.TURTLE)) {
                event.player.func_195064_c(new EffectInstance(Effects.field_76427_o, 210, 0, false, false, true));
            }
            if (event.player.func_226278_cu_() < -64.0 && TraitHelper.hasTraitArmor(event.player, Const.Traits.VOID_WARD)) {
                event.player.func_70024_g(0.0, 10.0, 0.0);
                event.player.func_195064_c(new EffectInstance(Effects.field_204839_B, 400, 3, true, false));
                event.player.func_195064_c(new EffectInstance(Effects.field_188424_y, 200, 9, true, false));
            }
        }
    }

    private static void tickMagnetic(PlayerEntity player, int magneticLevel) {
        if (player.func_213453_ef()) {
            return;
        }
        int range = magneticLevel * 3 + 1;
        Vector3d target = new Vector3d(player.func_226277_ct_(), player.func_226283_e_(0.5), player.func_226281_cx_());
        AxisAlignedBB aabb = new AxisAlignedBB(player.func_226277_ct_() - (double)range, player.func_226278_cu_() - (double)range, player.func_226281_cx_() - (double)range, player.func_226277_ct_() + (double)range + 1.0, player.func_226278_cu_() + (double)range + 1.0, player.func_226281_cx_() + (double)range + 1.0);
        for (ItemEntity entity : player.field_70170_p.func_175647_a(ItemEntity.class, aabb, e -> e.func_70068_e((Entity)player) < (double)(range * range))) {
            if (!GearEvents.canMagneticPullItem(entity)) continue;
            Vector3d vec = entity.func_230268_c_((LivingEntity)player).func_72444_a(target);
            vec = vec.func_72432_b().func_186678_a(0.06);
            if (entity.func_226278_cu_() < target.field_72448_b) {
                double xzDistanceSq = (entity.func_226277_ct_() - target.field_72450_a) * (entity.func_226277_ct_() - target.field_72450_a) + (entity.func_226281_cx_() - target.field_72449_c) * (entity.func_226281_cx_() - target.field_72449_c);
                vec = vec.func_72441_c(0.0, 0.005 + xzDistanceSq / 1000.0, 0.0);
            }
            entity.func_70024_g(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
        }
    }

    private static boolean canMagneticPullItem(ItemEntity entity) {
        return !entity.func_174874_s() && !entity.getPersistentData().func_74767_n("PreventRemoteMovement");
    }

    @SubscribeEvent
    public static void onLivingFall(LivingFallEvent event) {
        ItemStack stack = event.getEntityLiving().func_184582_a(EquipmentSlotType.FEET);
        if (event.getDistance() > 3.0f && GearHelper.isGear(stack) && !GearHelper.isBroken(stack)) {
            int bounce;
            int moonwalker = TraitHelper.getTraitLevel(stack, Const.Traits.MOONWALKER);
            if (moonwalker > 0) {
                float gravity = 1.0f + (float)moonwalker * -0.15f;
                event.setDistance(event.getDistance() * gravity);
                if (event.getEntityLiving() instanceof ServerPlayerEntity) {
                    LibTriggers.GENERIC_INT.trigger((ServerPlayerEntity)event.getEntityLiving(), FALL_WITH_MOONWALKER, 1);
                }
            }
            if ((bounce = TraitHelper.getTraitLevel(stack, Const.Traits.BOUNCE)) > 0 && event.getDistance() > 3.0f && !event.getEntity().func_226272_bl_()) {
                int damage = (int)(event.getDistance() / 3.0f) - 1;
                if (damage > 0) {
                    GearHelper.attemptDamage(stack, damage, event.getEntityLiving(), EquipmentSlotType.FEET);
                }
                event.getEntity().field_70170_p.func_184133_a(null, event.getEntity().func_233580_cy_(), SoundEvents.field_187876_fn, SoundCategory.PLAYERS, 1.0f, 1.0f);
                event.setCanceled(true);
            }
        }
    }

    public static void onPlayerTickBouncing(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.func_184613_cA() && BOUNCE_TICKS.containsKey(event.player)) {
            Vector3d motion = BOUNCE_TICKS.get(event.player);
            event.player.func_213293_j(motion.field_72450_a, motion.field_72448_b * 20.0, motion.field_72449_c);
            event.player.func_230245_c_(false);
            BOUNCE_TICKS.remove(event.player);
            SilentGear.LOGGER.debug("bounce {}", (Object)motion);
            if (event.player.func_213322_ci().field_72448_b < 0.0) {
                GearEvents.bounceEntity((Entity)event.player);
            }
        }
    }

    private static void bounceEntity(Entity entity) {
        Vector3d vector3d = entity.func_213322_ci();
        if (vector3d.field_72448_b < 0.0) {
            Vector3d vec = new Vector3d(vector3d.field_72450_a, -vector3d.field_72448_b * 0.75, vector3d.field_72449_c);
            SilentGear.LOGGER.debug("{} -> {}", (Object)vector3d, (Object)vec);
            BOUNCE_TICKS.put(entity, vec);
        }
    }

    @SubscribeEvent
    public static void onPlayerHurt(LivingHurtEvent event) {
        PlayerEntity player;
        int bounce;
        Entity source;
        if (event.getEntityLiving() instanceof PlayerEntity && (source = event.getSource().func_76364_f()) instanceof LivingEntity && (bounce = TraitHelper.getHighestLevelArmor(player = (PlayerEntity)event.getEntityLiving(), Const.Traits.BOUNCE)) > 0) {
            SilentGear.LOGGER.debug("knockback");
            ((LivingEntity)source).func_233627_a_((float)(2 * bounce), (double)(-MathHelper.func_76126_a((float)(source.field_70177_z * ((float)Math.PI / 180)))), (double)MathHelper.func_76134_b((float)(source.field_70177_z * ((float)Math.PI / 180))));
        }
    }
}

