/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait.condition;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.ITraitCondition;
import net.silentchaos512.gear.api.traits.ITraitConditionSerializer;
import net.silentchaos512.gear.api.util.IGearComponentInstance;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.gear.trait.TraitSerializers;
import net.silentchaos512.gear.util.TextUtil;

public class OrTraitCondition
implements ITraitCondition {
    public static final Serializer SERIALIZER = new Serializer();
    private static final ResourceLocation NAME = SilentGear.getId("or");
    private final ITraitCondition[] children;

    public OrTraitCondition(ITraitCondition ... values) {
        if (values == null || values.length == 0) {
            throw new IllegalArgumentException("Values must not be empty");
        }
        for (ITraitCondition child : values) {
            if (child != null) continue;
            throw new IllegalArgumentException("Value must not be null");
        }
        this.children = (ITraitCondition[])values.clone();
    }

    @Override
    public ResourceLocation getId() {
        return NAME;
    }

    @Override
    public ITraitConditionSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public boolean matches(ITrait trait, PartGearKey key, ItemStack gear, List<? extends IGearComponentInstance<?>> components) {
        for (ITraitCondition child : this.children) {
            if (!child.matches(trait, key, gear, components)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IFormattableTextComponent getDisplayText() {
        ITextComponent text = (ITextComponent)Arrays.stream(this.children).map(ITraitCondition::getDisplayText).reduce((t1, t2) -> t1.func_230529_a_((ITextComponent)TextUtil.translate("trait.condition", "or")).func_230529_a_((ITextComponent)t2)).orElseGet(() -> new StringTextComponent(""));
        return new StringTextComponent("(").func_230529_a_(text).func_240702_b_(")");
    }

    public static class Serializer
    implements ITraitConditionSerializer<OrTraitCondition> {
        @Override
        public ResourceLocation getId() {
            return NAME;
        }

        @Override
        public OrTraitCondition deserialize(JsonObject json) {
            ArrayList<ITraitCondition> children = new ArrayList<ITraitCondition>();
            for (JsonElement j : JSONUtils.func_151214_t((JsonObject)json, (String)"values")) {
                if (!j.isJsonObject()) {
                    throw new JsonSyntaxException("Or condition values must be array of objects");
                }
                children.add(TraitSerializers.deserializeCondition(j.getAsJsonObject()));
            }
            return new OrTraitCondition(children.toArray(new ITraitCondition[0]));
        }

        @Override
        public void serialize(OrTraitCondition value, JsonObject json) {
            JsonArray values = new JsonArray();
            for (ITraitCondition c : value.children) {
                values.add((JsonElement)TraitSerializers.serializeCondition(c));
            }
            json.add("values", (JsonElement)values);
        }

        @Override
        public OrTraitCondition read(PacketBuffer buffer) {
            ArrayList<ITraitCondition> children = new ArrayList<ITraitCondition>();
            int count = buffer.readByte();
            for (int i = 0; i < count; ++i) {
                children.add(TraitSerializers.readCondition(buffer));
            }
            return new OrTraitCondition(children.toArray(new ITraitCondition[0]));
        }

        @Override
        public void write(OrTraitCondition condition, PacketBuffer buffer) {
            buffer.writeByte(condition.children.length);
            for (ITraitCondition child : condition.children) {
                TraitSerializers.writeCondition(child, buffer);
            }
        }
    }
}

