/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.init;

import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.fml.RegistryObject;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.crafting.ingredient.BlueprintIngredient;
import net.silentchaos512.gear.crafting.ingredient.CustomCompoundIngredient;
import net.silentchaos512.gear.crafting.ingredient.GearPartIngredient;
import net.silentchaos512.gear.crafting.ingredient.GearTypeIngredient;
import net.silentchaos512.gear.crafting.ingredient.PartMaterialIngredient;
import net.silentchaos512.gear.crafting.recipe.CombineFragmentsRecipe;
import net.silentchaos512.gear.crafting.recipe.ConversionRecipe;
import net.silentchaos512.gear.crafting.recipe.FillRepairKitRecipe;
import net.silentchaos512.gear.crafting.recipe.GearPartSwapRecipe;
import net.silentchaos512.gear.crafting.recipe.ModKitRemovePartRecipe;
import net.silentchaos512.gear.crafting.recipe.QuickRepairRecipe;
import net.silentchaos512.gear.crafting.recipe.RepairItemRecipeFix;
import net.silentchaos512.gear.crafting.recipe.SGearDamageItemRecipe;
import net.silentchaos512.gear.crafting.recipe.ShapedGearRecipe;
import net.silentchaos512.gear.crafting.recipe.ShapelessCompoundPartRecipe;
import net.silentchaos512.gear.crafting.recipe.ShapelessGearRecipe;
import net.silentchaos512.gear.crafting.recipe.compounder.CompoundingRecipe;
import net.silentchaos512.gear.crafting.recipe.compounder.FabricCompoundingRecipe;
import net.silentchaos512.gear.crafting.recipe.compounder.GemCompoundingRecipe;
import net.silentchaos512.gear.crafting.recipe.compounder.MetalCompoundingRecipe;
import net.silentchaos512.gear.crafting.recipe.press.MaterialPressingRecipe;
import net.silentchaos512.gear.crafting.recipe.press.PressingRecipe;
import net.silentchaos512.gear.crafting.recipe.salvage.CompoundPartSalvagingRecipe;
import net.silentchaos512.gear.crafting.recipe.salvage.GearSalvagingRecipe;
import net.silentchaos512.gear.crafting.recipe.salvage.SalvagingRecipe;
import net.silentchaos512.gear.crafting.recipe.smithing.CoatingSmithingRecipe;
import net.silentchaos512.gear.crafting.recipe.smithing.UpgradeSmithingRecipe;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.init.Registration;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.lib.crafting.recipe.ExtendedShapedRecipe;
import net.silentchaos512.lib.crafting.recipe.ExtendedShapelessRecipe;
import net.silentchaos512.lib.crafting.recipe.ExtendedSingleItemRecipe;

public final class ModRecipes {
    public static final IRecipeType<CompoundingRecipe> COMPOUNDING_TYPE = ModRecipes.registerType(Const.COMPOUNDING);
    public static final IRecipeType<FabricCompoundingRecipe> COMPOUNDING_FABRIC_TYPE = ModRecipes.registerType(Const.COMPOUNDING_FABRIC);
    public static final IRecipeType<GemCompoundingRecipe> COMPOUNDING_GEM_TYPE = ModRecipes.registerType(Const.COMPOUNDING_GEM);
    public static final IRecipeType<MetalCompoundingRecipe> COMPOUNDING_METAL_TYPE = ModRecipes.registerType(Const.COMPOUNDING_METAL);
    public static final IRecipeType<PressingRecipe> PRESSING_TYPE = ModRecipes.registerType(Const.PRESSING);
    public static final IRecipeType<SalvagingRecipe> SALVAGING_TYPE = ModRecipes.registerType(Const.SALVAGING);
    public static final RegistryObject<IRecipeSerializer<?>> COMBINE_FRAGMENTS = ModRecipes.register(Const.COMBINE_FRAGMENTS, () -> new SpecialRecipeSerializer(CombineFragmentsRecipe::new));
    public static final RegistryObject<IRecipeSerializer<?>> COMPOUND_PART = ModRecipes.register(Const.COMPOUND_PART, () -> ExtendedShapelessRecipe.Serializer.basic(ShapelessCompoundPartRecipe::new));
    public static final RegistryObject<IRecipeSerializer<?>> COMPOUNDING = ModRecipes.register(Const.COMPOUNDING, () -> new CompoundingRecipe.Serializer<CompoundingRecipe>(CompoundingRecipe::new));
    public static final RegistryObject<IRecipeSerializer<?>> COMPOUNDING_FABRIC = ModRecipes.register(Const.COMPOUNDING_FABRIC, () -> new CompoundingRecipe.Serializer<GemCompoundingRecipe>(GemCompoundingRecipe::new));
    public static final RegistryObject<IRecipeSerializer<?>> COMPOUNDING_GEM = ModRecipes.register(Const.COMPOUNDING_GEM, () -> new CompoundingRecipe.Serializer<GemCompoundingRecipe>(GemCompoundingRecipe::new));
    public static final RegistryObject<IRecipeSerializer<?>> COMPOUNDING_METAL = ModRecipes.register(Const.COMPOUNDING_METAL, () -> new CompoundingRecipe.Serializer<MetalCompoundingRecipe>(MetalCompoundingRecipe::new));
    public static final RegistryObject<IRecipeSerializer<?>> CONVERSION = ModRecipes.register("conversion", ConversionRecipe.Serializer::new);
    public static final RegistryObject<IRecipeSerializer<?>> DAMAGE_ITEM = ModRecipes.register(Const.DAMAGE_ITEM, SGearDamageItemRecipe.Serializer::new);
    public static final RegistryObject<IRecipeSerializer<?>> FILL_REPAIR_KIT = ModRecipes.register(Const.FILL_REPAIR_KIT, () -> new SpecialRecipeSerializer(FillRepairKitRecipe::new));
    public static final RegistryObject<IRecipeSerializer<?>> MOD_KIT_REMOVE_PART = ModRecipes.register(Const.MOD_KIT_REMOVE_PART, () -> new SpecialRecipeSerializer(ModKitRemovePartRecipe::new));
    public static final RegistryObject<IRecipeSerializer<?>> PRESSING = ModRecipes.register(Const.PRESSING, () -> ExtendedSingleItemRecipe.Serializer.basic(PRESSING_TYPE, PressingRecipe::new));
    public static final RegistryObject<IRecipeSerializer<?>> PRESSING_MATERIAL = ModRecipes.register(Const.PRESSING_MATERIAL, () -> ExtendedSingleItemRecipe.Serializer.basic(PRESSING_TYPE, MaterialPressingRecipe::new));
    public static final RegistryObject<IRecipeSerializer<?>> QUICK_REPAIR = ModRecipes.register(Const.QUICK_REPAIR, () -> new SpecialRecipeSerializer(QuickRepairRecipe::new));
    public static final RegistryObject<IRecipeSerializer<?>> SALVAGING = ModRecipes.register(Const.SALVAGING, SalvagingRecipe.Serializer::new);
    public static final RegistryObject<IRecipeSerializer<?>> SALVAGING_GEAR = ModRecipes.register(Const.SALVAGING_GEAR, GearSalvagingRecipe.Serializer::new);
    public static final RegistryObject<IRecipeSerializer<?>> SALVAGING_COMPOUND_PART = ModRecipes.register(Const.SALVAGING_COMPOUND_PART, CompoundPartSalvagingRecipe.Serializer::new);
    public static final RegistryObject<IRecipeSerializer<?>> SHAPED_GEAR = ModRecipes.register(Const.SHAPED_GEAR_CRAFTING, () -> ExtendedShapedRecipe.Serializer.basic(ShapedGearRecipe::new));
    public static final RegistryObject<IRecipeSerializer<?>> SHAPELESS_GEAR = ModRecipes.register(Const.SHAPELESS_GEAR_CRAFTING, () -> ExtendedShapelessRecipe.Serializer.basic(ShapelessGearRecipe::new));
    public static final RegistryObject<IRecipeSerializer<?>> SMITHING_COATING = ModRecipes.register(Const.SMITHING_COATING, CoatingSmithingRecipe.Serializer::new);
    public static final RegistryObject<IRecipeSerializer<?>> SMITHING_UPGRADE = ModRecipes.register(Const.SMITHING_UPGRADE, UpgradeSmithingRecipe.Serializer::new);
    public static final RegistryObject<IRecipeSerializer<?>> SWAP_GEAR_PART = ModRecipes.register(Const.SWAP_GEAR_PART, () -> new SpecialRecipeSerializer(GearPartSwapRecipe::new));
    public static final RegistryObject<IRecipeSerializer<?>> REPAIR_ITEM_OVERRIDE = ModRecipes.register("crafting_special_repairitem", () -> new SpecialRecipeSerializer(RepairItemRecipeFix::new));

    private ModRecipes() {
    }

    static void register() {
        CraftingHelper.register((ResourceLocation)BlueprintIngredient.Serializer.NAME, (IIngredientSerializer)BlueprintIngredient.Serializer.INSTANCE);
        CraftingHelper.register((ResourceLocation)GearPartIngredient.Serializer.NAME, (IIngredientSerializer)GearPartIngredient.Serializer.INSTANCE);
        CraftingHelper.register((ResourceLocation)GearTypeIngredient.Serializer.NAME, (IIngredientSerializer)GearTypeIngredient.Serializer.INSTANCE);
        CraftingHelper.register((ResourceLocation)PartMaterialIngredient.Serializer.NAME, (IIngredientSerializer)PartMaterialIngredient.Serializer.INSTANCE);
        CraftingHelper.register((ResourceLocation)CustomCompoundIngredient.Serializer.NAME, (IIngredientSerializer)CustomCompoundIngredient.Serializer.INSTANCE);
    }

    private static RegistryObject<IRecipeSerializer<?>> register(String name, Supplier<IRecipeSerializer<?>> serializer) {
        return ModRecipes.register(SilentGear.getId(name), serializer);
    }

    private static RegistryObject<IRecipeSerializer<?>> register(ResourceLocation id, Supplier<IRecipeSerializer<?>> serializer) {
        return Registration.RECIPE_SERIALIZERS.register(id.func_110623_a(), serializer);
    }

    private static <T extends IRecipe<?>> IRecipeType<T> registerType(ResourceLocation typeName) {
        return IRecipeType.func_222147_a((String)typeName.toString());
    }

    public static boolean isRepairMaterial(ItemStack gear, ItemStack materialItem) {
        MaterialInstance mat = MaterialInstance.from(materialItem);
        if (mat != null) {
            return mat.getRepairValue(gear) > 0;
        }
        return false;
    }
}

