/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.ModList;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreArmor;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.client.util.GearClientHelper;
import net.silentchaos512.gear.compat.caelus.CaelusCompat;
import net.silentchaos512.gear.compat.curios.CuriosCompat;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.gear.util.TraitHelper;

public class CoreElytra
extends ElytraItem
implements ICoreArmor {
    private static final int DURABILITY_MULTIPLIER = 25;
    private static final UUID ARMOR_UUID = UUID.fromString("f099f401-82f6-4565-a0b5-fd464f2dc72c");
    private static final List<PartType> REQUIRED_PARTS = ImmutableList.of((Object)PartType.MAIN, (Object)PartType.BINDING);
    private static final Set<ItemStat> RELEVANT_STATS = ImmutableSet.of((Object)ItemStats.DURABILITY, (Object)ItemStats.REPAIR_EFFICIENCY, (Object)ItemStats.ARMOR);
    private static final Set<ItemStat> EXCLUDED_STATS = ImmutableSet.of((Object)ItemStats.REPAIR_VALUE, (Object)ItemStats.HARVEST_LEVEL, (Object)ItemStats.HARVEST_SPEED, (Object)ItemStats.REACH_DISTANCE, (Object)ItemStats.MELEE_DAMAGE, (Object)ItemStats.MAGIC_DAMAGE, (Object[])new ItemStat[]{ItemStats.ATTACK_SPEED, ItemStats.ATTACK_REACH, ItemStats.RANGED_DAMAGE, ItemStats.RANGED_SPEED});

    public CoreElytra(Item.Properties builder) {
        super(builder.func_200918_c(100));
    }

    @Override
    public GearType getGearType() {
        return GearType.ELYTRA;
    }

    @Override
    public Set<ItemStat> getRelevantStats(ItemStack stack) {
        return RELEVANT_STATS;
    }

    @Override
    public Set<ItemStat> getExcludedStats(ItemStack stack) {
        return EXCLUDED_STATS;
    }

    @Override
    public boolean isValidSlot(String slot) {
        return EquipmentSlotType.CHEST.func_188450_d().equalsIgnoreCase(slot) || "back".equalsIgnoreCase(slot);
    }

    @Override
    public Collection<PartType> getRequiredParts() {
        return REQUIRED_PARTS;
    }

    @Override
    public boolean supportsPart(ItemStack gear, PartData part) {
        PartType type = part.getType();
        boolean canAdd = part.get().canAddToGear(gear, part);
        boolean supported = this.requiresPartOfType(part.getType()) && canAdd || canAdd;
        return type == PartType.MAIN && supported || type == PartType.LINING || supported;
    }

    @Override
    public boolean hasTexturesFor(PartType partType) {
        return partType == PartType.MAIN || partType == PartType.BINDING;
    }

    @Override
    public float getRepairModifier(ItemStack stack) {
        return 25.0f;
    }

    @Nullable
    public EquipmentSlotType getEquipmentSlot(ItemStack stack) {
        return EquipmentSlotType.CHEST;
    }

    public int getMaxDamage(ItemStack stack) {
        return 25 * this.getStatInt(stack, this.getDurabilityStat());
    }

    public void setDamage(ItemStack stack, int damage) {
        if (GearHelper.isUnbreakable(stack)) {
            return;
        }
        if (!((Boolean)Config.Common.gearBreaksPermanently.get()).booleanValue()) {
            damage = MathHelper.func_76125_a((int)damage, (int)0, (int)this.getMaxDamage(stack));
        }
        super.setDamage(stack, damage);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return GearHelper.damageItem(stack, amount, entity, t -> {
            GearHelper.onBroken(stack, t instanceof PlayerEntity ? (PlayerEntity)t : null, this.getEquipmentSlot(stack));
            onBroken.accept(t);
        });
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return GearHelper.getIsRepairable(toRepair, repair);
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        GearHelper.inventoryTick(stack, world, (Entity)player, 0, true);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        GearHelper.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        GearHelper.fillItemGroup(this, group, items);
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return TraitHelper.hasTrait(stack, Const.Traits.BRILLIANT);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (ModList.get().isLoaded("curios")) {
            return CuriosCompat.createElytraProvider(stack, this);
        }
        return super.initCapabilities(stack, nbt);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        LinkedHashMultimap multimap = LinkedHashMultimap.create();
        if (this.isValidSlot(slot.func_188450_d())) {
            this.addAttributes(slot.func_188450_d(), stack, (Multimap<Attribute, AttributeModifier>)multimap, true);
        }
        return multimap;
    }

    public void addAttributes(String slot, ItemStack stack, Multimap<Attribute, AttributeModifier> multimap, boolean includeArmor) {
        float armor = this.getStat(stack, ItemStats.ARMOR);
        if (armor > 0.0f && includeArmor) {
            multimap.put((Object)Attributes.field_233826_i_, (Object)new AttributeModifier(ARMOR_UUID, "Elytra armor modifier", (double)armor, AttributeModifier.Operation.ADDITION));
        }
        GearHelper.getAttributeModifiers(slot, stack, multimap, false);
        CaelusCompat.tryAddFlightAttribute(multimap);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return GearHelper.getDisplayName(stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (!ModList.get().isLoaded("caelus")) {
            tooltip.add((ITextComponent)TextUtil.misc("caelusNotInstalled", new Object[0]).func_240699_a_(TextFormatting.RED));
        }
        GearClientHelper.addInformation(stack, worldIn, tooltip, flagIn);
    }
}

