/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.network;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.lib.util.NameUtils;

public class ProspectingResultPacket {
    private final Set<BlockState> blocksFound = new HashSet<BlockState>();

    public ProspectingResultPacket(Set<BlockState> blocksFound) {
        this.blocksFound.addAll(blocksFound);
    }

    public static ProspectingResultPacket decode(PacketBuffer buffer) {
        int count = buffer.func_150792_a();
        HashSet<BlockState> blocks = new HashSet<BlockState>();
        for (int i = 0; i < count; ++i) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(buffer.func_192575_l());
            if (block == null) continue;
            blocks.add(block.func_176223_P());
        }
        return new ProspectingResultPacket(blocks);
    }

    public static void encode(ProspectingResultPacket packet, PacketBuffer buffer) {
        buffer.func_150787_b(packet.blocksFound.size());
        packet.blocksFound.forEach(block -> buffer.func_192572_a(NameUtils.from((IForgeRegistryEntry)block.func_177230_c())));
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            ITextComponent text = (ITextComponent)this.blocksFound.stream().map(state -> state.func_177230_c().func_235333_g_()).reduce((t1, t2) -> t1.func_240702_b_(", ").func_230529_a_((ITextComponent)t2)).orElseGet(() -> TextUtil.translate("item", "prospector_hammer.no_finds"));
            player.func_145747_a((ITextComponent)(!this.blocksFound.isEmpty() ? TextUtil.translate("item", "prospector_hammer.finds", text) : text), Util.field_240973_b_);
        }
        context.get().setPacketHandled(true);
    }
}

