/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import java.util.UUID;
import net.mehvahdjukaar.selene.blocks.IOwnerProtected;
import net.mehvahdjukaar.supplementaries.compat.CompatHandler;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.network.SendSpeakerBlockMessagePacket;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.INameable;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpeakerBlockTile
extends TileEntity
implements INameable,
IOwnerProtected {
    private UUID owner = null;
    public String message = "";
    public boolean narrator = false;
    public double volume = 1.0;
    private ITextComponent customName;
    private final LazyOptional<Object> peripheral = CompatHandler.computercraft ? CompatHandler.getPeripheral(this) : null;

    public SpeakerBlockTile() {
        super((TileEntityType)ModRegistry.SPEAKER_BLOCK_TILE.get());
    }

    public void setCustomName(ITextComponent name) {
        this.customName = name;
    }

    public ITextComponent func_200200_C_() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public ITextComponent func_200201_e() {
        return this.customName;
    }

    public ITextComponent getDefaultName() {
        return new TranslationTextComponent("block.supplementaries.speaker_block");
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = ITextComponent.Serializer.func_240643_a_((String)compound.func_74779_i("CustomName"));
        }
        this.message = compound.func_74779_i("Message");
        this.narrator = compound.func_74767_n("Narrator");
        this.volume = compound.func_74769_h("Volume");
        this.loadOwner(compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (this.customName != null) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        compound.func_74778_a("Message", this.message);
        compound.func_74757_a("Narrator", this.narrator);
        compound.func_74780_a("Volume", this.volume);
        this.saveOwner(compound);
        return compound;
    }

    public void sendMessage() {
        MinecraftServer currentServer = ServerLifecycleHooks.getCurrentServer();
        RegistryKey dimension = this.field_145850_b.func_234923_W_();
        if (currentServer != null && !this.message.equals("")) {
            BlockPos pos = this.func_174877_v();
            this.field_145850_b.func_175641_c(pos, this.func_195044_w().func_177230_c(), 0, 0);
            PlayerList players = currentServer.func_184103_al();
            IFormattableTextComponent message = new StringTextComponent(this.func_200200_C_().getString() + ": " + this.message).func_240699_a_(TextFormatting.ITALIC);
            players.func_148543_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)ServerConfigs.cached.SPEAKER_RANGE * this.volume, dimension, NetworkHandler.INSTANCE.toVanillaPacket((Object)new SendSpeakerBlockMessagePacket((ITextComponent)message, this.narrator), NetworkDirection.PLAY_TO_CLIENT));
        }
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    @NotNull
    public LazyOptional<Object> getPeripheral(@NotNull World world, @NotNull BlockPos pos, @NotNull Direction side) {
        return this.peripheral;
    }
}

