/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.compat.create.behaviors;

import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.foundation.utility.VecHelper;
import javax.annotation.Nonnull;
import net.mehvahdjukaar.supplementaries.block.blocks.BambooSpikesBlock;
import net.mehvahdjukaar.supplementaries.common.CommonUtil;
import net.mehvahdjukaar.supplementaries.compat.create.behaviors.MovementUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.state.Property;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class BambooSpikesBehavior
extends MovementBehaviour {
    public boolean isSameDir(MovementContext context) {
        return VecHelper.isVecPointingTowards((Vector3d)context.relativeMotion, (Direction)((Direction)context.state.func_177229_b((Property)BambooSpikesBlock.FACING)));
    }

    public boolean renderAsNormalTileEntity() {
        return true;
    }

    public void tick(MovementContext context) {
        this.damageEntities(context);
    }

    public void damageEntities(MovementContext context) {
        World world = context.world;
        Vector3d pos = context.position;
        DamageSource damageSource = this.getDamageSource();
        block0: for (Entity entity2 : world.func_217357_a(Entity.class, new AxisAlignedBB(pos.func_72441_c(-0.5, -0.5, -0.5), pos.func_72441_c(0.5, 0.5, 0.5)))) {
            if (entity2 instanceof ItemEntity || entity2 instanceof AbstractContraptionEntity || entity2 instanceof PlayerEntity && ((PlayerEntity)entity2).func_184812_l_()) continue;
            if (entity2 instanceof AbstractMinecartEntity) {
                for (Entity passenger : entity2.func_184182_bu()) {
                    if (!(passenger instanceof AbstractContraptionEntity) || ((AbstractContraptionEntity)passenger).getContraption() != context.contraption) continue;
                    continue block0;
                }
            }
            if (entity2.func_70089_S() && entity2 instanceof LivingEntity && !world.field_72995_K) {
                double pow = 5.0 * Math.pow(context.relativeMotion.func_72433_c(), 0.4) + 1.0;
                float damage = !this.isSameDir(context) ? 1.0f : (float)MathHelper.func_151237_a((double)pow, (double)2.0, (double)6.0);
                entity2.func_70097_a(damageSource, damage);
                this.doTileStuff(context, world, (LivingEntity)entity2);
            }
            if (world.field_72995_K != entity2 instanceof PlayerEntity) continue;
            Vector3d motionBoost = context.motion.func_72441_c(0.0, context.motion.func_72433_c() / 4.0, 0.0);
            int maxBoost = 4;
            if (motionBoost.func_72433_c() > (double)maxBoost) {
                motionBoost = motionBoost.func_178788_d(motionBoost.func_72432_b().func_186678_a(motionBoost.func_72433_c() - (double)maxBoost));
            }
            entity2.func_213317_d(entity2.func_213322_ci().func_178787_e(motionBoost));
            entity2.field_70133_I = true;
        }
    }

    private void doTileStuff(MovementContext context, @Nonnull World world, LivingEntity le) {
        CompoundNBT com = context.tileData;
        if (com == null) {
            return;
        }
        int charges = com.func_74762_e("Charges");
        long lastTicked = com.func_74763_f("LastTicked");
        Potion potion = PotionUtils.func_185187_c((CompoundNBT)com);
        if (potion != Potions.field_185229_a && charges > 0 && !this.isOnCooldown(world, lastTicked)) {
            boolean used = false;
            for (EffectInstance effect : potion.func_185170_a()) {
                if (!le.func_70687_e(effect) || le.func_70644_a(effect.func_188419_a())) continue;
                if (effect.func_188419_a().func_76403_b()) {
                    float health = 0.5f;
                    effect.func_188419_a().func_180793_a(null, null, le, effect.func_76458_c(), (double)health);
                } else {
                    le.func_195064_c(new EffectInstance(effect.func_188419_a(), (int)((float)effect.func_76459_b() * 0.1f), effect.func_76458_c()));
                }
                used = true;
            }
            if (used) {
                lastTicked = world.func_82737_E();
                if (--charges <= 0) {
                    charges = 0;
                    potion = Potions.field_185229_a;
                    MovementUtils.changeState(context, (BlockState)context.state.func_206870_a((Property)BambooSpikesBlock.TIPPED, (Comparable)Boolean.valueOf(false)));
                }
                com.func_82580_o("Charges");
                com.func_82580_o("LastTicked");
                com.func_82580_o("Potion");
                com.func_74768_a("Charges", charges);
                com.func_74772_a("LastTicked", lastTicked);
                com.func_74778_a("Potion", Registry.field_212621_j.func_177774_c((Object)potion).toString());
                context.tileData = com;
            }
        }
    }

    public boolean isOnCooldown(World world, long lastTicked) {
        return world.func_82737_E() - lastTicked < 20L;
    }

    protected DamageSource getDamageSource() {
        return CommonUtil.SPIKE_DAMAGE;
    }
}

