/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.items;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.mehvahdjukaar.supplementaries.common.Textures;
import net.mehvahdjukaar.supplementaries.common.capabilities.SupplementariesCapabilities;
import net.minecraft.block.BlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;

public class AntiqueInkItem
extends Item {
    public AntiqueInkItem(Item.Properties p_i48487_1_) {
        super(p_i48487_1_);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        AtomicBoolean success = new AtomicBoolean(false);
        BlockPos pos = context.func_195995_a();
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null) {
            LazyOptional cap = tile.getCapability(SupplementariesCapabilities.ANTIQUE_TEXT_CAP);
            cap.ifPresent(c -> {
                c.setAntiqueInk(true);
                success.set(true);
            });
            if (!success.get()) {
                CompoundNBT tag = tile.func_189515_b(new CompoundNBT());
                Optional<CompoundNBT> newTag = this.modifyAllTextRecursive(tag, Textures.ANTIQUABLE_FONT, tag.func_74737_b());
                newTag.ifPresent(t -> {
                    BlockState state = world.func_180495_p(pos);
                    tile.func_230337_a_(state, (CompoundNBT)newTag.get());
                    tile.func_70296_d();
                    success.set(true);
                });
            }
        }
        if (success.get()) {
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        return ActionResultType.SUCCESS;
    }

    private Optional<CompoundNBT> modifyAllTextRecursive(CompoundNBT tag, ResourceLocation font, CompoundNBT newTag) {
        boolean modified = false;
        Set keys = tag.func_150296_c();
        for (String k : keys) {
            IFormattableTextComponent text;
            String s;
            INBT nbt = tag.func_74781_a(k);
            if (nbt instanceof CompoundNBT) {
                modified = this.modifyAllTextRecursive((CompoundNBT)nbt, font, newTag).isPresent();
                continue;
            }
            if (!(nbt instanceof StringNBT) || !(s = nbt.func_150285_a_()).contains("{\"text\":") || (text = ITextComponent.Serializer.func_240643_a_((String)s)) == null) continue;
            ITextComponent newText = this.applyFontRecursive((ITextComponent)text, font);
            String newString = ITextComponent.Serializer.func_150696_a((ITextComponent)newText);
            newTag.func_82580_o(k);
            newTag.func_74778_a(k, newString);
            modified = true;
        }
        if (modified) {
            return Optional.of(newTag);
        }
        return Optional.empty();
    }

    private ITextComponent applyFontRecursive(ITextComponent text, ResourceLocation font) {
        if (text instanceof IFormattableTextComponent) {
            ((IFormattableTextComponent)text).func_230530_a_(text.func_150256_b().func_240719_a_(font));
        }
        text.func_150253_a().forEach(sib -> this.applyFontRecursive((ITextComponent)sib, font));
        return text;
    }
}

