/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.crafting.block;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.darkhax.bookshelf.crafting.block.BlockIngredient;
import net.darkhax.bookshelf.crafting.block.IBlockIngredientSerializer;
import net.darkhax.bookshelf.serialization.Serializers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;

public class BlockIngredientCheckTag
extends BlockIngredient {
    public static final ResourceLocation ID = new ResourceLocation("bookshelf", "check_tag");
    public static final Serializer SERIALIZER = new Serializer();
    private final ITag.INamedTag<Block> tag;
    private List<BlockState> cache;

    public BlockIngredientCheckTag(ITag.INamedTag<Block> tag) {
        this.tag = tag;
    }

    @Override
    public boolean test(BlockState t) {
        this.buildCache();
        return this.cache.contains(t);
    }

    @Override
    public Collection<BlockState> getValidStates() {
        this.buildCache();
        return this.cache;
    }

    @Override
    public ResourceLocation getSerializeId() {
        return ID;
    }

    private void buildCache() {
        if (this.cache == null) {
            this.cache = new ArrayList<BlockState>();
            for (Block block : this.tag.func_230236_b_()) {
                block.func_176194_O().func_177619_a().forEach(this.cache::add);
            }
        }
    }

    static class Serializer
    implements IBlockIngredientSerializer<BlockIngredientCheckTag> {
        Serializer() {
        }

        @Override
        public BlockIngredientCheckTag read(JsonElement json) {
            ITag.INamedTag<Block> tag = Serializers.BLOCK_TAG.read(json.getAsJsonObject(), "tag");
            return new BlockIngredientCheckTag(tag);
        }

        @Override
        public JsonElement write(BlockIngredientCheckTag ingredient) {
            JsonObject obj = new JsonObject();
            obj.add("tag", Serializers.BLOCK_TAG.write((ITag.INamedTag<Block>)ingredient.tag));
            return obj;
        }

        @Override
        public BlockIngredientCheckTag read(PacketBuffer buf) {
            ITag.INamedTag<Block> tag = Serializers.BLOCK_TAG.read(buf);
            return new BlockIngredientCheckTag(tag);
        }

        @Override
        public void write(PacketBuffer buf, BlockIngredientCheckTag ingredient) {
            Serializers.BLOCK_TAG.write(buf, (ITag.INamedTag<Block>)ingredient.tag);
        }
    }
}

